//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// exit.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include "exit.h"

// atexit() œo^ł֐̍ő.
#define AT_EXIT_MAX (4)

static uint8_t n_registered = 0;
static void(*at_exit_funcs[AT_EXIT_MAX])(void);

int atexit(void(*func)(void))
{
	if(AT_EXIT_MAX <= n_registered)
		return 1;

	at_exit_funcs[n_registered] = func;
	++n_registered;
	return 0;
}

void exit_dos(int8_t exit_status);
#pragma aux exit_dos = \
"  mov  ah, 4ch	" \
"  int  21h		" \
parm[ ax ];

void exit(int8_t exit_status)
{
	for(uint8_t i = 0; i < n_registered; ++i)
	{
		void(*func)(void) = at_exit_funcs[i];
		(*func)();
	}

	exit_dos(exit_status); // Ăяo int 21h (ah=4ch) ŏI.
}
