;--------------------------------------------------------
; N2KC MML Compiler for N2KD version 1.0a (beta 2b)
; fileio.asm
; Copyright (C) 2021-2026 Y. Shiokami
; Released under the 3-clause BSD License.
;--------------------------------------------------------

; DOS p stdio.h ̃t@C֌W̌݊.
.186
.model small, farstack

DGROUP GROUP _DATA
ASSUME CS:_TEXT, DS:DGROUP

_TEXT SEGMENT PUBLIC USE16 'CODE'


;=== uint16_t dos_open_file(const char* filename, const uint16_t mode) ̎.
; : ds:ax=t@C.
;	dx=[h(0: read, 1: write, 2: append)
; ߒl: (: t@Cnh, s: 0)
; MS-DOS ł̓t@Cnh 0 ͕W͂ɗ\񂳂Ă.
; ̂߁Å֐ŕW͂JƐsɂȂ̂Œ.
dos_open_file_ PROC PUBLIC
	push	bx
	push	dx
	xchg	ax, dx			; al=[h, ds:dx=t@C.
	cmp	ax, 1
	je	Lcreate_empty
	cmp	ax, 2
	je	Lappend
	mov	ah, 3dh
	int	21h			; open file (al=mode, ds:dx=path)
	jnc	L1
Lerr:	xor	ax, ax
L1:	pop	dx
	pop	bx
	ret
	;--- t@C݂Ȃɂ^Cṽt@C쐬.
Lcreate_empty:
	push	cx
	xor	cx, cx			; t@CȂ(ʂ̃t@C)
	mov	ah, 3ch
	int	21h			; t@C쐬(ݎ0oCgɂ)
	pop	cx			; pop ̓tOɉeȂ.
	jnc	L1
	jmp	Lerr
	;--- t@CJăt@C|C^𖖔Ɉڂ.
Lappend:
	mov	ah, 3dh
	int	21h			; open file (ds:dx=path)
	jnc	L2
	cmp	ax, 2			; t@C݂Ȃꍇ쐬.
	je	Lcreate_empty
	jmp	Lerr
L2:	push	cx			; t@C|C^𖖔Ɉړ.
	mov	bx, ax
	mov	ax, 4202h
	xor	cx, cx
	xor	dx, dx
	int	21h			; move file pointer (ah=42h)
	pop	cx
	mov	ax, bx
	jmp	L1
dos_open_file_ ENDP


;=== int16_t dos_close_file(const uint16_t handle) ̎.
; : ax=t@Cnh.
; ߒl: =(: 0, s: 0)
dos_close_file_ PROC PUBLIC
	push	bx
	mov	bx, ax
	mov	ah, 3eh
	int	21h		; close(bx=t@Cnh)
	mov	ax, 0		; CF ωȂ.
	sbb	ax, 0		; G[Ȃ CF=1 Ȃ̂ ax=-1 ɂȂ.
	pop	bx
	ret
dos_close_file_ ENDP


;=== size_t dos_read_file(const uint16_t handle, const char* buffer,
;						const uint16_t len) ̎.
; : ax=t@Cnh.
;	ds:dx=ǂݍݐ̃AhX.
;	bx=ǂݍޗ.
; ߒl: ǂ񂾃oCg.
dos_read_file_ PROC PUBLIC
	push	cx
	xchg	bx, ax		; bx=t@Cnh.
	mov	cx, ax		; cx=ǂރoCg.
	mov	ah, 3fh
	int	21h
	jnc	@F
	xor	ax, ax
@@:	pop	cx
	ret
dos_read_file_ ENDP


;=== uint16_t dos_write_file(const uint16_t handle,
;		const uint8_t __far* buffer, const uint16_t len) ̎.
; : ax=t@Cnh.
;	cx:bx=of[^̂obt@.
;	dx=.
; ߒl: .
; ̏Ԃ ax, dx, bx, cx ̏łȂ̂Œ.
dos_write_file_ PROC PUBLIC
	push	ds
	mov	ds, cx
	mov	cx, dx		; cx=ooCg.
	mov	dx, bx		; ds:dx=of[^ʒu.
	mov	bx, ax		; bx=t@Cnh.
	mov	ah, 40h
	int	21h
	jnc	@F
	xor	ax, ax
@@:	pop	ds
	ret
dos_write_file_ ENDP


;=== int32_t dos_get_filesize(const uint16_t handle) ̎.
; : ax=t@Cnh.
; ߒl: dx:ax=t@CTCY(int32_t), G[Ȃ-1
dos_get_filesize_ PROC PUBLIC
	push	bx
	push	si
	push	di
	push	cx		; dx ͖߂lɂȂ̂ cx ̂ push
	mov	bx, ax
	xor	cx, cx
	xor	dx, dx
	mov	ax, 4201h	; mode=SEEK_CUR
	int	21h		; move file pointer -> dx:ax=.
	jc	dos_get_filesize_err
	mov	di, dx
	mov	si, ax		; save orig file pointer pos to di:si
	xor	dx, dx
	mov	ax, 4202h	; mode=SEEK_CUR
	int	21h		; t@CTCY𓾂 -> dx:ax=.
	jc	dos_get_filesize_err
	xchg	di, dx
	xchg	si, ax		; t@CTCYƌ̈ʒu.
	mov	cx, dx
	mov	dx, ax		; cx:dx=̃t@C|C^̈ʒu.
	mov	ax, 4200h	; mode==SEEK_SET.
	int	21h		; t@C|C^ŏ̈ʒuɖ߂.
	jc	dos_get_filesize_err
	mov	dx, di
	mov	ax, si
	pop	cx
	pop	di
	pop	si
	pop	bx
	ret
dos_get_filesize_err:
	pop	cx
	pop	di
	pop	si
	pop	bx
	mov	ax, -1
	mov	dx, -1
	ret
dos_get_filesize_ ENDP


;=== int16_t dos_seek_file(const uint16_t handle, int32_t offset,
;						uint8_t origin) ̎.
; : ax=t@Cnh.
;	cx:bx=ItZbg.
;	dl=origin
; ߒl: (: 0, s: 0)
dos_seek_file_ PROC PUBLIC
	push	dx
	push	bx
	xchg	ax, bx		; bx=handle
	xchg	ax, dx		; cx:dx=offset, al=origin
	mov	ah, 42h
	int	21h		; dx:ax=ړ̈ʒu.
	jc	@F		; G[ ax ͔0Ȃ̂ł̂܂܂ł悢.
	xor	ax, ax
@@:	pop	bx
	pop	dx
	ret
dos_seek_file_ ENDP


;=== int16_t dos_remove_file(const char* filename) ̎.
; : ds:ax=t@C.
; ߒl: (: 0, s: 0)
dos_remove_file_ PROC PUBLIC
	push	dx
	mov	dx, ax
	mov	ah, 41h
	int	21h		; t@C폜(ah=41h, ds:dx=t@C)
	jc	@F		; G[ ax ͔0Ȃ̂ł̂܂.
	xor	ax, ax
@@:	pop	dx
	ret
dos_remove_file_ ENDP


_TEXT ENDS

END
