//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// fileio.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include "../util/fileio_l.h"

// fileio_dos.asm Œ`Ă֐.
uint16_t dos_open_file(const char* filename, const uint16_t mode);
int16_t dos_close_file(const uint16_t handle);
size_t dos_read_file(const uint16_t handle, const char* buffer, const uint16_t len);
uint16_t dos_write_file(const uint16_t handle, const uint8_t ___FAR* buffer, const uint16_t len);
int32_t dos_get_filesize(const uint16_t handle);
int16_t dos_seek_file(const uint16_t handle, int32_t offset, uint8_t origin);
int16_t dos_remove_file(const char* filename);

FILEIO_STATUS open_file(const char* filename, const uint16_t mode, FILE_HANDLE* handle)
{
	*handle = dos_open_file(filename, mode);
	if(*handle == 0) return -1;
	return 0;
}

FILEIO_STATUS close_file(FILE_HANDLE handle)
{
	return dos_close_file(handle);
}

size_t read_file(FILE_HANDLE handle, char* buffer, const size_t len)
{
	return dos_read_file(handle, buffer, len);
}

size_t write_file(FILE_HANDLE handle, const uint8_t ___FAR* buffer, const size_t len)
{
	return dos_write_file(handle, buffer, len);
}

FILE_SIZE get_filesize(FILE_HANDLE handle)
{
	return dos_get_filesize(handle);
}

FILEIO_STATUS seek_file(FILE_HANDLE handle, int32_t offset, uint8_t origin)
{
	return dos_seek_file(handle, offset, origin);
}

FILEIO_STATUS remove_file(const char* filename)
{
	return dos_remove_file(filename);
}
