//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// muldiv32.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include "../util/muldiv32.h"

// 킴0Z֐ (mul_div_32.asm Œ`Ă)
// JȂ֐̂߁AŃvg^Cv錾.
void div_zero();

// : a=폜, b=, mode=(0:߂, 0:]߂)
// ߒl: vZ.
static uint32_t div_mod_u32(uint32_t a, uint32_t b, uint8_t mode)
{
	// a, b ƉLbV(̂߃}`XbhΉłȂ)
	static uint32_t cache_a = 1;
	static uint32_t cache_b = 1;
	static uint32_t cache_q = 1;
	static uint32_t cache_r = 0;

	// 0ŏZ.
	if(b == 0) { div_zero(); return 0; }

	// LbVqbg.
	if(a == cache_a && b == cache_b) goto return_value;
	// qbgȂ.
	cache_a = a;
	cache_b = b;

	// 0Z.
	if(a == 0)
	{
		cache_q = cache_r = 0;
		goto return_value;
	}

	// .
	if(a == b)
	{
		cache_q = 1;
		cache_r = 0;
		goto return_value;
	}

	// 폜̂ق.
	if(a < b)
	{
		cache_q = 0;
		cache_r = a;
		goto return_value;
	}

	uint32_t mask;
	uint8_t msb_pos_a = 31, msb_pos_b = 31;

	// a, b  MSB ʒuvZ.
	mask = 0x80000000;
	while(mask != 0)
	{
		if(a & mask) break;
		msb_pos_a -= 1;
		mask >>= 1;
	}
	mask = 0x80000000;
	while(mask != 0)
	{
		if(b & mask) break;
		msb_pos_b -= 1;
		mask >>= 1;
	}
	// b Vtg MSB ̈ʒu𑵂.
	uint8_t n_shl_b = msb_pos_a - msb_pos_b;
	b <<= n_shl_b;

	// Z[v.
	uint32_t q = 0;
	for(uint8_t i = 0; i <= n_shl_b; ++i)
	{
		q <<= 1;
		if(a >= b)
		{
			q += 1;
			a = a - b;
		}
		b >>= 1;
	}

	cache_q = q;
	cache_r = a;

return_value:
	if(mode == 0) return cache_q;
	return cache_r;
}

// : a=폜, b=, mode=(0:߂, 0:]߂)
// ߒl: vZ.
static int32_t div_mod_i32(int32_t a, int32_t b, uint8_t mode)
{
	if(b == 0) { div_zero(); return 0; }
	if(a == 0) return 0;

	// 0x80000000 ̕ς 0x7fffffff ̂ŕʏ.
	if(b == 0x80000000)
	{
		if(a == 0x80000000)
		{
			if(mode == 0) return 1;
			return 0;
		}
		if(mode == 0) return 0;
		return a;
	}

	if(a == 0x80000000)
	{
		// 폜̐Βl1ƂɂďZs.
		const uint8_t b_minus = (b < 0);
		const int32_t tmp_b = b_minus ? -b : b;
		int32_t q = (int32_t)div_mod_u32(0x7fffffff, tmp_b, 0);
		int32_t r = (int32_t)div_mod_u32(0x7fffffff, tmp_b, 1);
		// 덇킹.
		r = -r - 1;
		if(b == r || b == -r)
		{
			r = 0;
			q += 1;
		}
		if(!b_minus) q = -q;
		if(mode == 0) return q;
		return r;
	}

	int32_t ret;
	if(0 < a)
	{
		if(0 < b)
			ret = (int32_t)div_mod_u32(a, b, mode);
		else
		{
			ret = (int32_t)div_mod_u32(a, -b, mode);
			if(mode == 0) ret = -ret;
		}
	}
	else
	{
		if(0 < b)
		{
			ret = (int32_t)div_mod_u32(-a, b, mode);
			ret = -ret;
		}
		else
		{
			ret = (int32_t)div_mod_u32(-a, -b, mode);
			if(mode == 1) ret = -ret;
		}
	}
	return ret;
}

uint32_t div_u32(uint32_t a, uint32_t b)
{
	return div_mod_u32(a, b, 0);
}

uint32_t mod_u32(uint32_t a, uint32_t b)
{
	return div_mod_u32(a, b, 1);
}

int32_t div_i32(int32_t a, int32_t b)
{
	return div_mod_i32(a, b, 0);
}

int32_t mod_i32(int32_t a, int32_t b)
{
	return div_mod_i32(a, b, 1);
}
