//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// qsort.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include "../util/qsort.h"

// qsort()  DOS p̌݊.
void n2kd_qsort(void ___FAR* base, size_t n_entries, size_t entry_size, int (*compare)(const void ___FAR*, const void ___FAR*))
{
	if(n_entries <= 1) return;

	// 芸R[\[gŎ.
	size_t h = (n_entries * 10) / 13;

	while(1)
	{
		uint8_t swapped = 0;
		for(size_t i = 0; i + h < n_entries; ++i)
		{
			uint8_t ___FAR* elem_l = (uint8_t ___FAR*)base + (i * entry_size);
			uint8_t ___FAR* elem_r = (uint8_t ___FAR*)base + ((i + h) * entry_size);
			const int result = (*compare)(elem_l, elem_r);
			if(0 < result)
			{
				// (base + i) ̕傫.
				for(size_t j = 0; j < entry_size; ++j)
				{
					// xor swap
					*elem_l ^= *elem_r;
					*elem_r ^= *elem_l;
					*elem_l ^= *elem_r;
					++elem_l;
					++elem_r;
				}
				swapped = 1;
			}
		}

		if(h == 1)
		{
			if(!swapped) break;
		}
		else h = h * 10 / 13;
	}
}
