//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// start.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include <stdint.h>

#include "../main.h"
#include "../far_ptr.h"

#include "../util/str_proc.h"
#include "../util/string.h"

// Open Watcom  PATH_MAX Ɠl.
#define PATH_MAX (143)

static int16_t argc;
static char* argv[16]; //  16 ܂ŃvO.
static char my_name[PATH_MAX + 1];
static char argstr[0x7e + 1]; // dos ͍̈̕ő 7e .

// ̖Oobt@ɃRs[.
//  -> dx:ax: ϐ̈ far AhX.
void copy_my_name(const char ___FAR* envvars)
{
	++envvars; // 2AkT̂1i߂Ă.
	while(1)
	{
		if(envvars[-1] == '\0' && envvars[0] == '\0')
			break;
		++envvars;
	}
	envvars += 3; // ̖O̐擪ɍ킹.

	uint16_t i = 0;
	for(i = 0; envvars[i] != '\0' && i < (PATH_MAX + 1); ++i)
		my_name[i] = envvars[i];
	my_name[i] = '\0';

	argc = 1;
	argv[0] = my_name;
}

// p[X⏕֐.
// str[idx] ȍ~ŃvO̐擪ƂȂ镶̓YԂ.
// ̂悤ȕꍇ 0xff Ԃ((dos ̍ő) < 0xff Ȃ̂ŖȂ)
static uint8_t find_next_argstr(const char* str, uint8_t idx)
{
	char c;
	while((c = str[idx]) != '\0')
	{
		if(!is_whitespace(c))
			return idx;
		idx += 1;
	}
	return 0xff;
}

// str[idx] n܂vO̖̎̓̕YԂ.
// mode=ǂp[X(0: NI[gO, 1: _uNI[g)
// _uNI[g̏ꍇ́Auv܂ňŏ.
static uint8_t find_end_of_argstr(const char* str, uint8_t idx)
{
	const uint8_t orig_idx = idx;

	// [h.
	uint8_t mode = 0;
	if(str[idx] == '"')
	{
		mode = 1;
		idx += 1;
	}

	// mode=(0,1) ̃p[Xɍŏɏo󔒕̈ʒu.
	// uvȂ̏ꍇɂ͂̈ʒuԂKv.
	// 0xff Ȃ󔒕͖o(0xff  dos ̍ő傫̂ŖȂ)
	uint8_t first_white_idx = 0xff;

	// p[X{.
	char c;
	c = 0;	// Ő錾sƈȉ̃xRpCG[ɂȂ̂ł̖h~p.
parse_restart:
	if(mode != 0)
	{
		// NI[gȂuvT.
		while(1)
		{
			c = str[idx];

			// ŏ̋󔒂̈ʒuL^.
			if(first_white_idx == 0xff && is_whitespace(c)) first_white_idx = idx;

			if(c == '\0') // uvȂŕ񖖔ɓB.
			{
				if(first_white_idx != 0xff) idx = first_white_idx;
				break;
			}
			else if(c == '"')
			{
				uint8_t escaped = 0;
				// GXP[vmF(ł1͖߂邪A2͖߂ȂȂ).
				if(str[idx - 1] == '\\')
				{
					if(idx < orig_idx + 2) escaped = 1; // 2߂ȂȂGXP[vĂ.
					else
					{
						if(!is_sjis_first_byte(str[idx - 2]))
							escaped = 1; // 2߂āAsjis 1oCgȂ΃GXP[vĂ.
					}
				}
				// GXP[vĂΑs.
				if(escaped) { idx += 1; continue; }
				// uv̎̕ɂĕ.
				c = str[idx + 1];
				if(c == '\0' || is_whitespace(c)) { idx += 1; break; }
				else if(c == '"') { idx += 1; goto parse_restart; }
				else { mode = 0; idx += 1; goto parse_restart; }
			}
			else { idx += 1; }
		}
	}
	else
	{
		// NI[gOȂ當񖖔󔒕T.
		while((c = str[idx]) != '\0')
		{
			if(is_whitespace(c))
				break;
			else if(c == '"')
			{
				uint8_t escaped = 0;
				if((orig_idx + 1 <= idx) && (str[idx - 1] == '\\'))
				{
					if(idx < orig_idx + 2) escaped = 1;
					else { if(!is_sjis_first_byte(str[idx - 2])) escaped = 1; }
				}
				// GXP[vĂȂNI[gĂ烂[h؂ւ.
				mode = 1;
				idx += 1;
				goto parse_restart;
			}
			idx += 1;
		}
	}
	return idx;
}

// str[begin] n܂镶̃_uNI[gƃobNXbV菜Đ`.
// 擪 str[begin] ŕςȂ.
static void remove_quote(char* str, const uint8_t begin)
{
	uint8_t end = begin + strlen(str + begin);
	uint8_t idx = begin;
	while(idx < end)
	{
		if (str[idx] != '"') { idx += 1; continue; }

		uint8_t escaped = 0;
		if((begin + 1 <= idx) && (str[idx - 1] == '\\'))
		{
			if(idx < begin + 2) escaped = 1;
			else { if(!is_sjis_first_byte(str[idx - 2])) escaped = 1; }
		}

		// _uNI[gGXP[vĂꍇ̓obNXbV.
		if(escaped)
		{
			for(uint8_t i = idx - 1; i < end; ++i)
				str[i] = str[i + 1];
			end -= 1; // 񒷂1ZȂ.
			continue;
		}

		// GXP[vĂȂ_uNI[g𔭌㑱̕1Oɓ.
		for(uint8_t i = idx; i < end; ++i)
			str[i] = str[i + 1];
		end -= 1;
	}
}

// vOp[X.
//  -> dx:ax: , bx: .
void parse_argstr(const char ___FAR* far_argstr, const uint8_t argstr_len)
{
	// argstr ɈRs[.
	for(uint8_t i = 0; i < argstr_len; ++i)
		argstr[i] = far_argstr[i];
	argstr[argstr_len] = '\0';

	// p[X͈ȉ̎菇ōs.
	// 1. ̐擪ɂȂ镶T.
	// 2. 菇1Ōȍ~ň̖ɂȂ镶T.
	// 3. ͈̔͂܂Kvɉă_uNI[g֌W̐`s.
	// 4. 菇2Ō̎̕A菇1.ɖ߂ăp[XēxKp.
	uint8_t idx = 0;
	while(idx < argstr_len && argc < 16)
	{
		const uint8_t begin = find_next_argstr(argstr, idx);
		if(begin == 0xff)
			break;
		const uint8_t end = find_end_of_argstr(argstr, begin);
		argstr[end] = '\0';

		remove_quote(argstr, begin);

		argv[argc] = argstr + begin;
		argc += 1;

		idx = end + 1;
	}
}

// dos ̏IR[h al Ȃ̂ int8_t Ԃ.
int8_t main2()
{
	return n2kc_main(argc, argv);
}
