;--------------------------------------------------------
; N2KC MML Compiler for N2KD version 1.0a (beta 2b)
; string.asm
; Copyright (C) 2021-2026 Y. Shiokami
; Released under the 3-clause BSD License.
;--------------------------------------------------------

.186
.model small, farstack

DGROUP GROUP _DATA
ASSUME CS:_TEXT, DS:DGROUP


EXTERN exit_internal_error_:near


_TEXT SEGMENT PUBLIC USE16 'CODE'

;=== void* memmove(void __far* dest, const void __far* src, size_t len) ̎.
; : dx:ax=Rs[, cx:bx=Rs[, [stack]=Rs[钷.
; ߒl: dest
; X^bN:
; (L)[ dx  | ax  | cx  | bx  | bp  | di  | si  | ds  | es  | ret | len ](H)
;    ^sp   ^-6   ^-4   ^-2   ^bp   ^+2   ^+4   ^+6   ^+8   ^+10  ^+12
memmove_ PROC PUBLIC
	push	es
	push	ds
	push	si
	push	di
	push	bp
	mov	bp, sp
	sub	sp, 8	; 8 bytes local stack
	;--- len == 0 Ȃ瑦 ret
	cmp	word ptr [bp + 12], 0
	jnz	len_not_zero
exit:	mov	sp, bp
	pop	bp
	pop	di
	pop	si
	pop	ds
	pop	es
	ret	2
len_not_zero:
	;--- len != 0 ̎.
	; ZOgǂ`FbN.
	cmp	dx, cx
	jnz	different_seg
	;--- ZOg.
	cmp	ax, bx
	jz	exit		; dx:ax == cx:bx ȂRs[Ȃ.
	mov	ds, dx
	mov	es, dx
	mov	di, ax
	mov	si, bx
	push	cx
	mov	cx, [bp + 12]	; cx = len
	jb	@F	; ax < bx (dest < src)? (܂ŃtOωȂ)
	; src < dest Ȃ납Rs[.
	call	memmove_from_back
	jmp	move_end
@@:	; dest < src ȂORs[.
	call	memmove_from_front
move_end:
	pop	cx
	jmp	exit
different_seg:
	; ̎ł͂ɂ͗ȂȂ̂ŃG[ɂĂ.
	; ZOgႤꍇ̎̃fobOs\Ȃ.
	mov	ax, 0030h
	call	exit_internal_error_
	;--- ZOgႤ.
	mov	[bp - 2], bx	; ۑ.
	mov	[bp - 4], cx
	mov	[bp - 6], ax
	mov	[bp - 8], dx
	; 20 bit ̃AhXvZ(dest)
	mov	di, ax	; save ax (offset)
	mov	ax, dx
	xor	dx, dx
	shl	ax, 1
	rcl	dx, 1
	shl	ax, 1
	rcl	dx, 1
	shl	ax, 1
	rcl	dx, 1
	shl	ax, 1
	rcl	dx, 1	; [dx:ax] = (dx << 4)
	add	ax, di
	adc	dx, 0	; [dx:ax] = (dx << 4) + ax
	; 20 bit ̃AhXvZ(src)
	mov	di, bx	; save bx (offset)
	mov	bx, cx
	xor	cx, cx
	shl	bx, 1
	rcl	cx, 1
	shl	bx, 1
	rcl	cx, 1
	shl	bx, 1
	rcl	cx, 1
	shl	bx, 1
	rcl	cx, 1	; [cx:bx] = (cx << 4)
	add	bx, di
	adc	cx, 0	; [cx:bx] = (cx << 4) + bx
	; AhXr.
	cmp	dx, cx
	jnz	@F
	cmp	ax, bx
exit2:	mov	dx, [bp - 8]
	mov	ax, [bp - 6]
	mov	cx, [bp - 4]
	mov	bx, [bp - 2]
	jmp	exit		; AhXRs[Ȃ.
@@:	; Rs[.
	mov	di, [bp - 8]
	mov	si, [bp - 4]
	mov	es, di
	mov	ds, si
	mov	di, [bp - 6]	; es:di = dx:ax
	mov	si, [bp - 2]	; ds:si = cx:bx
	; AhXr(2)
	cmp	dx, cx
	jb	@F
	cmp	ax, bx
	jb	@F
	; src < dest Ȃ납Rs[.
	mov	cx, [bp + 12]
	call	memmove_from_back
	jmp	exit2
@@:	; dest < src ȂORs[.
	mov	cx, [bp + 12]
	call	memmove_from_front
	jmp	exit2
memmove_ ENDP

; : es:di=Rs[, ds:si=Rs[, cx=Rs[钷.
; ߒl: .
; j: di, si, cx
memmove_from_front PROC PRIVATE
	shr	cx, 1
	rep	movsw	; es:[di] = ds:[si]
	rcl	cx, 1
	rep	movsb	; es:[di] = ds:[si]
	ret
memmove_from_front ENDP

; : es:di=Rs[, ds:si=Rs[, cx=Rs[钷.
; ߒl: .
; j: di, si, cx
memmove_from_back PROC PRIVATE
	std
	add	di, cx
	add	si, cx
	sub	di, 2
	sub	si, 2
	shr	cx, 1
	rep	movsw	; es:[di] = ds:[si]
	jnc	@F	; oCgRs[ȂI.
	inc	di	; oCg̏ꍇ movsw Ŗ߂肷Ă̂ɑΏ.
	inc	si
	movsb
@@:	cld
	ret
memmove_from_back ENDP

_TEXT ENDS

END
