//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// string.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

// DOS p string.h ̌݊.

#include "../util/string.h"

size_t strlen(const char* s)
{
	size_t ret = 0;

	while(*s != '\0')
	{
		++s;
		++ret;
	}

	return ret;
}

char* strcpy(char* dst, const char* src)
{
	while(1)
	{
		if((*dst++ = *src++) == '\0') break;
	}
	return dst;
}

int strncmp(const char* s1, const char* s2, size_t maxlen)
{
	while(0 < maxlen)
	{
		if(*s1 < *s2) return -1;
		if(*s2 < *s1) return 1;
		++s1;
		++s2;
		--maxlen;
	}
	return 0;
}
