//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// main.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include <stdint.h>

#if !defined(__DOS__)
#include <stdlib.h>
#endif

#include "mml_proc/mml_proc.h"

#include "iobuffer.h"
#include "util/fileio.h"
#include "util/print.h"
#include "util/str_proc.h"
#include "mml_proc/err_proc.h"
#include "mml_proc/src_list.h"

#include "set_segm.h"
#include "version.h"

static void init_header(Header ___FAR* h);

static OutputBuffer out_buf;
static InputBuffer in_buf;
static CompileStatus cs;
static MusicProperties mp = {{0, 0, 0, 0}};

#if defined(__DOS__)
// f[^ZOgɔzu͂ MML ǂݍނ߂̔z.
static char in_mml_buffer[DOS_IN_BUF_SIZE];
// start_dos.asm Œ`o̓f[^p̃ZOg.
extern uint8_t ___FAR outdata_start[];
#else
// atexit() œo^郁֐(Ώۂ̃ NULL Ȃ牽Ȃ)
static void free_resources(void)
{
	if(in_buf.buf != NULL) free(in_buf.buf);
	if(out_buf.buf != NULL) free(out_buf.buf);
}
#endif

int8_t n2kc_main(int argc, char** argv)
{
	if(argc != 3)
	{
		extern const char ___FAR boot_msg[]; // strs.c
		print_to_stderr_far(boot_msg);
		return 1;
	}

	in_buf.filename = argv[1];
	const char* out_path = argv[2];

	init_error_info();

#if defined(__DOS__)
	// Iւ̃|C^A̓t@C[h.
	in_buf.buf = in_mml_buffer;
	out_buf.buf = outdata_start;
	load_input_mml(in_buf.filename, &in_buf);
#else
	// Iւ̃|C^A֐o^.
	in_buf.buf = NULL;
	out_buf.buf = NULL;
	atexit(free_resources);

	// ̓t@C[h.
	load_input_mml(in_buf.filename, &in_buf);

	// o̓obt@m.
	out_buf.buf = (uint8_t*)malloc(OUT_BUF_SIZE);
	if(out_buf.buf == NULL) exit_file_op(FEC_ALLOCATION_FAILED, in_buf.filename);
#endif
	set_error_info_in_mml(&in_buf); // JG[Ƀobt@ݒ.

	out_buf.size = OUT_BUF_SIZE;
	out_buf.wrote_len = 0;
	out_buf.total_len = 0;

	// RpC.
	init_compiler();

	//--- ȃf[^S̗pwb_.
	// sizeof(ȃf[^S̗pwb_) < OUT_BUF_SIZE OƂĂ.
	Header ___FAR* header = (Header ___FAR*)out_buf.buf;
	init_header(header);
	out_buf.wrote_len += sizeof(Header);

	// ȃf[^S̗pwb_pvvZX.
	in_buf.idx = 0;
	compile_preprocess(&in_buf, &out_buf, &cs, &mp);
	// vvZXʂwb_ɐݒ肷.
	header->n_sources = n_sources;
	for(uint8_t i = 0; i < N_STR_OFFSETS; ++i)
		header->music_props.str_offset_arr[i] = mp.str_offset_arr[i];

	// ȑS̃wb_ɏo out_buf ɂ.
	write_compiled_data(out_path, &out_buf, 0);
	// ȍ~G[ɂ͏o̓t@C̍폜Kv.
	set_error_out_filename(out_path);

	//--- ẽRpC.
	for(uint16_t i = 0; i < n_sources; ++i)
	{
		out_buf.wrote_len = 0;
		const uint8_t src_type = source_list[i].source_type;
		set_error_src_idx(i, 0);

		// epȃf[^16oCgACg悤ɁAKvɉăf[^o.
		const uint8_t mod16 = out_buf.total_len % 16;
		if(mod16 != 0) {
			const uint8_t n_padding = 16 - mod16;
			out_buf.wrote_len = n_padding;
			for(uint8_t j = 0; j < n_padding; ++j) out_buf.buf[j] = 0;
			write_compiled_data(out_path, &out_buf, 1);
		}
		out_buf.wrote_len = 0;

		// epwb_.
		Header_Source ___FAR* src_header = (Header_Source ___FAR*)out_buf.buf; // ł wrote_len == 0
		src_header->source_type = src_type;
		cs.header = src_header;
		generate_source_header(&out_buf, &cs);

		// ẽRpCOɍsvvZX.
		cs.source_idx = i;
		cs.use_number = source_list[i].use_number;
		in_buf.idx = 0;
		compile_preprocess2(&in_buf, &out_buf, &cs, i);

		// epȃf[^擪ʒuo.
		write_data_start_pos(out_path, out_buf.total_len, i);

		// F̃RpC.
		in_buf.idx = 0;
		compile_voice(&in_buf, &out_buf, &cs);

		// t߂̃RpC.
		in_buf.idx = 0;
		compile_instruction(&in_buf, &out_buf, &cs);

		// RpCʂo.
		write_compiled_data(out_path, &out_buf, 1);
	}

	// in_buf, out_buf ̉͂Ȃ.
	// win: free_resources()  atexit Ă.
	// dos: o̓f[^͓̈Imۂ̈ł͂Ȃ.

	return 0;
}

void init_header(Header ___FAR* h)
{
	h->magic[0] = HEADER_MAGIC_0;
	h->magic[1] = HEADER_MAGIC_1;
	h->magic[2] = HEADER_MAGIC_2;
	h->magic[3] = HEADER_MAGIC_3;

	h->version_major = HEADER_VERSION_MAJOR;
	h->version_minor = HEADER_VERSION_MINOR;
	h->version_beta = HEADER_VERSION_BETA;
}

