//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// err_proc.h
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#ifndef N2KC_ERROR_PROC_H
#define N2KC_ERROR_PROC_H

#include <stdlib.h>
#include <stdint.h>

#include "../util/fileio.h"
#include "mml_proc.h"
#include "../far_ptr.h"

void init_error_info();
void set_error_info_in_mml(InputBuffer* in_buf);
void set_error_info_addnl_msg(const char ___FAR* msg);
void set_error_op_str(const char* op_str);
void set_error_part_str(const char* part_str);
void set_error_src_idx(const uint16_t idx, const uint8_t unset); // RpC̉ index (use_number ł͂Ȃ)w肷.
void set_error_out_filename(const char* out_filename);

// G[͑SĂ̊֐S.
void exit_file_op(const FileErrorCode fec, const char* filename);
void exit_mml(const MMLErrorCode mec); // in_buf->idx ̈ʒuŃG[N̂Ƃĕ\ exit
void exit_mml_one_back(const MMLErrorCode mec); // in_buf->idx - 1̈ʒupo[W.
void exit_mml_idx(const MMLErrorCode mec, const size_t idx); // in_buf->idx w肷o[W.
void exit_mml_err_only(const MMLErrorCode mec); // MML ̃G[ʒu\o[W.
void exit_internal_error(const uint16_t memo_code); // ʏ킠蓾ȂG[Ŏsꍇ.

// GR[h.
// fileio.c
#define INTEC_INVALID_INCLUDE_POS (0xf000)
// include_info.c
#define INTEC_INCLUDE_LIMIT (0xf010)
#define INTEC_INVALID_REPLACED_LEN (0xf011)
#define INTEC_INVALID_INSERT_POS (0xf012)
#define INTEC_INVALID_POS (0xf013)
#define INTEC_POS_NOT_FOUND (0xf014)
// n2kc_main.c
#define INTEC_UNSUPPORTED_CHIPTYPE (0xf020)
// dos/string.asm
// 0xf030

#endif // N2KC_ERROR_PROC_H
