//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// inc_info.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include "inc_info.h"
#include "err_proc.h"

#if defined(__DOS__)
extern IncludeInfo ___FAR include_info_start[N_INCLUDABLE_FILES];
IncludeInfo ___FAR* const include_info_list = include_info_start;
extern BorderInfo ___FAR border_info_start[N_MAX_BORDER_INFO];
BorderInfo ___FAR* const border_info_list = border_info_start;
#else
IncludeInfo include_info_list[N_INCLUDABLE_FILES];
BorderInfo border_info_list[N_MAX_BORDER_INFO];
#endif

uint8_t n_included_files = 0;
uint8_t n_border_info = 0;

uint8_t can_include()
{
	return (n_included_files < N_INCLUDABLE_FILES);
}

// pos: }ʒu.
// replaced_length: uď.
// added_length: uĒǉꂽ.
// ߂l0Ő. 0͂̂܂ exit_internal_error() ɓn̂z.
uint16_t add_include_info(const char* filename, const size_t pos, const size_t replaced_length, const size_t added_length)
{
	// n_included_files 狭IɃG[.
	// O can_include() œǂݍ݉\`FbN邱.
	if(N_INCLUDABLE_FILES <= n_included_files) return INTEC_INCLUDE_LIMIT;

	include_info_list[n_included_files].filename = filename;

	if(n_included_files == 0)
	{
		// ̋Eǉ.
		if(replaced_length != 0) return INTEC_INVALID_REPLACED_LEN;

		border_info_list[0].pos = 0;
		border_info_list[0].info_idx = 0;
		border_info_list[0].is_end = 0;
		border_info_list[1].pos = added_length;
		border_info_list[1].is_end = 1;

		n_included_files = 1;
		n_border_info = 2;
		return 0;
	}

	if(border_info_list[n_border_info - 1].pos < pos)
		return INTEC_INVALID_INSERT_POS; // obt@OȂ̂͂.

	// pos ȍ~̋Eʒu replaced_length Z.
	for(uint8_t i = 0; i < n_border_info; ++i)
	{
		BorderInfo ___FAR* bi = border_info_list + i;
		// pos ? pos + replaced_len ͈̔͂ɋE͗Ȃ.
		if(pos < bi->pos) bi->pos -= replaced_length;
	}

	if(pos == 0)
	{
		// 擪ւ̑}̏ꍇA擪1󂯂Ăɏǉ.
		for(uint8_t i = n_border_info - 1; ; --i)
		{
			border_info_list[i + 1].pos = border_info_list[i].pos + added_length;
			border_info_list[i + 1].info_idx = border_info_list[i].info_idx;
			border_info_list[i + 1].is_end = border_info_list[i].is_end;
			if(i == 0) break;
		}
		border_info_list[0].pos = 0;
		border_info_list[0].info_idx = n_included_files;
		border_info_list[0].is_end = 0;
		n_border_info += 1;
	}
	else if(pos == border_info_list[n_border_info - 1].pos)
	{
		// ւ̑}̏ꍇ.
		border_info_list[n_border_info - 1].info_idx = n_included_files;
		border_info_list[n_border_info - 1].is_end = 0;
		border_info_list[n_border_info].pos = border_info_list[n_border_info - 1].pos + added_length;
		border_info_list[n_border_info].is_end = 1;
		n_border_info += 1;
	}
	else
	{
		// Ԃւ̑}̏ꍇ.
		uint8_t idx = 0; // }ʒu.
		while(idx < n_border_info)
		{
			if(pos <= border_info_list[idx].pos) break;
			++idx;
		}
		// }ʒu2󂯂.
		for(uint8_t i = n_border_info - 1; ; --i)
		{
			border_info_list[i + 2].pos = border_info_list[i].pos + added_length;
			border_info_list[i + 2].info_idx = border_info_list[i].info_idx;
			border_info_list[i + 2].is_end = border_info_list[i].is_end;
			if(i == idx) break;
		}
		// pos ̈ʒuɐVK̋E}.
		border_info_list[idx].pos = pos;
		border_info_list[idx].info_idx = n_included_files;
		border_info_list[idx].is_end = 0;
		// ꂽӏ̌㔼̋Eǉ.
		border_info_list[idx + 1].pos = pos + added_length;
		border_info_list[idx + 1].info_idx = border_info_list[idx - 1].info_idx;
		border_info_list[idx + 1].is_end = 0;

		n_border_info += 2;
	}

	n_included_files += 1;
	return 0;
}

// MML ̃obt@ pos ̈ʒuǂ̃t@Ĉ̂Ԃ.
// pos obt@TCYĂꍇAG[ɂ.
uint8_t get_include_info_idx(const size_t pos)
{
	if(border_info_list[n_border_info - 1].pos < pos)
		exit_internal_error(INTEC_INVALID_POS);

	// ɔ.
	if(border_info_list[n_border_info - 1].pos == pos)
	{
		return border_info_list[n_border_info - 1].info_idx;
	}

	// (pos < 0) ͕KUȂ̂ i = 1 n߂.
	for(uint8_t i = 1; i < n_border_info; ++i)
	{
		if(pos < border_info_list[i].pos)
		{
			return border_info_list[i - 1].info_idx;
		}
	}

	exit_internal_error(INTEC_POS_NOT_FOUND);
	return 0; // x΍.
}
