//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// inc_info.h
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#ifndef N2KC_INCLUDE_INFO_H
#define N2KC_INCLUDE_INFO_H

#include <stdint.h>
#include <stddef.h>

#include "../far_ptr.h"

// #Include vvZbTŃ[hꂽt@CǗ邽߂̃f[^.
// ̃t@C̒`ύXۂɂ start_dos.asm ̃obt@`̕ύXYꂸ.

#define N_INCLUDABLE_FILES 16
#define N_MAX_BORDER_INFO ((N_INCLUDABLE_FILES)*2)

// ȂɂǉŕۑȂ邩Ȃ̂ō\̂ɂĂ.
typedef struct
{
	const char* filename;
} IncludeInfo;

typedef struct
{
	size_t pos;
	uint8_t info_idx;
	uint8_t is_end;		// I[ʒȕ񂩂ǂ.
} BorderInfo;

// ǂݍ܂ꂽt@CǗpO[oϐ(̂ include_info.c Œ`)
extern uint8_t n_included_files;
extern uint8_t n_border_info;
#if defined(__DOS__)
extern IncludeInfo ___FAR* const include_info_list;
extern BorderInfo ___FAR* const border_info_list;
#else
extern IncludeInfo include_info_list[N_INCLUDABLE_FILES];
extern BorderInfo border_info_list[N_MAX_BORDER_INFO];
#endif

uint8_t can_include();
uint16_t add_include_info(const char* filename, const size_t pos, const size_t replaced_length, const size_t added_length);
uint8_t get_include_info_idx(const size_t pos);

#endif // N2KC_INCLUDE_INFO_H
