//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// internal.h
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#ifndef N2KC_MML_INTERNAL_H
#define N2KC_MML_INTERNAL_H

// RpC̓pwb_.
// wp̊֐̐錾܂.

#include <stdint.h>
#if !defined(__DOS__)
	// printf() fobOȂǂœxXg.
	#include <stdio.h>
#endif

#include "mml_proc.h"
#include "../iobuffer.h"
#include "../util/str_proc.h"

//-------------------------------//
// RpC֌W̒萔Ɗ֐    //
//-------------------------------//
#define MAX_OUT_SIZE (0xffff)

// 1`8IN^[u.
#define OCTAVE_MIN (1)
#define OCTAVE_MAX (8)
// IɎgԍ̍ŏl/ől(o1c`o8b)
#define NOTE_NUMBER_MIN (0)
#define NOTE_NUMBER_MAX (OCTAVE_MAX * 12 - 1)

typedef struct
{
	int32_t idx_char; // G[̋N̈ʒu.
	MMLErrorCode error_code;
} MMLError;

MMLErrorCode ec_convert_str_to_mml(const StrProcErrorCode error_code);

void compile_mml_one(InputBuffer* in_buf, OutputBuffer* out_buf, CompileStatus* cs);

// n2km_sub.c
//void compile_csm(InputBuffer* in_buf, OutputBuffer* out_buf, CompileStatus* cs);


//-------------------------------//
// RpCpwp֐        //
//-------------------------------//
// 擾(cdefgabr ̌ɂ͉ȂĂAl ߂͉̌K݂Kv̂ŁÂ MMLErrorCode ŕԂKv)
MMLErrorCode get_note_length(InputBuffer* in_buf, uint8_t* note_len_by_clock, CompileStatus* cs);
// 擾.
MMLErrorCode get_note_num(InputBuffer* in_buf, uint8_t* note_num, CompileStatus* cs);
// ԍƔ߂ǂ̕ϊ.
uint8_t note_num_to_keyon_op(const uint8_t note_num);
uint8_t keyon_op_to_note_num(const uint8_t keyon_op);
// ԍ a  b ̍ (b-a)  sent Pʂŋ߂.
int32_t calc_sent_diff(const uint8_t note_num_a, const uint8_t note_num_b);
// SEC_NO_ERROR łȂꍇ exit wp.
void exit_str_proc(const StrProcErrorCode sec);
//  c,d,e,f,g,b,a ̉ꂩǂ肷.
uint8_t is_pitch_name_char(const char c);
//  LFO ̃`lɕϊ(łȂꍇ-1Ԃ).
int8_t get_lfo_channel(const char c);
//  FNum,BLK ̐ݒ index ɕϊ(łȂꍇ-1Ԃ).
int8_t get_fnum_blk_setting_idx(const char c);
// 󔒕΂AEOF `FbNA}NEo܂Ƃ߂čs֐.
void skip_blank_check_eof_exit_macro(InputBuffer* in_buf, CompileStatus* cs);
// 󔒕΂āA}NEo֐.
void skip_blank_exit_macro(InputBuffer* in_buf, CompileStatus* cs);
// EOF `FbNƃ}NEo֐.
void check_eof_exit_macro(InputBuffer* in_buf, CompileStatus* cs);
// }N̒Eo֐.
void exit_macro(InputBuffer* in_buf, CompileStatus* cs);
// J}邱ƂmFȂɐiފ֐.
// check_mode 0łȂꍇAJ}ǂ߂lƂēāAexit_mml() 邱Ƃ͖.
uint8_t skip_one_comma(InputBuffer* in_buf, CompileStatus* cs, const uint8_t check_mode);
// e| timer_b ̒lɕϊ֐.
uint8_t convert_tempo_to_timer_b(const uint8_t tempo, const uint8_t zenlen);
// cobt@ȂꍇɃG[ɂ.
void check_outbuf_remain_size(size_t n_needed, size_t wrote_len);


//-------------------------------//
// n2km_common.c                 //
//-------------------------------//
void init_compile_status(CompileStatus* cs);
int16_t check_voice_def_num(InputBuffer* in_buf, const uint8_t use_number);
uint8_t check_end_voice_def(InputBuffer* in_buf);
uint8_t current_part_is_exist(InputBuffer* in_buf, const CompileStatus* cs, uint8_t check_part_ch);

#endif // N2KC_MML_INTERNAL_H
