//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// macro.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include "macro.h"

#include "../util/string.h"

uint8_t n_defined_macros = 0;
#if defined(__DOS__)
extern Macro ___FAR macro_start[];
Macro ___FAR* const macros = macro_start;
#else
Macro macros[N_DEFINABLE_MACROS];
#endif

// _macro_name_lexical_compare() ֐ in_buf ɃANZXKv邪,
// œnȂ̂ŐÓIϐʂăANZXł悤ɂ.
static InputBuffer tmp_in_buf;

void macro_set_input_buffer(InputBuffer* in_buf)
{
	tmp_in_buf = *in_buf;
}

int macro_name_len_compare(const void ___FAR* va, const void ___FAR* vb)
{
	const Macro ___FAR* a = (Macro ___FAR*)va;
	const Macro ___FAR* b = (Macro ___FAR*)vb;

	if(a->name_len < b->name_len) return 1;
	else if(a->name_len == b->name_len) return 0;
	else return -1;
}

// name_len  a, b œƂO񂪂̂Œ.
int macro_name_lexical_compare(const void ___FAR* va, const void ___FAR* vb)
{
	const Macro ___FAR* a = (Macro ___FAR*)va;
	const Macro ___FAR* b = (Macro ___FAR*)vb;

	return strncmp(tmp_in_buf.buf + a->name_idx, tmp_in_buf.buf + b->name_idx, a->name_len);
}
