//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// macro.h
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#ifndef N2KC_MML_MACRO_H
#define N2KC_MML_MACRO_H

#include "../far_ptr.h"
#include "../iobuffer.h"

// MML ̃}N($)𑀍삷̂ɕKvȊ֐O[oϐ̒`.
// ̃t@C̒`ύXۂɂ start_dos.asm ̃obt@`̕ύXYꂸ.

#define N_DEFINABLE_MACROS 64

typedef struct
{
	size_t name_idx;
	size_t name_len;
	size_t body_idx;
	size_t body_len;
} Macro;

// }Ñ\[gp֐.
int macro_name_len_compare(const void ___FAR* va, const void ___FAR* vb);
int macro_name_lexical_compare(const void ___FAR* va, const void ___FAR* vb);

void macro_set_input_buffer(InputBuffer* in_buf);

// }NǗpO[oϐ.
extern uint8_t n_defined_macros;
#if defined(__DOS__)
extern Macro ___FAR* const macros;
#else
extern Macro macros[N_DEFINABLE_MACROS]; // ̎̂ mml_macro.c Œ`.
#endif

#endif // N2KC_MML_MACRO_H
