//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// mml_cmn.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

// RpC֌W̋ʏ.

#include "internal.h"
#include "mml_opl3.h"

#include "opcodes.h"

#include "../util/str_proc.h"
#include "../util/string.h"
#include "err_proc.h"

#include "../util/print.h"
#include "src_list.h"
#include "../set_segm.h"

#include <stdint.h>

// compile_instruction() ̏̋ʉ̂߂̊eŗLւ̊֐|C^i[\.
// get_n_parts(): RpCΏۂ̃p[g擾.
// get_part_chars(): p[gi[ꂽz擾.
// set_part_data_offset(): RpCꂽep[g̉tf[^̃ItZbgwb_ɐݒ肷.
// print_clocks(): RpCɊep[g̃NbN\.
typedef struct {
	uint8_t (*get_n_parts)();
	const char* (*get_part_chars)();
	void (*set_part_data_offset)(Header_Source ___FAR*, uint8_t, uint16_t);
	void (*print_clocks)(const uint16_t*);
} SpecialFuncs;

// farstack ŏĂ̂ŁAɃ|C^֐Ăяoɂ͂n.
static uint8_t tmp_u8_static;

// e[uȂƖ{ɒxƂȂe[uɂ.
// sȃp[g^邱Ƃ͍lĂȂ.
// KX is_valid_part_ch() Ń`FbN邱.
static uint8_t part_ch_to_part_idx(char ch, const CompileStatus* cs)
{
	for(uint8_t i = 0; i < cs->n_part_chars; ++i)
	{
		if(ch == cs->part_chars[i]) return i;
	}
	static const char SEGMENT("_TEXT") msg[] = "invalid part char";
	set_error_info_addnl_msg(msg);
	exit_mml(MMLEC_OTHER_ERROR);
	return 0; // warning }~̂.
}

static uint8_t is_valid_part_ch(char ch, const CompileStatus* cs)
{
	for(uint8_t i = 0; i < cs->n_part_chars; ++i)
	{
		if(ch == cs->part_chars[i]) return 1;
	}
	return 0;
}

// p[gwł X-Y ̎w肪Ή߂.
// ĂяȏO:
// - in_buf->idx  "X" wĂ邱.
// mode_ch:
// - '\0'=@`FbN.
// - p[gw蕶=RpCΏۂ`FbN(@`FbN͏ȗ)
// ߒl:
// - X-Y Ȃ in_buf->idx ͓ɕԂ.
// - X-Y  in_buf->idx  X-Y ̐wĂ.
// - @`FbN: G[ exit_mml() ̕֍s.
//                   G[Ȃ: 0=X-Y ̎w肪Ȃ, 1=X-Y ĖȂ.
// - RpCΏۂ`FbN:
//   - 0=X-Y ΏۂłȂ,
//   - 1=X-Y ΏۂɂȂĂ.
//   - 2=X-Y Ȃ.
static uint8_t parse_part_idx_range(InputBuffer* in_buf, const CompileStatus* cs, char mode_ch)
{
	extern const char ___FAR msg_part_ch_unknown[];
	extern const char ___FAR msg_part_range_no_Y[];
	extern const char ___FAR msg_part_range_order[];

	char ch;
	const size_t n_remain = in_buf->read_len - in_buf->idx;

	if(mode_ch == '\0')
	{
		if(n_remain <= 1) return 0;
		if(in_buf->buf[in_buf->idx + 1] != '-') return 0;
		if(n_remain == 2)
		{
			set_error_info_addnl_msg(msg_part_range_no_Y);
			exit_mml(MMLEC_INVALID_PART_SEL); // X-Y  Y ̕obt@ɂȂ.
		}
		// X ̃`FbN.
		ch = in_buf->buf[in_buf->idx++];
		if(!is_valid_part_ch(ch, cs))
		{
			set_error_info_addnl_msg(msg_part_ch_unknown);
			exit_mml_one_back(MMLEC_INVALID_PART_SEL);
		}
		const uint8_t idx_x = part_ch_to_part_idx(ch, cs);
		// Y ̃`FbN.
		in_buf->idx++;
		ch = in_buf->buf[in_buf->idx++];
		if(!is_valid_part_ch(ch, cs))
		{
			set_error_info_addnl_msg(msg_part_ch_unknown);
			exit_mml_one_back(MMLEC_INVALID_PART_SEL);
		}
		const uint8_t idx_y = part_ch_to_part_idx(ch, cs);
		// part_idx  X < Y ɂȂĂ邩mF.
		if(!(idx_x < idx_y))
		{
			set_error_info_addnl_msg(msg_part_range_order);
			exit_mml_idx(MMLEC_INVALID_PART_SEL, in_buf->idx - 3);
		}
		return 1;
	}

	if(n_remain <= 2) return 2;
	if(in_buf->buf[in_buf->idx + 1] != '-') return 2;
	ch = in_buf->buf[in_buf->idx];
	const uint8_t idx_x = part_ch_to_part_idx(ch, cs);
	in_buf->idx += 2;
	ch = in_buf->buf[in_buf->idx++];
	const uint8_t idx_y = part_ch_to_part_idx(ch, cs);
	const uint8_t idx = part_ch_to_part_idx(mode_ch, cs);
	return (idx_x <= idx) && (idx <= idx_y);
}

// p[gw蕔Ɍ݃RpC̃p[g܂܂Ă邩ǂ肷.
// in_buf->idx p[gwӏ(su|v߂̌)wĂKv.
// ߒl: 茋(0=RpCs, 0=RpC)
// in_buf->idx ̓RpCsyщƔł܂Ői.
uint8_t current_part_is_exist(InputBuffer* in_buf, const CompileStatus* cs, uint8_t check_part_ch)
{
	for(;;) // (uint16_t cnt = 0; ; ++cnt) // cnt ̓fobOpϐ.
	{
		StrProcErrorCode sec = str_to_num_u8(in_buf, &tmp_u8_static, 0x00, 0xff);
		if(sec != SEC_NO_ERROR) exit_str_proc(sec);

		// ԍ̈vmF.
		char c;
		if(tmp_u8_static != cs->use_number)
		{
			while(in_buf->idx < in_buf->read_len)
			{
				c = in_buf->buf[in_buf->idx++];
				if(c == ',') break; // J}oΎ̉ԍp[X.
				else if(is_whitespace(c)) return 0; // 󔒕΃p[gw蕔I.
			}
		}
		else
		{
			// p[gɗp\łȂ邩`FbN.
			// X-Y ̕@`FbNĂ.
			if(check_part_ch)
			{
				const size_t idx_save = in_buf->idx;
				while(in_buf->idx < in_buf->read_len)
				{
					// X-Y ?
					if(parse_part_idx_range(in_buf, cs, '\0')) continue;
					// X-Y Ȃ.
					c = in_buf->buf[in_buf->idx++];
					// p[gȊOŋeł.
					if(is_whitespace(c) || c == ',') break;
					else if(c == '*') continue;
					// p[g`FbN.
					if(!is_valid_part_ch(c, cs))
					{
						extern const char ___FAR msg_part_ch_unknown[];
						set_error_info_addnl_msg(msg_part_ch_unknown);
						exit_mml_one_back(MMLEC_INVALID_PART_SEL);
					}
				}
				in_buf->idx = idx_save;
			}

			// RpCΏۂ̃p[g邩`FbN.
			while(in_buf->idx < in_buf->read_len)
			{
				const uint8_t ret = parse_part_idx_range(in_buf, cs, cs->part_char);
				if(ret == 1) return 1;
				else if(ret == 0) continue;
				// 0, 1 ԂȂ X-Y ̎w肪Ȃ.
				c = in_buf->buf[in_buf->idx++];
				if(c == cs->part_char) return 1; // p[g΃RpCΏۍs.
				else if(c == '*') return 1; // '*' ͑Sp[gRpCΏ.
				else if(c == ',') break;
				else if(is_whitespace(c)) return 0;
			}
		}

		if(in_buf->read_len <= in_buf->idx) break;
	}
	return 0;
}

// eRpCO CompileStatus ̏܂Ƃ߂.
static void init_compile_status_s(CompileStatus* cs)
{
	for(uint8_t i = 0; i < N_CLOCK_TABLE_ENTRIES; ++i)
		cs->clock_table[i] = 0;
}
// ep[gRpCO CompileStatus ̏܂Ƃ߂.
static void init_compile_status_p(CompileStatus* cs)
{
	cs->part_status.octave = 4;
	cs->part_status.note_length = cs->zenlen / 4; // l.
	cs->part_status.n_repeat_nest = 0;
	cs->part_status.prev_note_pos = 0;
	cs->part_status.n_macro_nest = 0;
	cs->part_status.flag_common_0 = 0;
	cs->part_status.flag_specific_0 = 0;

	cs->part_status.repeat_esc_flag = 0;
	for(uint8_t i = 0; i < REPEAT_NEST_MAX; ++i) {
		cs->part_status.clock_buf[i] = 0;
		cs->part_status.clock_buf_esc[i] = 0;
	}
	cs->part_status.clock_buf[REPEAT_NEST_MAX] = 0;

	for(uint8_t i = 0; i < 7; ++i)
		cs->part_status.scale_setting[i] = 0;
}

// #VoiceDef ̌ɂ鉹ԍ use_number ܂ނׂ.
// in_buf->idx  # n܂swĂ邱.
// ߒl: 1Ȃ use_number ƈv, 0Ȃsv, Ȃ #VoiceDef łȂvvZbT.
// p[Xs exit_mml() ŏI.
// p[X in_buf->idx s܂Ői.
// "#VoiceDef" łȂꍇ in_buf->idx 1i.
int16_t check_voice_def_num(InputBuffer* in_buf, const uint8_t use_number)
{
	in_buf->idx += 1; // s # Ȃ̂͑OȂ̂Ń`FbNȂ.

	// #VoiceDef ׂ.
	const size_t n = in_buf->read_len - in_buf->idx;
	if(n < 8) return -1; // Ȃ. m̃vvZbT̏ꍇ preproc ŃG[ɂȂĂ̂ -1 Ԃėǂ.
	if(strncmp(in_buf->buf + in_buf->idx, "VoiceDef", 8) != 0) return -1;
	in_buf->idx += 8;

	// ԍ𒲂ׂ.
	// m̃vvZbT preproc ŒeĂ̂ŖɃXLbvɐ锤.
	str_skip(in_buf, SST_SKIP_BLANK);
	while(1)
	{
		StrProcErrorCode sec = str_to_num_u8(in_buf, &tmp_u8_static, 0x00, 0xff);
		if(sec != SEC_NO_ERROR) exit_str_proc(sec);
		if(tmp_u8_static == use_number)
		{
			// 㑱̐lƃJ}Ƌ󔒑S΂.
			str_skip(in_buf, SST_SKIP_BLANK_AND_COMMA_AND_HEXNUM);
			return 1;
		}
		str_skip(in_buf, SST_SKIP_BLANK_AND_COMMA);
		if(in_buf->idx < in_buf->read_len && is_newline(in_buf->buf[in_buf->idx]))
			break; // srI.
	}
	return 0;
}

// #EndVoiceDef 邩ׂ.
// in_buf->idx  # n܂swĂ邱.
// ߒl: 0=݂, 0=݂Ȃ.
// ݂ꍇ in_buf->idx  "#EndVoiceDef" ̎܂Ői.
// ݂Ȃꍇ in_buf->idx 1i.
uint8_t check_end_voice_def(InputBuffer* in_buf)
{
	in_buf->idx += 1; // s # Ȃ̂͑OȂ̂Ń`FbNȂ.

	const size_t remain = in_buf->read_len - in_buf->idx;
	if(remain < 11) return 0;
	if(strncmp(in_buf->buf + in_buf->idx, "EndVoiceDef", 11) != 0) return 0;

	in_buf->idx += 11;
	return 1;
}

// ewb_ʕ.
// Header_Source ̃oȊO̊eŗL̒l.
void generate_source_header(OutputBuffer* out_buf, CompileStatus* cs)
{
	const uint8_t type = cs->header->source_type;
	if(type == SRC_TYPE_OPL3)
	{
		init_opl3_header((Header_OPL3 ___FAR*)cs->header);
		out_buf->wrote_len += sizeof(Header_OPL3);
	}
}

// FRpCʏ.
void compile_voice(InputBuffer* in_buf, OutputBuffer* out_buf, CompileStatus* cs)
{
	// Fԍobt@.
	for(uint16_t j = 0; j < 256; ++j)
	{
		cs->voice_idx_table[j] = 0;
		cs->voice_registered[j] = 0;
	}

	const uint8_t type = cs->header->source_type;
	if(type == SRC_TYPE_OPL3)
	{
		Header_OPL3 ___FAR* h_opl3 = (Header_OPL3 ___FAR*)cs->header;
		compile_voice_opl3(in_buf, out_buf, h_opl3, cs);
		cs->voice_buf = out_buf->buf + h_opl3->voice_offset[0];
	}
}

// t߃RpCʕ.
void compile_instruction(InputBuffer* in_buf, OutputBuffer* out_buf, CompileStatus* cs)
{
	const uint8_t type = cs->header->source_type;

	//  OPL3 ̂ݑΉ.
	static const SpecialFuncs sf_table[] = {
		{ NULL, NULL, NULL, NULL }, // OPNA
		{ NULL, NULL, NULL, NULL }, // OPN2
		{ NULL, NULL, NULL, NULL }, // OPN
		{ NULL, NULL, NULL, NULL }, // OPL2
		{ get_n_parts_opl3, get_part_chars_opl3, set_part_data_offset_opl3, print_clocks_opl3 },
		{ NULL, NULL, NULL, NULL }, // Y8950
		{ NULL, NULL, NULL, NULL }, // PPZ8
		{ NULL, NULL, NULL, NULL }, // TMS3631
	};
	uint8_t (*sf_gnp)() = sf_table[type].get_n_parts;
	const char* (*sf_gpc)() = sf_table[type].get_part_chars;
	void (*sf_spdo)(Header_Source ___FAR*, uint8_t, uint16_t) = sf_table[type].set_part_data_offset;
	void (*sf_pc)(const uint16_t*) = sf_table[type].print_clocks;

	// p[g֘A萔擾.
	cs->n_part_chars = (*sf_gnp)();
	cs->part_chars = (*sf_gpc)();

	static char err_part_str[2] = { '\0', '\0' };
	set_error_part_str(err_part_str);

	init_compile_status_s(cs);
	for(uint8_t part_idx = 0; part_idx < cs->n_part_chars; ++part_idx)
	{
		// ep[gRpCO.
		init_compile_status_p(cs);
		cs->part_char = err_part_str[0] = cs->part_chars[part_idx];
		in_buf->idx = 0;

		const uint16_t out_start_idx = out_buf->wrote_len;
		uint8_t in_multi_line_comment = 0;

		while(in_buf->idx < in_buf->read_len)
		{
			// ̈ʒu in_buf->idx ͍swĂ.
			const char ch_l0 = in_buf->buf[in_buf->idx]; // s̕.
			// sRgtOXV.
			if(ch_l0 == '`')
			{
				in_multi_line_comment ^= 1;
goto_next_line:
				move_to_next_line(in_buf);
				continue;
			}
			// sRgȂ牽Ȃ.
			if(in_multi_line_comment) { goto goto_next_line; }

			// RpCΏۂ̍s肷.
			if(!is_digit(ch_l0)) { goto goto_next_line; } // ԍsɂ锤.
			if(!current_part_is_exist(in_buf, cs, part_idx == 0)) { goto goto_next_line; }
			// 󔒁AsARĝǂꂩo܂Ŕ΂.
			// : "0AB,1CD cdef"  0A RpCĂȂ "B,1CD" ΂.
			while(in_buf->idx < in_buf->read_len)
			{
				const char c = in_buf->buf[in_buf->idx];
				if(is_newline(c) || c == ';') { goto goto_next_line; }
				in_buf->idx += 1;
				if(is_blank(c)) { break; }
			}

			// 1߃RpC֐Ăяo.
			str_skip(in_buf, SST_SKIP_BLANK);
			while(in_buf->idx < in_buf->read_len && !is_newline(in_buf->buf[in_buf->idx]))
			{
				compile_mml_one(in_buf, out_buf, cs);
				if(cs->part_status.flag_common_0 & PFLAG_COMM_0_BREAK) goto break_part_compile;
			}
			move_to_next_line(in_buf);
		}
break_part_compile:

		// ep[gRpCǏn.
		// TODO: ω̂Ȃ|^gG[ɂ?
		if(cs->part_status.n_repeat_nest) exit_mml(MMLEC_NO_REPEAT_END); // JԂ߂̑ΉĂȂ.
		if(cs->part_status.flag_common_0 & PFLAG_COMM_0_INF_LOOP) exit_mml(MMLEC_INFINITE_LOOP); // L ߂[v.

		// tIߏo.
		if(MAX_OUT_SIZE - 1 < out_buf->wrote_len)
		{
			extern const char ___FAR msg_limit_play_stop_op[];
			set_error_info_addnl_msg(msg_limit_play_stop_op);
			exit_mml(MMLEC_OUT_SIZE_LIMIT);
		}
		out_buf->buf[out_buf->wrote_len++] = OP_PLAY_END;

		// ẽwb_ɉtf[^̃ItZbgݒ.
		(*sf_spdo)(cs->header, part_idx, out_start_idx);

		// NbNL^.
		cs->clock_table[part_idx] = cs->part_status.clock_buf[0];
	}

	set_error_part_str(NULL);

	static const char SEGMENT("_TEXT") msg[] = "Clock (src: ";
	print_to_stderr_far(msg);
	print_to_stderr_far(source_type_to_str(source_list[cs->source_idx].source_type));
	putchar_to_stderr(',');
	put_st_to_stderr_d((size_t)cs->use_number);
	putchar_to_stderr(')');
	putchar_to_stderr('\n');
	(*sf_pc)(cs->clock_table); // ep[g̃NbN\.
}
