//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// mml_opl3.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include "mml_opl3.h"
#include "internal.h"

#include "opcodes.h"
#include "../set_segm.h"

#include "err_proc.h"
#include "../util/str_proc.h"
#include "../util/print.h"

static const char opl3_part_chars[N_PARTS_OPL3] = {
	'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R'
};

const uint8_t OPL3_VCONV_TABLE[OPL3_VCONV_TABLE_SIZE] = {
	20, 23, 26, 28, 31, 34, 36, 39, 42, 44, 47, 50, 52, 55, 58, 60, 63
};

static uint8_t voice_val_max(const uint8_t idx)
{
	if(idx == 0) return 255; // Fԍ.
	if(idx == 1) return 3; // CNT
	if(idx == 2) return 7; // FB
	if(idx <= 50)
	{
		const uint8_t r = (idx - 3) % 12;
		switch(r)
		{
			case 0: case 1: case 2: case 3: case 4: case 8:
				return 15; // AR, DR, SR, RR, SL, ML
			case 5:
				return 63; // TL
			case 6:
				return 3; // KSL
			case 7: case 10: case 11:
				return 1; // KSR, AM, VIB
			case 9:
				return 7; // WS
		}
		return 0; // : ɂ͗Ȃ(warning)
	}
	else // if(49 < idx)
		return 0;
}

void compile_voice_opl3(InputBuffer* in_buf, OutputBuffer* out_data, Header_OPL3 ___FAR* header, CompileStatus* cs)
{
	uint8_t voice_count = 0;
	uint8_t voice_def_parsed = 0;
	uint8_t voice_def_equal = 0;
	const uint16_t voice_buf_start = out_data->wrote_len;

	uint8_t in_multi_line_comment = 0;
	while(in_buf->idx < in_buf->read_len)
	{
		const char ch = in_buf->buf[in_buf->idx];

		// sRgΉ.
		if(ch == '`')
		{
			in_multi_line_comment ^= 1;
goto_next_line:
			move_to_next_line(in_buf);
			continue;
		}
		if(in_multi_line_comment) { goto goto_next_line; }

		if(ch == '#')
		{
			StrProcErrorCode sec;
			if(check_end_voice_def(in_buf))
			{
				voice_def_parsed = 0; // VoiceDef oԂɖ߂.
				sec = move_to_next_line_check_blank(in_buf, ';');
				if(sec != SEC_NO_ERROR) exit_str_proc(sec);
				continue;
			}
			in_buf->idx -= 1; // '#' ̕i񂾂̂߂.

			const int16_t ret = check_voice_def_num(in_buf, cs->use_number);
			if(ret < 0) move_to_next_line(in_buf); // #VoiceDef łȂ.
			else
			{
				voice_def_parsed = 1;
				voice_def_equal = (uint8_t)ret; // (1,0)=(v,sv)Ȃ̂ł̂܂ܑ.
				sec = move_to_next_line_check_blank(in_buf, ';');
				if(sec != SEC_NO_ERROR) exit_str_proc(sec);
			}
			continue;
		}

		if((ch != '@') || !voice_def_parsed || !voice_def_equal)
		{
			move_to_next_line(in_buf);
			continue;
		}

		// Fp[X.
		set_error_op_str("@");
		const size_t at_start = in_buf->idx;

		// ľ𐔂.
		// 12*2 + 3 = 27 2op F.
		// 12*4 + 3 = 51 4op F.
		uint8_t val[52] = { 0 }; // l51葽ꍇ̂߂1]ɓǂݎ]TpӂĂ.
		uint8_t n = 0;
		static uint8_t tmp_static;
		in_buf->idx += 1;

		// 󔒕ƃJ}ŋ؂ꂽ27܂51̐lǂ.
		while(1)
		{
			str_skip(in_buf, SST_SKIP_WHITESPACE_AND_COMMA);
			const size_t num_start = in_buf->idx;
			const MMLErrorCode mec = ec_convert_str_to_mml(str_to_num_u8(in_buf, &tmp_static, 0, voice_val_max(n)));
			val[n] = tmp_static;
			if(mec != MMLEC_NO_ERROR)
			{
				// lȂ̂A܂ EOF ɓB.
				if(n == 27 || n == 51) break;
				else
				{
					if(in_buf->read_len <= in_buf->idx) exit_mml(MMLEC_REACH_EOF);
					else if(in_buf->buf[in_buf->idx] == ';')
					{
						move_to_next_line(in_buf);
						continue;
					}
					else exit_mml(mec);
				}
			}
			++n;
			if(n == 51 + 1) exit_mml_idx(MMLEC_UNEXPECTED_CHAR, num_start); // l.
		}

		const uint8_t n_op = (n == 27) ? 2 : 4; // F̃Iy[^.
		const uint8_t n_bytes = (n == 27) ? 12 : 24; // FLoCg.

		// t@C̋󂫃`FbN.
		if(MAX_OUT_SIZE - n_bytes < out_data->wrote_len) exit_mml_idx(MMLEC_OUT_SIZE_LIMIT, at_start);
		// FԍdĂȂ?
		if(cs->voice_registered[val[0]] != 0)
		{
			extern const char ___FAR msg_DEF_already_defined[];
			set_error_info_addnl_msg(msg_DEF_already_defined);
			exit_mml_idx(MMLEC_INVALID_VOICE_IDX, at_start);
		}

		// Ff[^o.
		cs->voice_registered[val[0]] = 1;
		cs->voice_idx_table[val[0]] = voice_count;
		if(n_op == 2) voice_count += 1;
		else
		{
			// 4OP F 2OP F2̗̈gĒ`.
			if(voice_count == 0xfe)
			{
			extern const char ___FAR msg_DEF_cannot_define_4op[];
				set_error_info_addnl_msg(msg_DEF_cannot_define_4op);
				exit_mml_idx(MMLEC_INVALID_VOICE_IDX, at_start);
			}
			voice_count += 2;
		}

		uint8_t ___FAR* out = out_data->buf + out_data->wrote_len;

		if(n == 27) *out++ = 0x80 | ((val[2] & 0x7) << 1) | (val[1] & 0x1); //1|(3)|FB(3)|CNT(1)
		else *out++ = ((val[1] & 0x2) << 3) | ((val[2] & 0x7) << 1) | (val[1] & 0x1); //0|(2)|CNT(Cn+3)(1)|FB(3)|CNT(Cn)(1)

		for(uint8_t i = 0; i < n_op; ++i)
		{
			const uint8_t offset = 3 + 12 * i;
			*out++ = ((val[offset + 10] & 1) << 7) | ((val[offset + 11] & 1) << 6) | ((val[offset + 7] & 1) << 4) | (val[offset + 8] & 0xf);
			*out++ = ((val[offset + 6] & 0x3) << 6) | (val[offset + 5] & 0x3f); // KSL|TL
			*out++ = ((val[offset + 0] & 0xf) << 4) | (val[offset + 1] & 0xf); // AR|DR
			*out++ = ((val[offset + 4] & 0xf) << 4) | (val[offset + 2] & 0xf); // SL|SR
			*out++ = ((val[offset + 3] & 0xf) << 4) | (val[offset + 9] & 0x7); // RR(4)|(1)|WS(3)
		}
		if(n_op == 4) { *out++ = 0; *out++ = 0; } // 4OP Ȃ22,23oCgڂ0.
		*out = val[0]; // MML Œ`鎞ɎgFԍ.

		out_data->wrote_len += n_bytes;
		set_error_op_str(NULL);
	}

	// F1ȏ`łItZbg0ɐݒ.
	if(voice_count != 0) header->voice_offset[0] = voice_buf_start;
}

uint8_t get_n_parts_opl3()
{
	return N_PARTS_OPL3;
}

const char* get_part_chars_opl3()
{
	return opl3_part_chars;
}

void set_part_data_offset_opl3(Header_Source ___FAR* header, uint8_t part_idx, uint16_t offset)
{
	Header_OPL3 ___FAR* h = (Header_OPL3 ___FAR*)header;
	h->part_offset[part_idx] = offset;
}

void init_opl3_header(Header_OPL3 ___FAR* h_opl3)
{
	h_opl3->flags = 0;
	for(size_t i = 0; i < N_PARTS_OPL3; ++i)
		h_opl3->part_offset[i] = 0;
	for(size_t i = 0; i < N_VOICE_BUFS_OPL3; ++i)
		h_opl3->voice_offset[i] = 0;
}

void print_clocks_opl3(const uint16_t* clock_table)
{
	static const char SEGMENT("_TEXT") part_msg[] = "PART";
	static const char SEGMENT("_TEXT") space_msg[] = "  ";

	for(uint8_t i = 0; i < 5; ++i)
	{
		print_to_stderr_far(space_msg);
		uint8_t idx = i;
		for(uint8_t j = 0; j < 4; ++j)
		{
			if(j != 0)
			{
				if(j == 1 || j == 3) idx += 5;
				else idx += 4;
			}

			if(i == 4 && j == 3) break;
			if(i == 4 && j == 1)
			{
				for(uint8_t k = 0; k < 9; ++k) print_to_stderr_far(space_msg);
				putchar_to_stderr(' ');
				continue;
			}

			if(j != 0 && !(i == 4 && j == 2))
			{
				putchar_to_stderr(',');
				print_to_stderr_far(space_msg);
			}
			print_to_stderr_far(part_msg);
			putchar_to_stderr('_');
			putchar_to_stderr(opl3_part_chars[idx]);
			putchar_to_stderr(':');
			putchar_to_stderr(' ');
			put_u16_to_stderr_5d(clock_table[idx]);
		}
		putchar_to_stderr('\n');
	}
}

// voice_idx Ԗڂ̉F 4OP Fǂׂ.
// voice_idx `ꂽF̌葽ǂ͌ĂяoŃ`FbN.
// ߒl: 0=2OPF, 1=4OPF.
uint8_t check_voice_is_4op(const uint8_t ___FAR* voice_buf, uint8_t voice_idx)
{
	const uint16_t offset = (uint16_t)OPL3_VOICE_SIZE * (uint16_t)voice_idx;
	const uint8_t data = voice_buf[offset];
	if(data & 0x80) return 0;
	return 1;
}
