//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// mml_opl3.h
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#ifndef N2KC_MML_OPL3_H
#define N2KC_MML_OPL3_H

#include <stdint.h>

#include "../iobuffer.h"
#include "mml_proc.h"
#include "../far_ptr.h"

#define N_PARTS_OPL3 (18)
#define N_VOICE_BUFS_OPL3 (2)

#pragma pack(push, 1)
typedef struct
{
	uint8_t source_type;
	uint8_t flags;
	uint16_t voice_offset[N_VOICE_BUFS_OPL3];
	uint16_t part_offset[N_PARTS_OPL3];
	uint16_t csm_filename_offset;
} Header_OPL3;
#pragma pack(pop)

#define OPL3_FNUM_MAX (1023)

// 1F̃f[^TCY.
#define OPL3_VOICE_SIZE (12)

#define OPL3_VOL_MAX (0x3f)
#define OPL3_VCONV_TABLE_SIZE (17)
extern const uint8_t OPL3_VCONV_TABLE[OPL3_VCONV_TABLE_SIZE];

void compile_voice_opl3(InputBuffer* in_buf, OutputBuffer* out_data, Header_OPL3 ___FAR* header, CompileStatus* cs);
void init_opl3_header(Header_OPL3 ___FAR* h_opl3);

uint8_t get_n_parts_opl3();
const char* get_part_chars_opl3();
void set_part_data_offset_opl3(Header_Source ___FAR* header, uint8_t part_idx, uint16_t offset);
void print_clocks_opl3(const uint16_t* clock_table);

uint8_t check_voice_is_4op(const uint8_t ___FAR* voice_buf, uint8_t voice_idx);

#endif // N2KC_MML_OPL3_H
