//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// mml_pre.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include "internal.h"
#include "mml_opl3.h"
#include "macro.h"
#include "src_list.h"
#include "src_type.h"

#include "../util/print.h"
#include "../util/str_proc.h"
#include "../util/string.h"
#include "../util/qsort.h"
#include "inc_info.h"
#include "err_proc.h"

#include <stdint.h>

// ȏ񕶎ݒvvZbT̋L^p.
typedef struct
{
	size_t pp_pos; // vvZbT̂s̈ʒu.
	size_t str_pos; // vvZbT̈̊̕Jnʒu.
}StrPPPosInfo;

static uint8_t tmp_u8_static;

//==============================
// preprocess
//==============================
// ߃^C~OɊւ炸LȃvvZbTł΃Xgɂ͓Ă.
// find_preproc_from_list() ̎dlɂ.
static const char* PREPROCESSORS[] = {
	"Title",		// 0
	"Composer",		// 1
	"Arranger",		// 2
	"Comment",		// 3
	"WNClock",		// 4
	"Include",		// 5
	"Use",			// 6
	"VoiceDef",		// 7
	"EndVoiceDef",	// 8
	"OctSwap",		// 9
	"QReso",		// 10
//	"CSMFile"		// 11
};
#define N_PREPROCESSORS (sizeof(PREPROCESSORS) / sizeof(char*))

static void _exit_mml_pp_macro(const char ___FAR* msg)
{
	set_error_info_addnl_msg(msg);
	exit_mml(MMLEC_MACRO_DEF);
}

// out_buf 1 NULL u.
static void put_null(OutputBuffer* out_buf, const size_t err_idx, const char* err_msg)
{
	if(MAX_OUT_SIZE - 1 < out_buf->wrote_len)
	{
		if(err_msg != NULL) set_error_info_addnl_msg(err_msg);
		exit_mml_idx(MMLEC_OUT_SIZE_LIMIT, err_idx);
	}
	out_buf->buf[out_buf->wrote_len] = '\0';
	out_buf->wrote_len += 1;
}

// in_buf  idx ̈ʒu̕s EOF ܂ out_buf ɃRs[āA NULL u.
static void copy_string(InputBuffer* in_buf, size_t idx, OutputBuffer* out_buf, const size_t err_idx)
{
	while(!(in_buf->read_len <= idx || is_newline(in_buf->buf[idx])))
	{
		if(MAX_OUT_SIZE - 1 < out_buf->wrote_len) exit_mml_idx(MMLEC_OUT_SIZE_LIMIT, err_idx);
		out_buf->buf[out_buf->wrote_len] = in_buf->buf[idx];
		out_buf->wrote_len += 1;
		idx += 1;
	}
	put_null(out_buf, err_idx, NULL);
}

// ̒vvZbT߂ẴCfbNXԂ.
// ͂̃CfbNX́u#v̈ʒuwĂ̂Ƃ.
// lԂ΃G[A͂̃CfbNX̓vvZbTɑ󔒂ǂݔ΂ʒuɂȂĂ.
static uint16_t find_preproc_from_list(InputBuffer* in_buf, const char* lists[], uint8_t n_elems)
{
	StrProcErrorCode sec;
	MMLErrorCode mec;
	static uint16_t result;
	const size_t pp_start = in_buf->idx; // vvZbTJnʒu.

	in_buf->idx += 1;
	const size_t remain_buf_len = in_buf->read_len - in_buf->idx;
	sec = strcmp_list(in_buf, lists, n_elems, remain_buf_len, &result);
	if(sec != SEC_NO_ERROR)
	{
		mec = (sec == SEC_STRING_NOT_FOUND) ? MMLEC_UNKNOWN_PREPROCESSOR : ec_convert_str_to_mml(sec);
		exit_mml(mec);
	}

	const size_t preproc_len = strlen(lists[result]);
	in_buf->idx += preproc_len;
	if(in_buf->idx < in_buf->read_len && !is_whitespace(in_buf->buf[in_buf->idx]))
	{ // 1ǂ߂Ă̕󔒂łȂȂ疢m̃vvZbTG[.
		exit_mml_idx(MMLEC_UNKNOWN_PREPROCESSOR, pp_start);
	}
	str_skip(in_buf, SST_SKIP_BLANK);

	return result;
}

void compile_preprocess(InputBuffer* in_buf, OutputBuffer* out_buf, CompileStatus* cs, MusicProperties* mp)
{
	StrProcErrorCode sec;

	macro_set_input_buffer(in_buf);

	// lݒ.
	cs->zenlen = 192;
	cs->oct_swap = 0;
	cs->q_reso = 16;

	// ȏ񕶎 mml ł̊Jnʒu.
	StrPPPosInfo pppos_list[N_STR_OFFSETS];
	for(uint8_t i = 0; i < N_STR_OFFSETS; ++i)
	{
		// 0ڂȏ񕶎ƂƂ͂Ȃ̂ŁA0Ȃ疢ݒ舵.
		pppos_list[i].pp_pos = pppos_list[i].str_pos = 0;
	}

	uint8_t in_multi_line_comment = 0;
	while(in_buf->idx < in_buf->read_len)
	{
		const uint8_t ch = in_buf->buf[in_buf->idx];

		// sRgΉ.
		if(ch == '`')
		{
			in_multi_line_comment ^= 1;
goto_next_line:
			move_to_next_line(in_buf);
			continue;
		}
		if(in_multi_line_comment) { goto goto_next_line; }

		if(ch != '#' && ch != '$') { move_to_next_line(in_buf); }
		else if(ch == '$')
		{
			extern const char ___FAR msg_too_much_macro[];
			extern const char ___FAR msg_no_macro_name[];
			extern const char ___FAR msg_macro_comment_found[];

			// }N`.
			if(N_DEFINABLE_MACROS <= n_defined_macros) _exit_mml_pp_macro(msg_too_much_macro);
			Macro ___FAR* macro = macros + n_defined_macros;
			in_buf->idx += 1;

			// }Nǂݎ(ŏɋ󔒕oĂ܂ł}NƂĈ($̌ɋ󔒕s))
			macro->name_idx = in_buf->idx;
			// EOF 󔒂sI.
			while(!(in_buf->read_len <= in_buf->idx || is_whitespace(in_buf->buf[in_buf->idx])))
			{
				if(in_buf->buf[in_buf->idx] == ';') _exit_mml_pp_macro(msg_macro_comment_found);
				in_buf->idx += 1;
			}
			if(macro->name_idx == in_buf->idx) _exit_mml_pp_macro(msg_no_macro_name);
			macro->name_len = in_buf->idx - macro->name_idx;

			// }N̋󔒂΂.
			str_skip(in_buf, SST_SKIP_BLANK);

			//}N{̂̓ǂݎ.
			macro->body_idx = in_buf->idx;
			// s EOF ܂.
			while(!(in_buf->read_len <= in_buf->idx || is_newline(in_buf->buf[in_buf->idx])))
			{
				if(in_buf->buf[in_buf->idx] == ';') _exit_mml_pp_macro(msg_macro_comment_found);
				in_buf->idx += 1;
			}
			// }N{̂͋ł OK
			macro->body_len = in_buf->idx - macro->body_idx;

			n_defined_macros += 1;
			move_to_next_line(in_buf);
		}
		else if(ch == '#')
		{
			// vvZbT߂̉.
			const size_t pp_start = in_buf->idx;
			const uint16_t pp_idx = find_preproc_from_list(in_buf, PREPROCESSORS, N_PREPROCESSORS);

			uint8_t newline_chk_blank = 0; // s֍sۂɋ󔒃`FbN邩ǂ.

			if(pp_idx <= 3) // Title, Composer, Arranger, Comment (0-3)
			{
				if(pppos_list[pp_idx].str_pos != 0) exit_mml_idx(MMLEC_REUSE_PREPROCESSOR, pp_start);
				pppos_list[pp_idx].pp_pos = pp_start;
				pppos_list[pp_idx].str_pos = in_buf->idx;
			}
			if(pp_idx == 4) // WNClock
			{
				if((sec = str_to_num_u8(in_buf, &tmp_u8_static, 0x01, 0xff)) != SEC_NO_ERROR) exit_str_proc(sec);
				cs->zenlen = tmp_u8_static;
				newline_chk_blank = 1;
			}
			else if(pp_idx == 5) // Include
			{
				if(!can_include()) exit_mml_idx(MMLEC_REACH_INCLUDE_LIMIT, pp_start);
				// t@C͈͔.
				if(in_buf->read_len <= in_buf->idx) exit_mml(MMLEC_REACH_EOF); // EOF ͐ɏR.
				const size_t begin_pos = in_buf->idx;
				size_t end_pos = begin_pos + 1;
				for(; (end_pos < in_buf->read_len) && (!is_newline(in_buf->buf[end_pos])); ++end_pos);
				include_input_mml(in_buf, pp_start, begin_pos, end_pos - begin_pos);
				// ̍s֍s̍s(uӏ̐擪)珈𑱍s.
				in_buf->idx = pp_start;
				continue;
			}
			else if(pp_idx == 6) // Use
			{
				if(N_MAX_SOURCES <= n_sources) exit_mml_idx(MMLEC_USE_SOURCES_LIMIT, pp_start);
				SourceInfo ___FAR* si = source_list + n_sources;
				// ԍ擾.
				const size_t num_pos = in_buf->idx;
				sec = str_to_num_u8(in_buf, &tmp_u8_static, 0x00, 0xff);
				if(sec != SEC_NO_ERROR) exit_str_proc(sec);
				for(uint16_t j = 0; j < n_sources; ++j)
				{
					if(source_list[j].use_number == tmp_u8_static)
						exit_mml_idx(MMLEC_DUPLICATE_USE_NUM, num_pos);
				}
				si->use_number = tmp_u8_static;
				const size_t n_skip = str_skip(in_buf, SST_SKIP_BLANK_AND_COMMA);
				if(n_skip == 0) exit_mml(MMLEC_UNEXPECTED_CHAR);
				// ^Cv擾.
				const size_t idx_save = in_buf->idx;
				const uint8_t l = str_to_source_type(in_buf, &tmp_u8_static);
				if(l == 0) exit_mml(MMLEC_UNKNOWN_SOURCE_TYPE);
				in_buf->idx += l;
				const uint8_t c = in_buf->buf[in_buf->idx];
				if((c != ';') && !is_whitespace(c)) exit_mml(MMLEC_UNKNOWN_SOURCE_TYPE);
				if(!is_supported_source(tmp_u8_static)) exit_mml_idx(MMLEC_UNSUPPORTED_SOURCE, idx_save);
				si->source_type = tmp_u8_static;
				n_sources += 1;
				newline_chk_blank = 1;
			}
			else if(pp_idx == 9) // OctSwap
			{
				sec = str_to_num_u8(in_buf, &tmp_u8_static, 0, 1);
				if(sec != SEC_NO_ERROR) exit_str_proc(sec);

				cs->oct_swap = (tmp_u8_static != 0);
				newline_chk_blank = 1;
			}
			else if(pp_idx == 10) // QReso
			{
				// 0x00 - 0xff ͈̔͂ƂĐlČォ 8, 16 ̂ǂ炩肷.
				const size_t num_pos = in_buf->idx;
				sec = str_to_num_u8(in_buf, &tmp_u8_static, 0x00, 0xff);
				if(sec != SEC_NO_ERROR) exit_str_proc(sec);
				if(tmp_u8_static != 8 && tmp_u8_static != 16) exit_mml_idx(MMLEC_NUM_NOT_ACCEPTABLE, num_pos);

				cs->q_reso = tmp_u8_static;
				newline_chk_blank = 1;
			}

			//printf("\t%s -> %hhu\n", PREPROCESSORS[pp_idx], pp_idx);

			if(newline_chk_blank)
			{
				sec = move_to_next_line_check_blank(in_buf, ';');
				if(sec != SEC_NO_ERROR) exit_str_proc(sec);
			}
			else { move_to_next_line(in_buf); }
		}
	}
	// 1 #Use oȂG[.
	if(n_sources == 0) exit_mml_err_only(MMLEC_NO_USE_PREPROC);

	// epȃf[^Jnʒuo.
	for(uint16_t i = 0; i < n_sources; ++i)
	{
		uint16_t ___FAR* p = (uint16_t ___FAR*)(out_buf->buf + out_buf->wrote_len);
		p[0] = p[1] = 0;
		out_buf->wrote_len += 4;
	}

	// #Include Œǉ̃t@Cǂł in_buf->read_len t@C̈擪ɐݒ肷.
	// ̐Łus EOF ܂ŃRs[v̂ł̎_ōsKv.
	if(1 < n_included_files) // 1ڂ̃t@C̓vOŎw肳ꂽt@C.
	{
		// ̎ł́Aŏɓǂݑt@C̈ʒu MML obt@.
		in_buf->read_len = include_info_list[1].filename - in_buf->buf;
	}

	// Title, Composer, Arranger, Copyright o̓obt@ɃRs[.
	for(uint8_t i = 0; i < N_STR_OFFSETS; ++i)
	{
		mp->str_offset_arr[i] = out_buf->wrote_len;

		if(pppos_list[i].str_pos != 0)
		{
			copy_string(in_buf, pppos_list[i].str_pos, out_buf, pppos_list[i].pp_pos);
		}
		else
		{
			// ݒȂ炱 NULL u.
			put_null(out_buf, in_buf->idx, "output null char"); // err_idx ͎芸̓ǂݎʒuɂ.
		}
	}

	// }N𒷂Ƀ\[g.
	n2kd_qsort(macros, n_defined_macros, sizeof(Macro), macro_name_len_compare);
	// }N̕ԓmŎ\[g.
	for(uint8_t i = 1; i < n_defined_macros; ++i)
	{
		if(macros[i - 1].name_len != macros[i].name_len) continue;
		const uint8_t same_len_start = i - 1;
		uint8_t j = i;
		for(; j < n_defined_macros; ++j)
		{
			if(macros[j].name_len != macros[same_len_start].name_len) break;
		}
		n2kd_qsort(macros + same_len_start, j - same_len_start, sizeof(Macro), macro_name_lexical_compare);
		i = j + 1;
	}
	// Õ}NȂ`FbN.
	for(uint8_t i = 1; i < n_defined_macros; ++i)
	{
		const Macro ___FAR* m0 = macros + i - 1;
		const Macro ___FAR* m1 = macros + i;
		if(m0->name_len == m1->name_len)
		{
			if(strncmp(in_buf->buf + m0->name_idx, in_buf->buf + m1->name_idx, m0->name_len) == 0)
			{
				extern const char ___FAR msg_macro_same_name[]; // n2km_strs.c
				set_error_info_addnl_msg(msg_macro_same_name);
				exit_mml_idx(MMLEC_MACRO_DEF, (m0->name_idx < m1->name_idx) ? m1->name_idx : m0->name_idx);
			}
		}
	}

	//printf("initial_timer_b: %hhu (%u / %u, %hhu, %hhu)\n", tb, dividend, divisor, cs->zenlen, tempo);
	/*
	print_to_stderr("MACROS:\n");
	for(uint8_t idx = 0; idx < n_defined_macros; ++idx)
	{
		Macro ___FAR* m = macros + idx;
		put_u16_to_stderr(idx);
		print_to_stderr(": [");
		for(size_t i = 0; i < m->name_len; ++i) { putchar_to_stderr(in_buf->buf[m->name_idx + i]); }
		print_to_stderr("] -> [");
		for(size_t i = 0; i < m->body_len; ++i) { putchar_to_stderr(in_buf->buf[m->body_idx + i]); }
		print_to_stderr("]\n");
	}
	print_to_stderr("INCLUDES:\n");
	for(uint8_t i = 0; i < n_included_files; ++i)
	{
		IncludeInfo ___FAR* info = include_info_list + i;
		put_u16_to_stderr(i);
		print_to_stderr(": (name) = (");
		print_to_stderr(info->filename);
		print_to_stderr(")\n");
	}
	print_to_stderr("BORDERS:\n");
	for(uint8_t i = 0; i < n_border_info; ++i)
	{
		BorderInfo ___FAR* info = border_info_list + i;
		put_u16_to_stderr(i);
		print_to_stderr(": (name, pos) = (");
		if(i != n_border_info - 1) print_to_stderr(include_info_list[info->info_idx].filename);
		else print_to_stderr("N/A");
		print_to_stderr(", ");
		put_u16_to_stderr(info->pos);
		print_to_stderr(")\n");
	}
	print_to_stderr("SOURCES:\n");
	for(uint8_t i = 0; i < n_sources; ++i)
	{
		SourceInfo ___FAR* si = source_list + i;
		put_u16_to_stderr(i);
		print_to_stderr(": (name, number) = (");
		print_to_stderr(source_type_to_str(si->source_type));
		print_to_stderr(", ");
		put_u16_to_stderr(source_list->use_number);
		print_to_stderr(")\n");
	}
	// */
}

// ẽRpCsO1񂸂svvZX.
// wb_̃tȌ͊ep init_hoge_header() ֐ōs.
void compile_preprocess2(InputBuffer* in_buf, OutputBuffer* out_buf, CompileStatus* cs, uint16_t source_idx)
{
	(void)out_buf;
	(void)cs;
	(void)source_idx;
	in_buf->idx = in_buf->read_len;
	return;

	// CSM Ή͉
	/*
	StrProcErrorCode sec;

	while(in_buf->idx < in_buf->read_len)
	{
		const uint8_t ch = in_buf->buf[in_buf->idx];
		if(ch != '#')
		{
			move_to_next_line(in_buf);
			continue;
		}

		// vvZbT߂̉߂s.
		const size_t pp_start = in_buf->idx;
		const uint16_t pp_idx = find_preproc_from_list(in_buf, PREPROCESSORS, N_PREPROCESSORS);

		if(pp_idx == 9) // CSMFile
		{
			if(cs->header->flags & HSFLAG_USE_CSM)
			{
				// #CSMFile ̕gp̓G[.
				extern const char ___FAR msg_resue_preproc_per_src[];
				set_error_info_addnl_msg(msg_resue_preproc_per_src);
				exit_mml_idx(MMLEC_REUSE_PREPROCESSOR, pp_start);
			}

			if(cs->header->source_type == SRC_TYPE_OPL3)
			{
				// ԍ擾.
				sec = str_to_num_u8(in_buf, &tmp_u8_static, 0x00, 0xff);
				if(sec != SEC_NO_ERROR) exit_str_proc(sec);
				// ݃RpCΏۂ̉̔ԍƈv邩`FbN.
				if(tmp_u8_static == source_list[source_idx].use_number)
				{
					cs->header->flags |= HSFLAG_USE_CSM;
					// J}΂.
					const size_t n_skip = str_skip(in_buf, SST_SKIP_BLANK_AND_COMMA);
					if(n_skip == 0) exit_mml(MMLEC_UNEXPECTED_CHAR);
					// CSM f[^t@Co.
					((Header_OPL3*)(cs->header))->csm_filename_offset = out_buf->wrote_len;
					copy_string(in_buf, in_buf->idx, out_buf, pp_start);
				}
			}
			else
			{
				// OPL3 ̂ݑΉ.
				exit_mml_idx(MMLEC_UNKNOWN_PREPROCESSOR, pp_start);
			}
		}

		move_to_next_line(in_buf);
	}
	*/
}
