//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// mml_proc.h
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#ifndef N2KC_MML_PROC_H
#define N2KC_MML_PROC_H

#include <stdint.h>

#include "src_type.h"
#include "../iobuffer.h"
#include "../far_ptr.h"

//----------------------------------//
// RpCʂ̃t@C̃wb_ //
//----------------------------------//
#define HEADER_MAGIC_SIZE (4)
#define HEADER_MAGIC_0 (0xce)
#define HEADER_MAGIC_1 (0xb2)
#define HEADER_MAGIC_2 (0xcb)
#define HEADER_MAGIC_3 (0xcd)

// pfBOȂ悤ɂ.
#pragma pack(push, 1)

// Ȃɕt镶f[^̃ItZbgێ\̂Ƌp.
#define N_STR_OFFSETS (4)
typedef struct
{
	uint16_t title_offset;
	uint16_t composer_offset;
	uint16_t arranger_offset;
	uint16_t comment_offset;
} StrOffsets;

typedef union
{
	uint16_t str_offset_arr[N_STR_OFFSETS];
	StrOffsets str_offsets;
} MusicProperties;

// ȃf[^S̗pwb_.
typedef struct
{
	unsigned char magic[HEADER_MAGIC_SIZE];
	uint16_t version_major;
	uint16_t version_minor;
	uint16_t version_beta;
	uint16_t n_sources;
	MusicProperties music_props;
} Header;
// e̋ȃf[^ʒuL^̊Jnʒu.
#define DATA_START_POS_OFFSET (20)

// ̃wb_̋ʕ.
//#define HSFLAG_USE_CSM (0x01)
typedef struct
{
	uint8_t source_type;
	uint8_t flags;
} Header_Source;

#pragma pack(pop)
// pfBO}~\̂͂܂.


// MML RpCɔG[.
typedef enum
{
	MMLEC_NO_ERROR = 0,
	MMLEC_REACH_EOF,			// EOFɓB.
	MMLEC_OUT_SIZE_LIMIT,		// o̓TCY̌Ez.
	MMLEC_UNKNOWN_PREPROCESSOR,	// mȂvvZbT.
	MMLEC_REUSE_PREPROCESSOR,	// gȂvvZbTgꂽ.
	MMLEC_INVALID_PART_SEL,		// ȃp[gw.
	MMLEC_UNKNOWN_OP_CH,		// mȂMML̖ߕ.
	MMLEC_INVALID_VOICE_IDX,	// ԈFw(ڍׂaddnl_msgɏ)
	MMLEC_NOT_NUM,				// l\z镔ɐlȂ.
	MMLEC_UNEXPECTED_CHAR,		// zO̕.
	MMLEC_OCTAVE_OUT_OF_RANGE,	// IN^[uȔ͈͂ɏo悤Ƃ.
	MMLEC_NOTE_NUM_OF_RANGE,	// ԍȔ͈͂ɏo悤Ƃ.
	MMLEC_NUM_SMALL,			// l.
	MMLEC_NUM_LARGE,			// l傫.
	MMLEC_NUM_NOT_ACCEPTABLE,	// z肳ĂlłȂ(SMALL or LARGE ŕ͋CȂp)
	MMLEC_INVALID_NOTE_LEN,		// n  n  zenlen ؂ȂȂ̌ʂ.
	MMLEC_TOO_MUCH_DOTS,		// t_.
	MMLEC_NO_REPEAT_START,		// JԂJnȂ̂ɁAJԂEo/Io.
	MMLEC_REPEAT_NEST_LIMIT,	// JԂ̃lXgx𒴂.
	MMLEC_MULTI_REPEAT_ESC,		// s[g甲閽߂1̌JԂɕo.
	MMLEC_NO_REPEAT_END,		// s[gI߂Ȃ܂܃RpCI.
	MMLEC_UNSUPPORTED_SOURCE,	// RpCɑΉĂȂ.
	MMLEC_INVALID_TIE,			// ^C֌W̃G[.
	MMLEC_INVALID_MOD_LEN,		// ύXߊ֌W̃G[.
	MMLEC_MACRO_DEF,			// }N`֌W̃G[.
	MMLEC_MACRO_EXPAND,			// }NWJ֌W̃G[.
	MMLEC_INVALID_PORTAMENT,	// |^g߂̃G[.
	MMLEC_INFINITE_LOOP,		// L߂Ŗ[v鎞̃G[.
	MMLEC_REACH_INCLUDE_LIMIT,	// CN[hłt@C̏ɒBG[.
	MMLEC_UNKNOWN_SOURCE_TYPE,	// sȉ^Cv.
	MMLEC_USE_SOURCES_LIMIT,	// gpw肳ꂽ̐𒴂.
	MMLEC_NO_USE_PREPROC,		// gpw肳ꂽȂ(#Use Ȃ)
	MMLEC_DUPLICATE_USE_NUM,	// #Use Ŏw肳ꂽԍdĂ.
	MMLEC_INVALID_SET_SCALE,	// XP[w薽߂̃G[.
	MMLEC_NOT_NOTE_OP_CH,		// ߂̕ł͂Ȃ.
	MMLEC_PATH_OPERATION,		// pXɎs(#Include Ȃ).
	MMLEC_OTHER_ERROR,			// ̑̃G[.
	MMLEC_UNKNOWN_ERROR,		// sȃG[.
	N_MML_ERROR_CODES,
} MMLErrorCode;

// s[g߂̃lXgől.
#define REPEAT_NEST_MAX (8)
// }ÑlXgől.
#define MACRO_NEST_MAX (8)
// LFO ̔g`̎ނ̐.
#define N_LFO_WAVE_TYPE (2)

// ʃtO̓e.
#define PFLAG_COMM_0_BREAK 0x0001 // RpCł؂tO.
#define PFLAG_COMM_0_INF_LOOP 0x0002 // L߂̖[vh~p.
#define PFLAG_COMM_0_PORT_OK 0x0004 // |^g߂o͉\ǂ.
// ŗLtO̓e(OPL3)
#define PFLAG_OPL3_0_4OP 0x0001 //  4OP FԂǂ.

// RpC̃p[g̏.
typedef struct
{
	uint16_t clock_buf[REPEAT_NEST_MAX + 1]; // NbNvZp.
	uint16_t clock_buf_esc[REPEAT_NEST_MAX]; // NbNvZ̍ۂɌJԂE߁`JԂI߂̊Ԃ̃NbNL^p.
	uint16_t flag_common_0; // ɂ炸ʉłtO.
	uint16_t flag_specific_0; // ŗL̃tO.
	uint16_t repeat_start_pos[REPEAT_NEST_MAX];
	uint16_t prev_note_pos; // O̔߂̈ʒu(r܂)
	uint8_t note_length;
	uint8_t octave;
	uint8_t n_repeat_nest;
	uint8_t repeat_esc_flag; // REPEAT_NEST_MAX  8 傫Ȃ uint8_t ł͊ԂɍȂȂ̂Œ.

	// ߋLq̔Pʂ̕ω(+127  -128 ܂ł͈̔).
	int8_t scale_setting[7]; // cdefgab ̏ɓĂ.

	// }N֘A.
	uint8_t n_macro_nest;
	InputBuffer macro_nest_stack[MACRO_NEST_MAX];
} PartStatus;
// JԂE߂oǂP̃tOŊǗĂ,
// [ [cd]2 : [ef]2 : ga ]2 ƏꂽɃG[ɂłȂ.
// 肷ɂ͊ǑJԂłJԂE߂ꂽǂL^ĂKv.
// repeat_esc_flag ͂̂߂̕ϐ, NbŇvZɂgĂ.
// ([ cd : [ef]2 ]2  [ef]2 ̃NbNǑJԂ clock_buf_esc ɑ)

// RpC̊eێ\.
#define N_CLOCK_TABLE_ENTRIES (18) // p[gԑ OPL3 ɍ킹Ċm.
typedef struct
{
	uint16_t clock_table[N_CLOCK_TABLE_ENTRIES]; // ep[g̃NbÑe[u.
	Header_Source ___FAR* header; // RpC̉f[^̃wb_ւ̃|C^.
	uint8_t voice_idx_table[256];
	uint8_t voice_registered[256];
	const uint8_t ___FAR* voice_buf; // Ff[^̃obt@.
	const char* part_chars;
	uint16_t source_idx; // RpCΏۂ̉̒ʂԍ.
	char part_char;
	uint8_t n_part_chars;
	uint8_t zenlen; // S̃NbN.
	uint8_t oct_swap; // <, > ߂̃IN^[uωtɂĂ邩ǂ.
	uint8_t q_reso; // Q ߂̕\(8 or 16)
	uint8_t use_number; // RpCΏۂ̉ԍ(#Use, <num>, <type>  <num>)
	PartStatus part_status;
} CompileStatus;

const char ___FAR* mml_error_code_to_str(const MMLErrorCode error_code);

void init_compiler();
void compile_preprocess(InputBuffer* in_buf, OutputBuffer* out_buf, CompileStatus* cs, MusicProperties* mp);
void compile_preprocess2(InputBuffer* in_buf, OutputBuffer* out_buf, CompileStatus* cs, uint16_t source_idx);
void generate_source_header(OutputBuffer* out_buf, CompileStatus* cs);
void compile_voice(InputBuffer* in_buf, OutputBuffer* out_buf, CompileStatus* cs);
void compile_instruction(InputBuffer* in_buf, OutputBuffer* out_buf, CompileStatus* cs);


#endif // N2KC_MML_PROC_H
