//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// src_type.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include "src_type.h"

#include "../util/str_proc.h"
#include "../util/string.h"

static uint16_t tmp_u16_static;

//  source_type ̒萔ɕϊ.
// : str=Ώە, result=ʂi[ϐ̃|C^.
// ߒl: 0=ϊs, 0=.
uint8_t str_to_source_type(InputBuffer* in_buf, uint8_t* result)
{
	static const char* CHIP_NAMES[] = {
		"OPNA", "OPN2", "OPN", "OPL2", "OPL3", "OPL4", "Y8950", "PPZ8", "TMS3631",
		"ADPCM_256K", "ADPCM_32K"
	};

	StrProcErrorCode sec;
	const size_t remain_buf_len = in_buf->read_len - in_buf->idx;
	sec = strcmp_list(in_buf, CHIP_NAMES, sizeof(CHIP_NAMES) / sizeof(char*), remain_buf_len, &tmp_u16_static);
	*result = (uint8_t)tmp_u16_static;

	if(sec != SEC_NO_ERROR) return 0;
	return (uint8_t)strlen(CHIP_NAMES[*result]);
}

// ^Cv𕶎ɕϊ.
// : type=^Cv.
// ߒl: ϊ̕.
const char ___FAR* source_type_to_str(uint8_t type)
{
	extern const char ___FAR* ___FAR source_type_strs[8];
	return source_type_strs[type];
}

// RpCɑΉǂ肷.
// : type=^Cv.
// ߒl: ΉĂ邩ǂ(0: Ή, 0: Ή)
uint16_t is_supported_source(uint8_t type)
{
	if(type == SRC_TYPE_OPL3) return 1;
	return 0;
}
