//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// src_type.h
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#ifndef N2KC_SOURCE_TYPE_H
#define N2KC_SOURCE_TYPE_H

#include "../iobuffer.h"
#include "../far_ptr.h"

#include <stdint.h>

// str_to_chip_type()  strcmp_list() ĂԂƂɉe󂯂яɂȂĂ.
// : OPN  OPNA, OPN2 Oɂ.
#define SRC_TYPE_OPNA       0
#define SRC_TYPE_OPN2       1
#define	SRC_TYPE_OPN        2
#define	SRC_TYPE_OPL2       3
#define SRC_TYPE_OPL3       4
#define SRC_TYPE_OPL4       5
#define SRC_TYPE_Y8950      6
#define SRC_TYPE_PPZ8       7
#define SRC_TYPE_TMS3631    8
#define SRC_TYPE_ADPCM_256K 9
#define SRC_TYPE_ADPCM_32K  10
#define SRC_TYPE_NONE       255

uint8_t str_to_source_type(InputBuffer* in_buf, uint8_t* result);
const char ___FAR* source_type_to_str(uint8_t type);
uint16_t is_supported_source(uint8_t type);

#endif // N2KC_SOURCE_TYPE_H
