//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// ar_shift.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include "../util/ar_shift.h"

int32_t ar_shift(const int32_t num, const uint8_t cnt)
{
	uint32_t result;
#if defined(_MSC_VER)
	__asm
	{
		mov eax, num
		mov cl, cnt
		sar eax, cl
		mov result, eax
	}
#else
	asm volatile(
		".intel_syntax noprefix \n"
		"sar eax, cl            \n"
		".att_syntax            "
		: "=a"(result)
		: "a"(num), "c"(cnt)
	);
#endif
	return result;
}
