//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// fileio.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include "../util/fileio_l.h"

const char* get_mode_str(const uint16_t mode)
{
	if(mode == FILE_MODE_WRITE) return "wb";
	if(mode == FILE_MODE_APPEND) return "r+b";
	return "rb";
}

FILEIO_STATUS open_file(const char* filename, const uint16_t mode, FILE_HANDLE* handle)
{
	*handle = NULL;
	const char* modestr = get_mode_str(mode);
#if defined(_MSC_VER)
	errno_t err = fopen_s(handle, filename, modestr);
	if(err != 0) return -1;
#else
	*handle = fopen(filename, modestr);
	if(*handle == NULL) return -1;
#endif
	if(mode == FILE_MODE_APPEND) { fseek(*handle, 0, SEEK_END); }
	return 0;
}

FILEIO_STATUS close_file(FILE_HANDLE handle)
{
	return fclose(handle);
}

size_t read_file(FILE_HANDLE handle, char* buffer, const size_t len)
{
	return fread(buffer, sizeof(char), len, handle);
}

size_t write_file(FILE_HANDLE handle, const uint8_t ___FAR* buffer, const size_t len)
{
	return fwrite(buffer, sizeof(uint8_t), len, handle);
}

FILE_SIZE get_filesize(FILE_HANDLE handle)
{
	const long orig_pos = ftell(handle);
	fseek(handle, 0, SEEK_END);
	const FILE_SIZE ret = ftell(handle);
	fseek(handle, orig_pos, SEEK_SET);
	return ret;
}

FILEIO_STATUS seek_file(FILE_HANDLE handle, int32_t offset, uint8_t origin)
{
	int org = SEEK_SET;
	if(origin == FILE_SEEK_ORIGIN_CUR) org = SEEK_CUR;
	if(origin == FILE_SEEK_ORIGIN_END) org = SEEK_END;
	return fseek(handle, offset, org);
}

FILEIO_STATUS remove_file(const char* filename)
{
	return remove(filename);
}
