//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// print.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include "../util/print.h"

#include <stdio.h>

void print_to_stderr(const char* str)
{
	fputs(str, stderr);
}

void print_to_stderr_far(const char ___FAR* str)
{
	fputs(str, stderr);
}

void putchar_to_stderr(const char c)
{
	fputc(c, stderr);
}

void put_u16_to_stderr(const uint16_t u16)
{
	fprintf(stderr, "0x%04x", u16);
}

void put_u16_to_stderr_5d(const uint16_t u16)
{
	fprintf(stderr, "%5hu", u16);
}

void put_st_to_stderr_d(const size_t u16)
{
	fprintf(stderr, "%zu", u16);
}
