//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// fileio.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include "fileio.h"
#include "fileio_l.h"

#if !defined(__DOS__)
// malloc(), realloc()
#include <stdlib.h>
#endif

#include "string.h"
#include "path.h"
#include "str_proc.h"
#include "../set_segm.h"
#include "../mml_proc/inc_info.h"
#include "../mml_proc/err_proc.h"
#include "../mml_proc/mml_proc.h"

// t@Co͏̋ʎ.

static uint8_t tmp_u8_static;

static void _close_file_and_exit(FILE_HANDLE h, const FileErrorCode fec, const char* filename)
{
	close_file(h); // ł̎s(ނȂ)ȗ.
	exit_file_op(fec, filename);
}

static void _close_file_and_internal_error(FILE_HANDLE h, const uint16_t memo_code)
{
	close_file(h);
	exit_internal_error(memo_code);
}

// DOS  farstack  open_file() |C^󂯎邽.
static FILE_HANDLE handle;

static char path_work[N2KC_PATH_MAX];

// pos ̈ʒun܂s̍s EOF ܂ł͈̔͂ filename_pos ̖Õt@CŒu.
// (#Include sȂΈȉ̏ƂȂ)
// Epos ͍sł.
// Epos n܂s filename_pos n܂t@C filename_len ̒ő݂Ă.
//  pos  #Include ̍s filename_pos ̍sɊ܂܂t@Cł.
void include_input_mml(InputBuffer* in_buf, const size_t pos, const size_t filename_pos, const size_t filename_len)
{
	extern const char ___FAR msg_too_long_path[];

	// #Include ꂽ MML ̃pXɓǂݍރt@C̃pX쐬.
	uint8_t info_idx = get_include_info_idx(pos);
	if(!set_str_as_path(path_work, include_info_list[info_idx].filename))
	{
		set_error_info_addnl_msg(msg_too_long_path);
		exit_mml_idx(MMLEC_PATH_OPERATION, pos);
	}
	dirname_of_path(path_work);
	const char backup = in_buf->buf[filename_pos + filename_len]; // ۑ(NULL u)
	in_buf->buf[filename_pos + filename_len] = '\0';
	uint8_t append_ok = append_to_path(path_work, in_buf->buf + filename_pos);
	in_buf->buf[filename_pos + filename_len] = backup; // ߂.
	if(!append_ok)
	{
		set_error_info_addnl_msg(msg_too_long_path);
		exit_mml_idx(MMLEC_PATH_OPERATION, pos);
	}

	// include ΏۂJ.
	FILEIO_STATUS st = open_file(path_work, FILE_MODE_READ, &handle);
	if(st != 0) exit_file_op(FEC_OPEN_FAILED, path_work);

	// t@CTCYvZ.
	const FILE_SIZE fsz = get_filesize(handle);
	if(fsz < 0) _close_file_and_exit(handle, FEC_FILE_OP_FAILED, path_work);
	// t@C 0x1a (SUB) 邩mF.
	st = seek_file(handle, fsz - 1, FILE_SEEK_ORIGIN_SET);
	if(st != 0) _close_file_and_exit(handle, FEC_FILE_OP_FAILED, path_work);
	if(read_file(handle, (char*)&tmp_u8_static, 1) != 1) _close_file_and_exit(handle, FEC_READ_FAILED, path_work);
	// 0x1a Γǂݍ܂Ȃ悤Ƀt@CTCY1.
	const size_t filesize = (tmp_u8_static == 0x1a) ? (size_t)(fsz - 1) : (size_t)fsz;
	st = seek_file(handle, 0, FILE_SEEK_ORIGIN_SET); // 擪ɖ߂.
	if(st != 0) _close_file_and_exit(handle, FEC_FILE_OP_FAILED, path_work);

	// u镶(pos ` Ăt@C܂).
	const size_t replaced_len = (filename_pos - pos) + filename_len;
	// t@Cۑ̂ɕKvȃoCg.
	const size_t filename_bufsize = strlen(path_work) + 1;
	// sƃt@C̈ʒũ`FbN.
	// MEMO: vOΑ^ɂȂȂ̂ŃRgAEgĂ.
	//if(pos + replaced_len != filename_pos + filename_bufsize)
	//	_close_file_and_internal_error(handle, INTEC_INVALID_INCLUDE_POS);

	// u͈͂t@Cǂ.
	const uint8_t smaller_file = (filesize < replaced_len);
	// u镶񒷂(Ăt@C + NULL )̍.
	const size_t pre_len = replaced_len - filename_bufsize;
	// include ƂɕKvƂ郁(̊ȒP̂ߍŒł͂Ȃ).
	const size_t needed_len = smaller_file ? filename_bufsize : (filesize - pre_len + filename_bufsize);

#if defined(__DOS__)
	// ̓obt@̎cTCY`FbN.
	if(DOS_IN_BUF_SIZE - in_buf->used_len < needed_len)
		_close_file_and_exit(handle, FEC_FILE_TOO_LARGE, path_work);
#else
	// obt@m.
	const char* old_ptr = in_buf->buf;
	in_buf->buf = (char*)realloc(in_buf->buf, in_buf->used_len + needed_len);
	if(in_buf->buf == NULL) _close_file_and_exit(handle, FEC_ALLOCATION_FAILED, path_work);
	// realloc() Ńobt@\̂Ńt@C̈ʒuXV.
	for(uint8_t i = 1; i < n_included_files; ++i)
	{
		const char* f = include_info_list[i].filename;
		include_info_list[i].filename = in_buf->buf + (f - old_ptr);
	}
#endif
	const size_t old_used_len = in_buf->used_len;
	in_buf->read_len += needed_len;
	in_buf->used_len += needed_len;

	// KvȂuӏȍ~̕(Ɨpf[^܂߂)ɂ炷.
	const size_t moved_len = old_used_len - (pos + replaced_len);
	if(!smaller_file)
	{
		const size_t dst_pos = pos + filesize;
		memmove(in_buf->buf + dst_pos, in_buf->buf + (pos + replaced_len), moved_len);
	}

	// t@Cǂŕ.
	const size_t n_read = read_file(handle, in_buf->buf + pos, filesize);
	if(n_read != filesize) _close_file_and_exit(handle, FEC_READ_FAILED, path_work);
	st = close_file(handle);
	if(st != 0) exit_file_op(FEC_CLOSE_FAILED, path_work);

	// KvȂOɋl߂.
	if(smaller_file)
	{
		const size_t dst_pos = pos + filesize;
		memmove(in_buf->buf + dst_pos, in_buf->buf + (pos + replaced_len), moved_len);
		// in_buf->read_len  used_len .
		in_buf->read_len -= (replaced_len - filesize);
		in_buf->used_len -= (replaced_len - filesize);
	}

	// obt@Ƀt@CpXL^.
	char* saved_filename = in_buf->buf + (in_buf->used_len - filename_bufsize);
#if defined(_MSC_VER)
	strcpy_s(saved_filename, filename_bufsize, path_work);
#else
	strcpy(saved_filename, path_work);
#endif

	// t@Cʒu𓮂(0Ԗڂ root ̃t@CȂ̂ősv).
	for(uint8_t i = 1; i < n_included_files; ++i)
	{
		if(smaller_file) include_info_list[i].filename -= (replaced_len - filesize);
		else include_info_list[i].filename += (filesize - replaced_len);
	}

	const uint16_t ret = add_include_info(saved_filename, pos, replaced_len, n_read);
	if(ret != 0) exit_internal_error(ret);
}

void load_input_mml(const char* in_filename, InputBuffer* in_buf)
{
	FILEIO_STATUS st;

	// t@CJ.
	st = open_file(in_filename, FILE_MODE_READ, &handle);
	if(st != 0) exit_file_op(FEC_OPEN_FAILED, in_filename);

	// t@CTCY`FbN܂̓m.
	const FILE_SIZE filesize = get_filesize(handle);
	if(filesize < 0) _close_file_and_exit(handle, FEC_FILE_OP_FAILED, in_filename);
	if(filesize == 0) _close_file_and_exit(handle, FEC_FILE_EMPTY, in_filename);
	// t@CTCY͍Ōɒu NULL l.
#if defined(__DOS__)
	if(DOS_IN_BUF_SIZE - 1 < filesize) _close_file_and_exit(handle, FEC_FILE_TOO_LARGE, in_filename);
#else
	in_buf->buf = (char*)malloc((size_t)filesize + 1);
	if(in_buf->buf == NULL) _close_file_and_exit(handle, FEC_ALLOCATION_FAILED, in_filename);
#endif

	// t@Cǂݍ.
	// t@C[hs 0 Ԃ邪OɃt@CTCY`FbNĂ̂ŖȂ.
	const size_t n_read = read_file(handle, in_buf->buf, (size_t)filesize);
	if(n_read != (size_t)filesize) _close_file_and_exit(handle, FEC_READ_FAILED, in_filename);

	// t@C.
	st = close_file(handle);
	if(st != 0) exit_file_op(FEC_CLOSE_FAILED, in_filename);

	in_buf->idx = 0;
	in_buf->read_len = n_read;
	in_buf->buf[n_read] = '\0'; // Ō NULL u(EOF ԂœǂݎƊm NULL ǂ߂).
	in_buf->used_len = n_read + 1;

	const uint16_t ret = add_include_info(in_filename, 0, 0, in_buf->read_len);
	if(ret != 0) exit_internal_error(ret);
}

void write_compiled_data(const char* out_filename, OutputBuffer* out_buf, const uint8_t append)
{
	FILEIO_STATUS st;
	const uint16_t mode = append ? FILE_MODE_APPEND : FILE_MODE_WRITE;

	// t@CJ.
	// ȒP̂ߒǋLǂɂ炸t@C𖈉JĕɂȂĂ.
	st = open_file(out_filename, mode, &handle);
	if(st != 0) exit_file_op(FEC_OPEN_FAILED, out_filename);

	// o͂ 2GiB 𒴂Ȃǂ`FbN.
	if(0x7fffffff - out_buf->total_len < out_buf->wrote_len)
		_close_file_and_exit(handle, FEC_OUT_SIZE_LIMIT, out_filename);

	// t@C.
	// G[̂߁Awrote_len  0 Ȃ炻oȂ.
	if(out_buf->wrote_len != 0)
	{
		const size_t n_wrote = write_file(handle, out_buf->buf, out_buf->wrote_len);
		if(n_wrote != (size_t)out_buf->wrote_len) _close_file_and_exit(handle, FEC_WRITE_FAILED, out_filename);
		out_buf->total_len += n_wrote;
	}

	st = close_file(handle);
	if(st != 0) exit_file_op(FEC_CLOSE_FAILED, out_filename);
}

// epf[^̐擪ʒuo.
// OɃwb_o͂ĂKv.
void write_data_start_pos(const char* out_filename, const uint32_t pos, const uint16_t source_idx)
{
	FILEIO_STATUS st = open_file(out_filename, FILE_MODE_APPEND, &handle);
	if(st != 0) exit_file_op(FEC_OPEN_FAILED, out_filename);

	const uint32_t offset = DATA_START_POS_OFFSET + source_idx * 4;
	st = seek_file(handle, offset, FILE_SEEK_ORIGIN_SET);
	if(st != 0) exit_file_op(FEC_SEEK_FAILED, out_filename);

	static uint32_t buf; // pos  near ȃɒu.
	buf = pos;
	const size_t n_wrote = write_file(handle, (uint8_t*)&buf, 4);
	if(n_wrote != 4) _close_file_and_exit(handle, FEC_WRITE_FAILED, out_filename);

	st = close_file(handle);
	if(st != 0) exit_file_op(FEC_CLOSE_FAILED, out_filename);
}

uint8_t remove_out_file_on_error(const char* out_filename)
{
	const FILEIO_STATUS st = remove_file(out_filename);
	return (st == 0);
}

const char ___FAR* file_error_code_to_str(const FileErrorCode fec)
{
	extern const char ___FAR msg_unknown_file_error_code[]; // strs.c
	extern const char ___FAR* ___FAR FILE_ERROR_STRINGS[];

	if(N_FILE_ERROR_CODES <= fec) return msg_unknown_file_error_code;
	else return FILE_ERROR_STRINGS[fec];
}
