//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// fileio.h
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#ifndef N2KC_FILEIO_H
#define N2KC_FILEIO_H

#include <stdint.h>
#include <stddef.h>

#include "../iobuffer.h"
#include "../far_ptr.h"

//  enum  error_proc.c  uint16_t ɃLXgĂ̂Œ.
typedef enum
{
	FEC_NO_ERROR = 0,
	FEC_OPEN_FAILED,
	FEC_FILE_TOO_LARGE,
	FEC_READ_FAILED,
	FEC_WRITE_FAILED,
	FEC_CLOSE_FAILED,
	FEC_FILE_OP_FAILED,
	FEC_ALLOCATION_FAILED, // win łł̓t@Cǂݍݎɓ̓obt@̊mۂ邽ߓZ߂.
	FEC_FILE_EMPTY,
	FEC_SEEK_FAILED,
	FEC_OUT_SIZE_LIMIT,
	FEC_OTHER_ERROR,
	N_FILE_ERROR_CODES,
} FileErrorCode;

// load_input_mml() œnt@C̓vOI܂ł̎Kv.
// IncludeInfo ɓo^邽.
void load_input_mml(const char* in_filename, InputBuffer* in_buf);

void include_input_mml(InputBuffer* in_buf, const size_t pos, const size_t filename_pos, const size_t filename_len);

void write_compiled_data(const char* out_filename, OutputBuffer* out_buf, const uint8_t append);
void write_data_start_pos(const char* out_filename, const uint32_t pos, const uint16_t source_idx);

//  remove_file ̃bp fileio_l.h OɌȂ߂ɒ`.
// err_proc() ̌Ăяô݂z.
// ߒl: (0: , 0: s)
uint8_t remove_out_file_on_error(const char* out_filename);

const char ___FAR* file_error_code_to_str(const FileErrorCode fec);

#endif // N2KC_FILEIO_H
