//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// fileio_l.h
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#ifndef N2KC_FILEIO_LOW_LEVEL_H
#define N2KC_FILEIO_LOW_LEVEL_H

// MML RpC璼ڎgKv̂Ȃ჌xt@C.
// MML RpC fileio.h  include Α悤ɂĂ.

#include <stddef.h>
#include <stdint.h>
#include "../far_ptr.h"

#if defined(__DOS__)
typedef uint16_t FILE_HANDLE;
typedef int16_t FILEIO_STATUS;
typedef int32_t FILE_SIZE;
#else
#include <stdio.h>
typedef FILE* FILE_HANDLE;
typedef int FILEIO_STATUS;
typedef long FILE_SIZE;
#endif

#define FILE_MODE_READ   0
#define FILE_MODE_WRITE  1
#define FILE_MODE_APPEND 2 // r+b ŊJ(a łȂ̂Œ)

#define FILE_SEEK_ORIGIN_SET 0
#define FILE_SEEK_ORIGIN_CUR 1
#define FILE_SEEK_ORIGIN_END 2

// ˑ(ʕ).
// open_file() ͐ 0 Ԃ.
// read_file() ͓ǂݍݎs 0 Ԃ(OɃt@CTCY0ǂv`FbN)
// write_file() ͏ݎs 0 Ԃ(ރf[^0oCgȂ炻܂ȂƂŃG[肪\)
// remove_file() ͐0Ԃ.
FILEIO_STATUS open_file(const char* filename, const uint16_t mode, FILE_HANDLE* handle);
FILEIO_STATUS close_file(FILE_HANDLE handle);
size_t read_file(FILE_HANDLE handle, char* buffer, const size_t len);
size_t write_file(FILE_HANDLE handle, const uint8_t ___FAR* buffer, const size_t len);
FILE_SIZE get_filesize(FILE_HANDLE handle);
FILEIO_STATUS seek_file(FILE_HANDLE handle, int32_t offset, uint8_t origin);
FILEIO_STATUS remove_file(const char* filename);

#endif // N2KC_FILEIO_LOW_LEVEL_H
