//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// path.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include "path.h"
#include "string.h"

#include <stddef.h>

#if defined(__linux__)
	#define DIR_DELIM ('/')
	#define IS_SJIS (0)
#else
	#define DIR_DELIM ('\\')
	#define IS_SJIS (1)
#endif

// Shift_JIS-2004 ɏ].
static uint8_t is_sjis_char(const void* p_ch)
{
	const uint8_t c0 = *((const uint8_t*)p_ch + 0);
	const uint8_t c1 = *((const uint8_t*)p_ch + 1);
	if(c0 < 0x81 || (0x9f < c0 && c0 < 0xe0) || (0xfc < c0)) { return 0; }
	if(0x40 <= c1 && c1 != 0x7f && c1 <= 0xfc) { return 1; }
	return 0;
}

// ApX؂蕶yі̃pX؂蕶菜.
static void remove_extra_delim_of_path(char* p)
{
	// A؂蕶폜.
	char ch;
	uint8_t has_deilm = 0;
	for(size_t i = 0; p[i] != '\0'; ++i)
	{
		ch = p[i];
		if(ch != DIR_DELIM) has_deilm = 0;
		else
		{
#if IS_SJIS
			if(i != 0 && is_sjis_char(p + (i - 1)))
			{
				has_deilm = 0;
				continue;
			}
#endif
			if(!has_deilm) { has_deilm = 1; }
			else
			{
				// path[i + 1] ` '\0' 1O֋l߂.
				// MEMO: A؂蕶̌ɐƎv.
				for(size_t x = i; ; ++x)
				{
					if((p[x] = p[x + 1]) == '\0') break;
				}
			}
		}
	}

	// ̋؂蕶`FbN(u/v͍̎폜Ȃ)
	size_t l = strlen(p);
#if IS_SJIS
	if(2 <= l && !is_sjis_char(p + (l - 2)))
#else
	if(2 <= l)
#endif
	{
		if(p[l - 1] == DIR_DELIM) p[l - 1] = '\0';
	}
}

void dirname_of_path(char* p)
{
	// Ō̃pX؂蕶T.
	uint8_t delim_found = 0;
	size_t delim_pos = 0;
	for(size_t i = 0; p[i] != '\0'; ++i)
	{
		const char ch = p[i];
		if(ch == DIR_DELIM)
		{
#if IS_SJIS
			if(i == 0)
			{
				delim_found = 1;
				delim_pos = i;
			}
			else
			{
				if(!is_sjis_char(p + (i - 1))) // _̊mF.
				{
					delim_found = 1;
					delim_pos = i;
				}
			}
#else
			delim_found = 1;
			delim_pos = i;
#endif
		}
	}

	if(!delim_found) p[0] = '\0'; // pX؂蕶Ȃΐ擪 NULL terminate .
	else
	{
		// Ō̃pX؂蕶̈ʒu NULL terminate .
		// u/v݂̂̃pX.
		if(1 <= delim_pos) p[delim_pos] = '\0';
	}
}

uint8_t append_to_path(char* p, const char* s)
{
	size_t lp = strlen(p);
	const size_t ls = strlen(s);
	if(ls == 0) return 0;

	// ǉ̃f~^ NULL ܂߂Č̕񒷂vZ.
	// MEMO: p u/vꍇ1]T邪lڂĂ.
	if(N2KC_PATH_MAX < (lp + ls + 2)) return 0;

	// p 󕶎łȂ[g̃pXłȂȂf~^ǉ.
	if((lp != 0) && !((lp == 1) && (p[0] == DIR_DELIM)))
		p[lp++] = DIR_DELIM;

	// Rs[.
	for(size_t i = 0; ; ++i)
	{
		if((p[lp + i] = s[i]) == '\0') break;
	}
	
	remove_extra_delim_of_path(p);
	return 1;
}

uint8_t set_str_as_path(char* p, const char* s)
{
	p[0] = '\0';
	return append_to_path(p, s);
}
