//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// path.h
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#ifndef N2KC_PATH_H
#define N2KC_PATH_H

#include <stdint.h>

#include "../far_ptr.h"

#if defined(__DOS__)
	// hCu + "/"(root) + int 21h (ah=47h) ԂpX̃TCY.
	#define N2KC_PATH_MAX (3 + 64)
#elif defined(_MSC_VER)
	#include <Windows.h>
	#define N2KC_PATH_MAX (MAX_PATH)
#elif defined(__linux__)
	#include <linux/limits.h>
	#define N2KC_PATH_MAX (PATH_MAX)
#endif

void dirname_of_path(char* p);

// ߒl: (0: , 0: s)
// s̏ꍇ p ̓e͕ωȂ.
uint8_t append_to_path(char* p, const char* s);

// ߒl: (0: , 0: s)
uint8_t set_str_as_path(char* p, const char* s);

#endif // N2KC_PATH_H
