//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// str_proc.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include "str_proc.h"

#include "string.h"
#include "muldiv32.h"


// c sȊŐ󔒕񂩔肷.
int8_t is_blank(const char c)
{
	if(c == ' ' || c == '\t') return 1;
	else return 0;
}

// c s܂߂ċ󔒕肷.
int8_t is_whitespace(const char c)
{
	if(c == ' ' || c == '\t' || c == '\r' || c == '\n') return 1;
	else return 0;
}

// c  [0-9] 肷.
int8_t is_digit(const char c)
{
	if('0' <= c && c <= '9') return 1;
	else return 0;
}

// c  [0-9a-fA-F] 肷.
int8_t is_hexdigit(const char c)
{
	if('0' <= c && c <= '9') return 1;
	switch(c)
	{
		case 'A':
		case 'a':
		case 'B':
		case 'b':
		case 'C':
		case 'c':
		case 'D':
		case 'd':
		case 'E':
		case 'e':
		case 'F':
		case 'f':
			return 1;
	}
	return 0;
}

// c s肷.
int8_t is_newline(const char c)
{
	if(c == '\n' || c == '\r') return 1;
	else return 0;
}

// c  sjis ̑1oCgǂ肷(Ƀ_p)
int8_t is_sjis_first_byte(const char c)
{
	if(0x81 <= c && c <= 0x9f) return 1;
	else if(0xe0 <= c && c <= 0xef) return 1;
	return 0;
}

// c 16i1ƎvĐlɒ.
uint8_t char_to_hex(const char c)
{
	if('0' <= c && c <= '9') return (c - '0');
	switch(c)
	{
		case 'A':
		case 'a':
			return 0x0a;
		case 'B':
		case 'b':
			return 0x0b;
		case 'C':
		case 'c':
			return 0x0c;
		case 'D':
		case 'd':
			return 0x0d;
		case 'E':
		case 'e':
			return 0x0e;
		case 'F':
		case 'f':
			return 0x0f;
	}
	return 0;
}

// t@C|C^̒l̍s̐擪ɂ( CR / CRLF / LF ̒܂œǂݔ΂)
// s̑O read_len ɂ́At@C|C^ EOF w.
void move_to_next_line(InputBuffer* in_buf)
{
	while(in_buf->idx < in_buf->read_len)
	{
		const char ch = in_buf->buf[(in_buf->idx)++];
		if(ch == '\r') // CR
		{
			if(in_buf->read_len <= in_buf->idx) break; // EOF
			if(in_buf->buf[in_buf->idx] == '\n') // CRLF
				in_buf->idx += 1;
			break;
		}
		else if(ch == '\n') //LF
		{
			break;
		}
	}
}

// t@C|C^̉s̏܂Ői߂.
// łɉs̏ɏĂꍇ͓Ȃ.
// s̑O read_len ɂ́At@C|C^ EOF w.
void move_to_EOL(InputBuffer* in_buf)
{
	while(in_buf->idx < in_buf->read_len)
	{
		const char ch = in_buf->buf[in_buf->idx];
		if(is_newline(ch)) break;
		in_buf->idx += 1;
	}
}

// ̉s EOF ܂łɋ󔒕yуRg݂Ă邩`FbNȂ玟̍s֍s.
StrProcErrorCode move_to_next_line_check_blank(InputBuffer* in_buf, const char comment_start)
{
	while(in_buf->idx < in_buf->read_len)
	{
		const char c = in_buf->buf[in_buf->idx];
		if(c == comment_start || c == '\n' || c == '\r')
		{
			move_to_next_line(in_buf);
			return SEC_NO_ERROR;
		}
		else if(is_blank(c))
		{
			in_buf->idx += 1;
		}
		else { return SEC_UNEXPECTED_CHAR; }
	}
	return SEC_NO_ERROR;
}

// 󔒕J}ǂݔ΂.
// ߒl: ǂݔ΂.
size_t str_skip(InputBuffer* in_buf, const StrProcSkipType skip)
{
	if(in_buf->read_len <= in_buf->idx) return 0;

	const int8_t skip_comma = skip & SST_MASK_COMMA;
	int8_t (*chkfnk)(const char) = (skip & SST_MASK_WHITESPACE) ? is_whitespace : is_blank;
	const int8_t skip_hexnum = skip & SST_MASK_HEXNUM;

	size_t ret = 0;
	while(1)
	{
		const uint8_t ch = in_buf->buf[in_buf->idx];
		if(!((*chkfnk)(ch) || (skip_comma && ch == ',') || (skip_hexnum && is_hexdigit(ch)))) break;
		in_buf->idx += 1;
		ret += 1;
		if(in_buf->read_len <= in_buf->idx) break;
	}
	return ret;
}

// 16i prefix (0x) 邩mF.
// prefix ꍇ in_buf->idx i.
static uint8_t check_hex_prefix(InputBuffer* in_buf)
{
	uint8_t is_hex = 0;
	if(2 <= in_buf->read_len - in_buf->idx) // 0x ݂ɂ͏ȂƂ2Kv.
	{
		const char prefix_0 = in_buf->buf[in_buf->idx];
		const char prefix_x = in_buf->buf[in_buf->idx + 1];
		if(prefix_0 == '0' && prefix_x == 'x')
		{
			is_hex = 1;
			in_buf->idx += 2;
		}
	}
	return is_hex;
}

// num Ɍ݂̃t@C|C^̈ʒu畄Ȃ16i10iǂ.
// ̃t@C|C^́Aɕϊłΐl̎wAϊłȂΓȂ.
// EOF ɓBĂASEC_NOT_NUM Ԃ.
StrProcErrorCode str_to_num_u8(InputBuffer* in_buf, uint8_t* num, const uint8_t min, const uint8_t max)
{
	if(in_buf->read_len <= in_buf->idx) return SEC_NOT_NUM;

	// l锤̈ʒuL^.
	const size_t num_start = in_buf->idx;

	// 16i prefix (0x) 邩mF.
	const uint8_t is_hex = check_hex_prefix(in_buf);
	if(is_hex && in_buf->read_len <= in_buf->idx) return SEC_NOT_NUM; // 0xĂ̌オEOF

	// l邩`FbN.
	if(is_hex)
	{
		if(!is_hexdigit(in_buf->buf[in_buf->idx])) { goto str_to_num_u8_not_num; }
	}
	else
	{
		if(!is_digit(in_buf->buf[in_buf->idx])) { goto str_to_num_u8_not_num; }
	}

	// A鐔lǂ(EOF ߂)
	uint16_t tmp = 0; // 召r̂߂ɓ uint16_t ł.
	while(1)
	{
		if(is_hex)
			tmp = (tmp << 4) + char_to_hex(in_buf->buf[in_buf->idx]);
		else
			tmp = (tmp * 10) + in_buf->buf[in_buf->idx] - '0';

		if((uint16_t)max < tmp)
		{
			in_buf->idx = num_start;
			return SEC_NUM_LARGE;
		}

		in_buf->idx += 1;

		if(in_buf->read_len <= in_buf->idx) break;
		if(is_hex && !is_hexdigit(in_buf->buf[in_buf->idx])) break;
		if(!is_hex && !is_digit(in_buf->buf[in_buf->idx])) break;
	}

	if(tmp < (uint16_t)min)
	{
		in_buf->idx = num_start;
		return SEC_NUM_SMALL;
	}

	*num = (uint8_t)tmp;

	return SEC_NO_ERROR;

str_to_num_u8_not_num:
	in_buf->idx = num_start;
	return SEC_NOT_NUM;
}

StrProcErrorCode str_to_num_i16(InputBuffer* in_buf, int16_t* num, const int16_t min, const int16_t max)
{
	if(in_buf->read_len <= in_buf->idx) return SEC_NOT_NUM;

	const size_t num_start = in_buf->idx;

	// ̐`FbN.
	uint8_t is_minus = 0;
	if(in_buf->buf[in_buf->idx] == '-')
	{
		is_minus = 1;
		in_buf->idx += 1;
		str_skip(in_buf, SST_SKIP_BLANK);
		if(in_buf->read_len <= in_buf->idx) return SEC_NOT_NUM;
	}

	// 16i`FbN.
	const uint8_t is_hex = check_hex_prefix(in_buf);
	if(is_hex && in_buf->read_len <= in_buf->idx) return SEC_NOT_NUM;

	// l邩`FbN.
	if(is_hex && !is_hexdigit(in_buf->buf[in_buf->idx])) { goto str_to_num_i16_not_num; }
	if(!is_hex && !is_digit(in_buf->buf[in_buf->idx])) { goto str_to_num_i16_not_num; }

	// A鐔lǂ.
	uint16_t tmp = 0;
	while(1)
	{
		if(is_hex) tmp = (tmp << 4) + char_to_hex(in_buf->buf[in_buf->idx]);
		else tmp = (tmp * 10) + in_buf->buf[in_buf->idx] - '0';

		// ő, ŏ̃`FbN(INT16_MAX, INT16_MIN𒴂ꍇG[ɂ)
		if(is_minus)
		{
			const uint16_t plus_min = -min;
			if(plus_min < tmp || 0x8000 < tmp)
			{
				in_buf->idx = num_start;
				return SEC_NUM_SMALL;
			}
		}
		else
		{
			if((uint16_t)max < tmp || 0x7fff < tmp)
			{
				in_buf->idx = num_start;
				return SEC_NUM_LARGE;
			}
		}

		in_buf->idx += 1;
		if(in_buf->read_len <= in_buf->idx) break;
		if(is_hex && !is_hexdigit(in_buf->buf[in_buf->idx])) break;
		if(!is_hex && !is_digit(in_buf->buf[in_buf->idx])) break;
	}

	if(is_minus) *num = -((int16_t)tmp);
	else *num = (int16_t)tmp;

	return SEC_NO_ERROR;

str_to_num_i16_not_num:
	in_buf->idx = num_start;
	return SEC_NOT_NUM;
}

StrProcErrorCode str_to_num_u32(InputBuffer* in_buf, uint32_t* num, const uint32_t min, const uint32_t max)
{
	if(in_buf->read_len <= in_buf->idx) return SEC_NOT_NUM;

	const size_t num_start = in_buf->idx;

	// 16i prefix ̃`FbN.
	const uint8_t is_hex = check_hex_prefix(in_buf);
	if(is_hex && in_buf->read_len <= in_buf->idx) return SEC_NOT_NUM; // 0x/0XĂ̌オEOF

	// l邩`FbN.
	if(is_hex)
	{
		if(!is_hexdigit(in_buf->buf[in_buf->idx])) { goto str_to_num_u32_not_num; }
	}
	else
	{
		if(!is_digit(in_buf->buf[in_buf->idx])) { goto str_to_num_u32_not_num; }
	}

	// A鐔lǂ.
	uint32_t val = 0;
	while(1)
	{
		uint8_t tmp = 0; // ɑl.
		if(is_hex) tmp = char_to_hex(in_buf->buf[in_buf->idx]);
		else tmp = in_buf->buf[in_buf->idx] - '0';

		if(is_hex)
		{
			// Vtgł邩`FbN.
			if(val & 0xf0000000) { goto str_to_num_u32_too_large; }
			val <<= 4;
		}
		else
		{
			// 10{ł邩`FbN.
			if(429496729 < val) { goto str_to_num_u32_too_large; }
			val = mul_u32(val, 10);
		}
		// 邩`FbN.
		if(max - val < (uint32_t)tmp) { goto str_to_num_u32_too_large; }
		val += tmp;
		in_buf->idx += 1;

		if(in_buf->read_len <= in_buf->idx) break;
		if(is_hex && !is_hexdigit(in_buf->buf[in_buf->idx])) break;
		if(!is_hex && !is_digit(in_buf->buf[in_buf->idx])) break;
	}

	if(val < min)
	{
		in_buf->idx = num_start;
		return SEC_NUM_SMALL;
	}

	*num = val;
	return SEC_NO_ERROR;

str_to_num_u32_not_num:
	in_buf->idx = num_start;
	return SEC_NOT_NUM;

str_to_num_u32_too_large:
	in_buf->idx = num_start;
	return SEC_NUM_LARGE;
}

// ݂̃obt@ǂݏoʒu strings Ɋ܂܂镶݂邩ׂ(strings Ɋ܂܂镶񒷂͍ő 255 ܂)
// r͒P strcmp() JԂȂ̂ŁAstrings ̏̕Ԃ͌ĂяoœK؂ȏԂɂĂKv.
// ֐߂Aobt@ǂݏoʒu͓ĂȂ.
// ̌ɋ󔒂̃`FbN͂Ȃ̂ŕKvɉĒǉ̃R[h.
StrProcErrorCode strcmp_list(InputBuffer* in_buf, const char** strings, uint16_t n_strings, size_t maxlen, uint16_t* result)
{
	for(uint16_t i = 0; i < n_strings; ++i)
	{
		// TODO:  strnlen() ̖ʂȂ̂ŉƂ.
		size_t len = strlen(strings[i]);
		if(maxlen < len) continue; // rΏۂ̒̕ZȂrXLbv.
		if(strncmp(in_buf->buf + in_buf->idx, strings[i], len) == 0)
		{
			*result = i;
			return SEC_NO_ERROR;
		}
	}

	return SEC_STRING_NOT_FOUND;
}
