//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// str_proc.h
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#ifndef N2KC_STR_PROC_H
#define N2KC_STR_PROC_H

#include <stdint.h>

#include "../iobuffer.h"

typedef enum
{
	SEC_NO_ERROR = 0,
	SEC_EOF,				// EOF ɓB.
	SEC_NOT_NUM,			// lz肳锤lȂ.
	SEC_NUM_SMALL,			// 񂩂ϊlw肳ꂽŏl菬.
	SEC_NUM_LARGE,			// 񂩂ϊlw肳ꂽől傫.
	SEC_UNEXPECTED_CHAR,	// zO̕.
	SEC_STRING_NOT_FOUND,	// 񂪌Ȃ.
} StrProcErrorCode;

// 󔒕J}΂ۂ̕ (BLANK  WHITESPACE ̋ʂ 1bit ڂōsĂ)
// BLANK  WHITESPACE ̋ is_blank(), is_whitespace() QƂ̂.
#define SST_MASK_BLANK (0x00)
#define SST_MASK_WHITESPACE (0x01)
#define SST_MASK_COMMA (0x02)
#define SST_MASK_HEXNUM (0x04)
typedef enum
{
	SST_SKIP_BLANK = SST_MASK_BLANK,
	SST_SKIP_WHITESPACE = SST_MASK_WHITESPACE,
	SST_SKIP_BLANK_AND_COMMA = (SST_MASK_BLANK | SST_MASK_COMMA),
	SST_SKIP_WHITESPACE_AND_COMMA = (SST_MASK_WHITESPACE | SST_MASK_COMMA),
	SST_SKIP_BLANK_AND_COMMA_AND_HEXNUM = (SST_MASK_BLANK | SST_MASK_COMMA | SST_MASK_HEXNUM),
} StrProcSkipType;

// tXLbv̕.
typedef enum
{
	SSCT_SKIP_BLANK_AND_ONE_COMMNA, // 󔒂ƃJ}1΂.
} StrProcCondSkipType;

int8_t is_blank(const char c);
int8_t is_whitespace(const char c);
int8_t is_digit(const char c);
int8_t is_hexdigit(const char c);
int8_t is_newline(const char c);
int8_t is_sjis_first_byte(const char c);

uint8_t char_to_hex(const char c);

void move_to_next_line(InputBuffer* in_buf);
void move_to_EOL(InputBuffer* in_buf);
StrProcErrorCode move_to_next_line_check_blank(InputBuffer* in_buf, const char comment_start);

size_t str_skip(InputBuffer* in_buf, const StrProcSkipType skip);

StrProcErrorCode str_to_num_u8(InputBuffer* in_buf, uint8_t* num, const uint8_t min, const uint8_t max);
StrProcErrorCode str_to_num_i16(InputBuffer* in_buf, int16_t* num, const int16_t min, const int16_t max);
StrProcErrorCode str_to_num_u32(InputBuffer* in_buf, uint32_t* num, const uint32_t min, const uint32_t max);

StrProcErrorCode strcmp_list(InputBuffer* in_buf, const char** strings, uint16_t n_strings, size_t maxlen, uint16_t* result);

#endif // N2KC_STR_PROC_H
