//--------------------------------------------------------
// N2KC MML Compiler for N2KD version 1.0a (beta 2b)
// string.h
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#ifndef N2KC_STRING_H
#define N2KC_STRING_H

#include "../far_ptr.h"

#if defined(__DOS__)
	#include <stddef.h>
	#include <stdint.h>

	// DOS p string.h ̌݊.
	size_t strlen(const char* s);
	char* strcpy(char* dst, const char* src);
	int strncmp(const char* s1, const char* s2, size_t maxlen);
	void* memmove(void __far* dest, const void __far* src, size_t len);
#else
	#include <string.h>
#endif

#endif // N2KC_STRING_H
