//--------------------------------------------------------
// N2KD FM Driver version 1.0a (beta 2b)
// common.h
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#ifndef N2KD_CONSTS_H
#define N2KD_CONSTS_H

// common.inc ̒l̂ C ̃R[hGKv̂̂𔲐wb_.
// ڍׂȐ common.inc QƂ̂.

#include <stdint.h>

#pragma pack(push, 1)

// xN^.
#define TSR_VECTOR 0x4e

// ̍ő吔.
#define N_MAX_SOURCES 16

// ̎.
#define SRC_TYPE_NONE       255
#define SRC_TYPE_OPNA       0
#define SRC_TYPE_OPN2       1
#define	SRC_TYPE_OPN        2
#define	SRC_TYPE_OPL2       3
#define SRC_TYPE_OPL3       4
#define SRC_TYPE_OPL4       5
#define SRC_TYPE_Y8950      6
#define SRC_TYPE_PPZ8       7
#define SRC_TYPE_TMS3631    8
#define SRC_TYPE_ADPCM_256K 9
#define SRC_TYPE_ADPCM_32K  10
#define N_SOURCE_TYPES      11

//  IO |[g\\.
typedef struct
{
	uint16_t addr0;
	uint16_t data0;
	uint16_t addr1;
	uint16_t data1;
	uint16_t wait_;
} IOPort;

// Fꂽ\\.
#define SOURCE_FLAG_ASSIGNED (0x01)
typedef struct
{
	uint8_t type_;
	uint8_t flags;
	uint16_t cont_seg;
	uint16_t cont_data_seg;
	IOPort ioport;
} Source;


// R[h̎(control type)
#define CONT_OPNA		0
#define CONT_OPL3		1
#define CONT_PPZ8		2
#define CONT_ADPCM		3
#define CONT_TMS3631	4
#define N_CONTROL_TYPES	5

// R[hZOg擪̃f[^̈.
typedef struct {
	uint16_t init_proc;
	uint16_t play_proc;
	uint16_t mute_proc;
	uint16_t fin_proc;
	uint16_t music_query_proc;
	uint16_t tsr_group_seg;
} DrvProcTable;

// f[^̈`̃p[^.
typedef struct {
	IOPort ioport;
	uint16_t tsr_group_seg;
	uint8_t type_;
	uint8_t padding;
} DriverParam;


// 풓^C}̎.
#if TARGET == TARGET_98
#define TIMER_TYPE_OPN		0
#define TIMER_TYPE_PIT_5M	1
#define TIMER_TYPE_PIT_8M	2
#else
#define TIMER_TYPE_PIT		0
#define TIMER_TYPE_SB		1
#endif

// VXeNbN.
#define SYSCLK_8M	0
#define SYSCLK_5M	1

// PIT  IO |[g.
#if TARGET == TARGET_98
#define IOPORT_PIC_M_IMR	0x02
#define IOPORT_PIC_S_IMR	0x0a
#else
#define IOPORT_PIC_M_IMR	0x21
#define IOPORT_PIC_S_IMR	0xa1
#endif

#pragma pack(pop)

#endif // #ifndef N2KD_CONSTS_H
