;--------------------------------------------------------
; N2KD FM Driver version 1.0a (beta 2b)
; common.inc
; Copyright (C) 2021-2026 Y. Shiokami
; Released under the 3-clause BSD License.
;--------------------------------------------------------

;----------------------------------------------------------
; xN^.
TSR_VECTOR	equ 4eh

;----------------------------------------------------------
; ő̉(ő 127 ܂).
; "2{CfbNXKvɂȂ2{Ă1oCgɎ܂"
; ƂO̍œKsĂӏ邽.
N_MAX_SOURCES	equ 16

; ̎(source type, ő 127 ܂).
SRCT_NO_TYPE        equ 255
SRC_TYPE_OPNA       equ 0
SRC_TYPE_OPN2       equ 1
SRC_TYPE_OPN        equ 2
SRC_TYPE_OPL2       equ 3
SRC_TYPE_OPL3       equ 4
SRC_TYPE_OPL4       equ 5
SRC_TYPE_Y8950      equ 6
SRC_TYPE_PPZ8       equ 7
SRC_TYPE_TMS3631    equ 8
SRC_TYPE_ADPCM_256K equ 9
SRC_TYPE_ADPCM_32K  equ 10
N_SOURCE_TYPES      equ 11
;#define ST_OPN3	(6) // CSM 󖢑ΉȂ̂ OPNA ɓ.
;#define ST_OPM	(7) // mF.
;#define ST_OPL4	(8) // mF(SPB-98).
;#define ST_86PCM	(9) // ƎΉ̗\薳.
;#define ST_XMATE_PCM	(10) // .

;  IO |[g\\.
IOPort STRUCT
	addr0	dw ?	; IO |[gɃANZXȂ0ɂ(ex. PPZ8)
	data0	dw ?	; .
	addr1	dw ?	; , WX^̏ꍇ0ɂ.
	data1	dw ?	; , .
	wait_	dw ?
IOPort ENDS
IF sizeof(IOPort) MOD 2 NE 0
	.err <IOPort \̂̃TCYł>
ENDIF

; Fꂽ\\.
; IOPort ͕̕Kvɉ(PPZ8 )p̂ɂKv邩Ȃ.
SOURCE_FLAG_ASSIGNED	equ 01h
Source STRUCT
	type_		db ?
	flags		db ?
	cont_seg	dw ?	; Ή鐧R[hZOgAhX.
	cont_data_seg	dw ?	; Ή鐧̈悪ZOgAhX.
	IOPort		ioport {}	; IO |[g֘A.
Source ENDS
IF sizeof(Source) MOD 2 NE 0
	.err <Source \̂̃TCYł>
ENDIF


; R[h̎(control type)
CONT_OPNA	equ 0	; OPN n̉̐S.
CONT_OPL3	equ 1	; OPL n̉̐S.
CONT_PPZ8	equ 2	; PPZ8 ̐S.
CONT_ADPCM	equ 3	; ADPCM(OPNA, Y8950)̐S.
CONT_TMS3631	equ 4	; TMS3631 ̐S.
N_CONTROL_TYPES	equ 5


IF TARGET EQ TARGET_98
TIMER_TYPE_OPN		equ 0	; OPN(A) ̃^C} B
TIMER_TYPE_PIT_5M	equ 1	; 5MHz n}V 8253A
TIMER_TYPE_PIT_8M	equ 2	; 8MHz n}V 8253A
ELSE
TIMER_TYPE_PIT		equ 0	; PC/AT ݊@ 8253A/8254A
TIMER_TYPE_SB		equ 1	; PC/AT ݊@ SoundBlaster
ENDIF


SYSCLK_8M equ 0
SYSCLK_5M equ 1

;----------------------------------------------------------
; t@C֌W̍\.
; epȃf[^`ʕ.
Header_Source STRUCT
	source_type	db ?
	flags		db ?
Header_Source ENDS

;----------------------------------------------------------
; ŗL̏.
N_PARTS_OPN		equ (3 + 3 + 3)	; 3FM + 3SSG + 3FM_EX
N_PARTS_OPL2		equ 9
N_PARTS_Y8950		equ 9
N_PARTS_OPNA		equ (6 + 3 + 3)	; 6FM + 3SSG + 3FM_EX
N_PARTS_OPL3		equ 18
N_PARTS_OPN2		equ (6 + 3)	; 6FM + 3FM_EX
N_PARTS_PPZ8		equ 8
N_PARTS_ADPCM_256K	equ 1
N_PARTS_ADPCM_32K	equ 1


;----------------------------------------------------------
; IO |[gANZXx}N.
; 98 ł 5fh ւ IO óA PC/AT ł͎̖߂ւ jmp ő҂.
IO_WAIT MACRO count:REQ
  IF TARGET EQ TARGET_98
    REPEAT count
	out	5fh, al
    ENDM
  ELSE
    REPEAT count
	jmp	$ + 2
    ENDM
  ENDIF
ENDM

; PC-98x1  PC/AT ŃR[h𓝈\ IO |[g̒萔`.
IF TARGET EQ TARGET_98
IOPORT_PIT_CNT0		equ 71h		; PIT JEgWX^0
IOPORT_PIT_CW		equ 77h		; PIT Rg[[h.
IOPORT_PIC_M_IMR	equ 02h		; PIC }X^ IMR
IOPORT_PIC_S_IMR	equ 0ah		; PIC X[u IMR
IOPORT_PIC_M_OCW2	equ 00h		; PIC }X^ OCW2
IOPORT_PIC_S_OCW2	equ 08h		; PIC X[u OCW2
ELSE
IOPORT_PIT_CNT0		equ 40h
IOPORT_PIT_CW		equ 43h
IOPORT_PIC_M_IMR	equ 21h
IOPORT_PIC_S_IMR	equ 0a1h
IOPORT_PIC_M_OCW2	equ 20h
IOPORT_PIC_S_OCW2	equ 0a0h
ENDIF


;----------------------------------------------------------
; R[h`̃f[^̈.
; ̂`ۂɊi[ItZbg͑SĊeR[h̃ZOgƂ.
; ̊֐ retf Ŗ߂Kv.
;--- --- ---
; init_proc (t\ȏԂɂ(yыȃf[^[h))
; : ds=̃ZOgAhX.
;       es=ȃf[^̂̈̃ZOgAhX.
; ߒl: .
; j\: ax, dx, cx, bx, di, ds, es
;	    (call_cont_proc_mall Ă΂Ȃdl)
;--- --- ---
; play_proc (t)
; : ds=̃ZOgAhX.
;       es=ȃf[^̂̈̃ZOgAhX.
; ߒl: .
; j\: SėpWX^, ds, es
;	    (call_cont_proc_mall Ă + O si,bp ی)
;--- --- ---
; mute_proc (S`lɂ, ~yшꎞ~p)
; 풓yщɂĂяôň es ͊܂܂Ȃ.
; : ds=̃ZOgAhX.
; ߒl: .
; j\: ax, dx, cx, bx, di, ds, es (call_cont_proc_mall/_all Ă)
;--- --- ---
; fin_proc (풓̍ŏI)
; : ds=̃ZOgAhX.
; ߒl: .
; j\: ax, dx, cx, bx, di, ds, es (call_cont_proc_mall/_all Ă)
;--- --- ---
; music_query_proc (ȃf[^擾)
; : dl=f[^(QUERY_TYPE 萔Q)
;       ds=̃ZOgAhX.
;       es=ȃf[^̂̈̃ZOgAhX.
; ߒl: ɂ(䊄 0dh ̖ߒlƓdl)
;   [Op (dl  MSB=0)]
;       - QUERY_TYPE_DATA_FLAG   : dl=ȃf[^̃tO.
;   [p (dl  MSB=1)]
;       - ݎ.
; j\: ax, bx
; 䊄Ăяo邱Ƃz.
;--- --- ---
; ̑f[^.
; tsr_group_seg: TSR_GROUP_SEG ̃ZOgAhX.
;--- --- ---
DrvProcTable STRUCT
	init_proc		dw ?
	play_proc		dw ?
	mute_proc		dw ?
	fin_proc		dw ?
	music_query_proc	dw ?
	tsr_group_seg		dw ?
DrvProcTable ENDS

INIT_PROC_OFFSET		equ 0
PLAY_PROC_OFFSET		equ 2
MUTE_PROC_OFFSET		equ 4
FIN_PROC_OFFSET			equ 6
MSUIC_QUERY_PROC_OFFSET		equ 8

; music_query_proc ̈(Op, MSB=0)
MUSIC_QUERY_DATA_FLAG		equ 0
N_MUSIC_QUERY			equ 1
; music_query_proc ̈(p, MSB=1)
; ݎ.

; pf[^̈` TSR_TEXT Őݒ肷p[^̈.
DriverParam STRUCT
	ioport		IOPort {}
	tsr_group_seg	dw ?
	type_		db ?
	padding		db ?
DriverParam ENDS


; ȃf[^̉̏.
SIM_FLAG_INIT_VAL	equ 00h
;SIM_FLAG_CSM_LOADED	equ 01h ; CSM f[^[hς݂ǂ.
SourceInMusic STRUCT
	music_data_seg	dw ? ; ȃf[^̂ZOgAhX.
	cont_seg	dw ? ; Ή鐧R[h seg addr(0ŉ)
	cont_data_seg	dw ? ; 蓖Ăꂽ̐̈ seg addr
	type_		db ? ; ȃf[^̉^Cv.
	cont_type	db ? ; R[h̃^Cv(fobOp)
	sim_flags	db ? ; tO.
	padding		db ?
SourceInMusic ENDS
IF sizeof(SourceInMusic) MOD 2 NE 0
	.err sizeof SourceInMusic is odd.
ENDIF


;----------------------------------------------------------
; WX^݃}N.
; `bvɒlރTu[`̈𐶐 ax ɓ.
SET_WRITE_ARG MACRO addr, val
	mov	ax, ((val) SHL 8) + (addr)
ENDM


;----------------------------------------------------------
; hCo int ̃G[R[h.
TSRERR_NO_ERROR			equ 00h
TSRERR_NOT_IMPLEMENTED		equ 01h
TSRERR_IN_TSR_FLAG		equ 02h
TSRERR_INVALID_DATA		equ 03h
TSRERR_UNCALLABLE_STATUS	equ 04h
TSRERR_INVALID_QUERY_NUM	equ 05h
TSRERR_MUSIC_DATA_NOT_LOADED	equ 06h
TSRERR_INVALID_SRC_INDEX	equ 07h
TSRERR_NOT_ASSIGNED		equ 08h
TSRERR_UNSUPPORTED_VERSION	equ 09h

; ĐXe[^X.
; TSR_FUNC_CALLABLE_TIMING(uint8_t ̔z) ̂Ōő7܂.
PLST_STOP	equ 0
PLST_PLAYING	equ 1
PLST_PAUSE	equ 2
PLST_STOP_REQ	equ 3 ; Ȃ̒~p int ŃNGXgꂽ.
PLST_PAUSE_REQ	equ 4 ; Ȃ̈ꎞ~p int ŃNGXgꂽ.


;----------------------------------------------------------
; t.
OP_NOP			equ 00h
OP_SELECT_VOICE		equ 01h
OP_REST			equ 02h
OP_PLAY_END		equ 03h
OP_SET_VOLUME		equ 04h
OP_REPEAT_START		equ 05h
OP_REPEAT_ESCAPE	equ 06h
OP_REPEAT_END		equ 07h
OP_DIRECT_OUT		equ 08h
OP_TIE			equ 09h
OP_SLUR			equ 0ah
OP_GATE_uQ		equ 0bh
OP_GATE_lq		equ 0ch
OP_DETUNE		equ 0dh
OP_LFO_SET_PARAM	equ 0eh
OP_LFO_SET_WAVE		equ 0fh
OP_LFO_SWITCH		equ 10h
OP_CHANGE_VOLUME	equ 11h
OP_SET_PANPOT		equ 12h
OP_PORTAMENT		equ 13h
OP_LOOP_START_POS	equ 14h
OP_SET_TIMER_B		equ 15h
OP_HW_LFO_SET_PARAM	equ 16h
OP_SET_LFO_OP		equ 17h
OP_FINE_DETUNE		equ 18h
OP_SET_FNUM_BLK		equ 19h

MAX_OP_NUM		equ 19h

OP_PLAY_FNUM_BLK_0	equ 60h
OP_PLAY_FNUM_BLK_1	equ 61h
OP_PLAY_FNUM_BLK_2	equ 62h
OP_PLAY_FNUM_BLK_3	equ 63h

; L[I slur_flag 𗧂Ă鏈ȉ̏OƂĂ.
IF OP_NOP GE OP_TIE
	.err <OP_NOP is equal or greater than OP_TIE.>
ENDIF
IF OP_TIE GE OP_SLUR
	.err <OP_TIE is equal or greater than OP_SLUR.>
ENDIF

;----------------------------------------------------------
; tp^C}l.
; timer_b  220 ̓e|120ɍł߂Ȃl.
; (ۂ̃e| 120.370370... ̏z)
; timer_b ȊȌl͏Lۂ̃e|ɋ߂ȂlI.
TIMER_B_INIT_VAL	equ 220
PIT_5M_INIT_VAL		equ 25521
PIT_8M_INIT_VAL		equ 20736
PIT_PC_AT_INIT_VAL	equ 12391
SB_TIME_CONST_INIT_VAL	equ 14h
SB_XFER_COUNT_INIT_VAL	equ 03h
SB_N_WAIT_INIT_VAL	equ 0ah

;----------------------------------------------------------
; 1p[g LFO ̌.
N_LFO		equ 3
; LFO Xe[^X擾 mask
; rbgtB[ḧӖ.
;   0x01:  LFO L.
;   0x02:  LFO L.
;   0x04: 1ȂL[IȂ(_ł邱Ƃɒ)
;   0x08: L[Iҋ@ǂ.
;   0x10: uԂǂ.
LFO_STB_TUNE	equ 01h
LFO_STB_VOLUME	equ 02h
LFO_STB_NKSYNC	equ 04h
LFO_STB_WAIT	equ 08h
LFO_STB_SYNCED	equ 10h
; LFO ̃Xe[^X擾 mask
;   bit0, bit1 0Ȃ瓮ĂȂ.
LFO_STM_ACTIVE	equ 03h
; LFO ̃Xe[^X.
LFO_ST_OFF	equ 00h
; LFO ̃ZNV.
LFO_SECTION_A	equ 0
LFO_SECTION_B	equ 1
LFO_SECTION_C	equ 2
LFO_SECTION_D	equ 3
; LFO g`.
LFO_WAVE_TRIANGLE	equ 0
LFO_WAVE_ONESHOT	equ 1
; LFO f[^\.
; proc_lfo_set_param  word Pʂ̃Rs[s.
; delay, n_step, speed, step ̕͏ԌŒ(AhXɒu)
; clock_counter, depth_counter ̕l.
LFOStatus STRUCT
	lfo_val dw ?
	delay   db ?
	n_step  db ?
	speed   db ?
	orig_step     db ?
	clock_counter db ?
	depth_counter db ?
	wave_type db ?
	step      db ?
	status    db ?
	section   db ?
	op_mask   db ?
	padding   db ?
LFOStatus ENDS
IF sizeof(LFOStatus) MOD 2 NE 0
	.err sizeof LFOStatus is odd.
ENDIF


;----------------------------------------------------------
; |^gێp\.
; value  diff  [31:16].[15:0] ̌`̌Œ菬_ł.
; 16bit ANZXɂȂ̂ŁA(l)Ə(h)ɕė̈.
Portament STRUCT
	val_l   dw ?
	val_h   dw ?
	diff_l  dw ?
	diff_h  dw ?
	counter db ?
	padding db ?
Portament ENDS
IF sizeof(Portament) MOD 2 NE 0
	.err sizeof Portament is odd.
ENDIF


;----------------------------------------------------------
REPEAT_NEST_MAX		equ 8
N_FNUM_BLK_STORE	equ 4

;CSM_BUFFER_LEN	equ 256

;----------------------------------------------------------
; ZOg`.

;--- tsr.asm
TSR_GROUP GROUP _TSR_DATA, _TSR_TEXT, _TSR_COMMON_TEXT
_TSR_DATA SEGMENT PARA PUBLIC USE16 'TSR_DATA'
_TSR_DATA ENDS
_TSR_TEXT SEGMENT PARA PUBLIC USE16 'TSR_CODE'
_TSR_TEXT ENDS
_TSR_COMMON_TEXT SEGMENT PARA PUBLIC USE16 'TSR_COMMON_CODE'
_TSR_COMMON_TEXT ENDS

;--- tsr_opna.asm
;_TSR_OPNA_TEXT SEGMENT PARA PUBLIC USE16 'TSR_OPNA_CODE'
;_TSR_OPNA_TEXT ENDS

;--- tsr_opl3.asm
;TSR_OPL3_GROUP GROUP _TSR_OPL3_TEXT
_TSR_OPL3_TEXT SEGMENT PARA PUBLIC USE16 'TSR_OPL3_CODE'
_TSR_OPL3_TEXT ENDS

;--- tsr_ppz8.asm
;TSR_PPZ8_GROUP GROUP _TSR_PPZ8_TEXT
_TSR_PPZ8_TEXT SEGMENT PARA PUBLIC USE16 'TSR_PPZ8_CODE'
_TSR_PPZ8_TEXT ENDS

