//--------------------------------------------------------
// N2KD FM Driver version 1.0a (beta 2b)
// main.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include "common.h"
#include "dos_defs.h"

#include "subr.h"
#include "not_tsr.h"
#include "tsr.h"
#include "version.h"

#include <stdint.h>

//--- start.asm ̕ϐ.
extern uint8_t arglen;
extern char __far* argstr;
extern uint8_t cpu_type;

// ꎞI wait ɂ opn_wait p(not_tsr.h Ő錾)
#define FM_WAIT_TMP fm_wait_tmp(opn_wait)

// G[R[h.
#define EC_UNKNOWN_CMD (0)
#define EC_UNKNOWN_OPT (1)
#define EC_INVALID_OPT_ARG (2)
// G[.
static const char* err_msg[] = {
#if TARGET == TARGET_98
	"m̃R}hł",
	"m̃IvVł",
	"IvV̈sł",
#else
	"Unknown command",
	"Unknown option",
	"invalid argument",
#endif
};

// vO샂[h.
#define PM_SHOW_ERROR (0)
#define PM_STAY (1)
#define PM_REMOVE (2)
#define PM_HELP (3)
static uint8_t program_mode = PM_SHOW_ERROR;
static uint8_t error_code = 0; // PM_SHOW_ERROR ̏ꍇɕ\G[̔ԍ.
static uint16_t mbuf_kib_size = 32; // mۂ悤Ƃȃobt@TCY(KiB)
static uint8_t timer_opn_idx = 0; // ^C}S OPN ̉CfbNX.

// 풓ɍŒ󂫂ƂĎcTCY(pOtP)
// ēxvOsł郁󂢂ĂȂƏ풓s\ɂȂ邽.
// 2025/12 ̎_ł̓rhʂ 11KiB xȂ̂ 16KiB Ƃ.
#define MIN_FREE_PARASZ (16 * 1024 / 16)

// BLASTER ϐ̃p[X.
#if TARGET == TARGET_PC
static BlasterParseResult blaster;
#endif

//#define FUNC_VIBISILITY
#define FUNC_VIBISILITY static

FUNC_VIBISILITY uint8_t stay_tsr(); // ߒl0ŏ풓\.
FUNC_VIBISILITY void remove_tsr();
FUNC_VIBISILITY void print_help();
FUNC_VIBISILITY void print_error();
FUNC_VIBISILITY void print_blaster(uint8_t newline);

FUNC_VIBISILITY int16_t detect_sources();
FUNC_VIBISILITY void stop_opn_timer();
FUNC_VIBISILITY void cleanup_sb();
FUNC_VIBISILITY void set_vectors(uint8_t timer_irq);
FUNC_VIBISILITY void restore_vectors(uint8_t timer_irq);
FUNC_VIBISILITY void setup_interrupt();
FUNC_VIBISILITY void restore_interrupt();
FUNC_VIBISILITY void print_stayed_msg();
FUNC_VIBISILITY void print_dbg_stayed_msg();
FUNC_VIBISILITY void add_source(uint16_t addr0, uint16_t data0, uint16_t addr1, uint16_t data1, uint8_t type);
FUNC_VIBISILITY uint16_t check_ioport(const IOPort __far* p0, const IOPort __far* p1);
FUNC_VIBISILITY void get_interrupt_param_opn();
FUNC_VIBISILITY void get_interrupt_param_sb();

// detect_sources() ̖ߒl.
#define DETECT_OK		0 // (^C})
#define DETECT_NOT_FOUND	1 // Ȃ.
#define DETECT_NO_TIMER		2 // ͂邪^C}(OPN(A)).

// PCI foCX֌W.
#define PCI_VENDOR_ID_YAMAHA 0x1073
#define PCI_DEVICE_ID_YMF724 0x000d
#define PCI_DEVICE_ID_YMF744 0x0010
#define PCI_DEVICE_ID_YMF754 0x0012
#define N_PCI_DEVICE_ID (3)
static const uint16_t PCI_DEVICE_IDS[N_PCI_DEVICE_ID] = {
	PCI_DEVICE_ID_YMF724, PCI_DEVICE_ID_YMF744, PCI_DEVICE_ID_YMF754
};
// YMF7x4  SB16 ̃|[g(220h ) AdLib ̃|[g(388h )L̎ɗFȂ.
static Source ymf7x4_ignore_sources[N_MAX_SOURCES];
static uint8_t ymf7x4_n_ignore = 0;

uint8_t n2kd_main()
{
	putstr(
#if TARGET == TARGET_98
"N2KD FM Driver for PC-98x1 "VERSION_STR"\r\n"
#else
"N2KD FM Driver for PC/AT "VERSION_STR"\r\n"
#endif
	);

	// ̃p[Xƃp[Xʂ̉.
	ArgParseResult args = parse_args(argstr, arglen);
	if(args.status != PARSE_ERR_NO_ERROR)
	{
		switch(args.status)
		{
			case PARSE_ERR_UNKNOWN_CMD: { error_code = EC_UNKNOWN_CMD; break; }
			case PARSE_ERR_UNKNOWN_OPT: { error_code = EC_UNKNOWN_OPT; break; }
			case PARSE_ERR_INVALID_OPT_ARG: { error_code = EC_INVALID_OPT_ARG; break; }
		}
		program_mode = PM_SHOW_ERROR;
	}
	else
	{
		switch(args.command)
		{
			case 's':
			{
				program_mode = PM_STAY;
				if(0 <= args.music_mem_sz) mbuf_kib_size = (uint16_t)args.music_mem_sz;
				break;
			}
			case 'r': { program_mode = PM_REMOVE; break; }
			case '?': { program_mode = PM_HELP; break; }
			default: { program_mode = PM_SHOW_ERROR; break; }
		}
	}

	switch(program_mode)
	{
		case PM_STAY:
			if (stay_tsr())
			{
				// 풓ŏIĂяo.
				// 풓ɐꍇ́A̐ŏ풓IĕԂĂȂ.
				// 肪풓Ɏsꍇ͖߂Ă.
				final_setup_and_exit();
			}
			break;
		case PM_REMOVE: { remove_tsr(); break; }
		case PM_HELP: { print_help(); break; }
		default: { print_error(); }
	}

	return 0;
}

uint8_t stay_tsr()
{
	if(check_stayed())
	{
#if TARGET == TARGET_98
		putstr("ɏ풓Ă܂\r\n");
#else
		putstr("TSR is already stayed.\r\n");
#endif
		return 0;
	}

	calc_fm_wait(); // ANZX wait vZ(oŎg).
	const int16_t detect_result = detect_sources();
	if(detect_result == DETECT_NOT_FOUND)
	{
#if TARGET == TARGET_98
		putstr("܂\r\n");
#else
		putstr("Supported sound device not found.\r\n");
#endif
		return 0;
	}
#if defined(_DEBUG)
	if(detect_result == DETECT_NO_TIMER)
	{
		putstr("fobOŏ풓ɂ OPN(A) ̃^C}Kvł\r\n");
		return 0;
	}
#endif

	tsr_psp_seg = get_psp_seg(); // PSP ̃ZOgۑ.

	//--- ֘Ȁ.
	init_parasz_tables();
	remove_unused_code(); // svȃhCoR[h.
	calc_data_seg_pos();

	//--- ehCo.
#if defined(_DEBUG)
	init_rs232c();	// fobOp RS-232C .
#endif
	init_drv_data();

	//--- 풓ʌvZ֘Ȁ.
	// ȃobt@TCYpOtPʂɕϊĕۑ.
	mbuf_parasz = mbuf_kib_size * (1024 / 16); // KiB -> para
	const uint16_t max_parasz = calc_max_para_size(); // cő.
	// cTCY(PSP ` ȃobt@)
	remain_parasz = mbuf_seg - tsr_psp_seg + mbuf_parasz;
	// 2ڂ̏ mbuf_parasz 傫ɋN蓾 wrap-around ̃`FbN.
	if((max_parasz < MIN_FREE_PARASZ)
		|| (remain_parasz < mbuf_parasz)
		|| (max_parasz < remain_parasz))
	{
#if TARGET == TARGET_98
		putstr("󂫃܂\r\n");
#else
		putstr("Not enough free memory.\r\n");
#endif
		return 0;
	}

	//--- BLASTER ϐp[X.
	//  PC-98 ł BLASTER ϐT|[gĂȂ.
#if TARGET == TARGET_PC
	blaster = parse_blaster_envvar((char __far*)(get_env_area_seg() :> 0));
	if(blaster.status == BLASTER_ST_PARSE_FAILED)
	{
		// p[XsꍇA`̏ꍇƓƂ.
		putstr("Failed to parse BLASTER env var, ignored.\r\n");
	}
	else if(blaster.status == BLASTER_ST_PARSE_OK)
	{
		// 풓̈0IWɕϊlۑ.
		if(blaster.irq == 2) { sb_irq_idx = 0; }
		else if(blaster.irq == 5) { sb_irq_idx = 1; }
		else if(blaster.irq == 7) { sb_irq_idx = 2; }
		else { sb_irq_idx = 3; } // irq == 10
		if(blaster.dma <= 1) { sb_dma_idx = blaster.dma; }
		else { sb_dma_idx = 2; } // dma == 3

		// SB  DSP ւ̃ANZXƃo[WmF.
		const uint16_t dsp_ver = check_sb_dsp(blaster.addr);
		const uint8_t dsp_major_ver = dsp_ver & 0xff;
		if(3 <= dsp_major_ver && dsp_major_ver <= 4)
		{
			// ɗ SB g鈵.
			print_blaster(0);
			putstr(", DSP ver: ");
			print_u8_dec(dsp_major_ver);
			putchar('.');
			print_u8_dec(dsp_ver >> 8);
			putstr("\r\n");

			if(!setup_sb_dma(blaster.dma))
			{
				putstr("Failed to init DMA buffer.\r\n");
				return 0;
			}

			sb_base_addr = blaster.addr;
			sb_write_port = blaster.addr + 0x0c;
			sb_dma_ack_port = blaster.addr + 0x0e;
		}
		else
		{
			// s BLASTER ϐ`̏ꍇƓƂ(ʂȂ).
			blaster.status = BLASTER_ST_NOT_DEFINED;
			print_blaster(1); // ꉞ BLASTER ϐ̃p[Xʂ\.
			putstr("Failed to access DSP or unsupported DSP version\r\n");
		}
	}
#endif

	//--- 풓.
#if TARGET == TARGET_98
	if(detect_result == DETECT_OK)
	{
		stayed_timer_type = TIMER_TYPE_OPN;
		stop_opn_timer();
	}
	else
	{
		// sysclk_type  calc_fm_wait() Őݒ肳.
		if(sysclk_type == SYSCLK_8M) { stayed_timer_type = TIMER_TYPE_PIT_8M; }
		else { stayed_timer_type = TIMER_TYPE_PIT_5M; }
	}
#else
	if(blaster.status == BLASTER_ST_PARSE_OK) { stayed_timer_type = TIMER_TYPE_SB; }
	else { stayed_timer_type = TIMER_TYPE_PIT; }
#endif
	setup_interrupt();

	//--- ϐ̈̊J.
	free_env_area();

	print_stayed_msg();
#if defined(_DEBUG)
	print_dbg_stayed_msg();
#endif
	return 1;
}

void remove_tsr()
{
	// TODO: fobOp RS-232C n.
	// fobOpȂ̂œɌnȂ.

	if(!check_stayed())
	{
#if TARGET == TARGET_98
		putstr("풓Ă܂\r\n");
#else
		putstr("TSR is not stayed.\r\n");
#endif
		return;
	}

	erase_stay_marker();
	fetch_tsr_info(); // 풓̈悩ɕKvȏĂ.
#if TARGET == TARGET_98
	if(stayed_timer_type == TIMER_TYPE_OPN) stop_opn_timer();
#else
	if(stayed_timer_type == TIMER_TYPE_SB) cleanup_sb();
#endif
	mute_sources_not_tsr(); // SL[It.
	call_each_remove_proc();
#if TARGET == TARGET_PC
	out8(0x43, 0x36); // PC/AT ̏ꍇAPIT ̃JEgl𕁒i̒lɖ߂.
	io_wait(2);
	out8(0x40, 0xff);
	io_wait(2);
	out8(0x40, 0xff);
#endif
	restore_interrupt();
	free_segment(tsr_psp_seg);

#if TARGET == TARGET_98
	putstr("풓܂\r\n");
#else
	putstr("Released.\r\n");
#endif
}

void print_help()
{
#if TARGET == TARGET_98
	putstr(
"Usage: N2KD.EXE [comamnd] (options...)\r\n"
"  commands: s: 풓, r: 풓, ?: ̃wv\\r\n"
"  options:\r\n"
"    /m: ȃf[^obt@TCY(KiBP, default=32)\r\n"
	);
#else
	putstr(
"Usage: N2KDPCAT.EXE [comamnd] (options...)\r\n"
"  commands: s: stay TSR, r: release TSR, ?: print this help\r\n"
"  options:\r\n"
"    /m: music data buffer size(KiB, default=32)\r\n"
	);
#endif
}

void print_error()
{
#if TARGET == TARGET_98
	putstr("G[: ");
	putstr(err_msg[error_code]);
	putstr("\r\nun2kd.exe ?vŃwv\\r\n");
#else
	putstr("Error: ");
	putstr(err_msg[error_code]);
	putstr("\r\nTo show help, run \"n2kd.exe ?\"\r\n");
#endif
}

#if TARGET == TARGET_PC
void print_blaster(uint8_t newline)
{
	putstr("BLASTER env var: (addr: ");
		print_u16(blaster.addr);
		putstr(", IRQ: ");
		print_u8_dec(blaster.irq);
		putstr(", DMA: ");
		print_u8_dec(blaster.dma);
		putstr(")");
		if(newline) putstr("\r\n");
}
#endif

//--- ̒T.
// ߒl: 0=, 1=, 2=͂邪^C}(OPN(A)).
int16_t detect_sources()
{
	uint8_t timer_opn_found = 0;
	uint16_t port;

#if TARGET == TARGET_98
	//--- OPN T( OPNA Ƃ̋ʂĂȂ, PC-98x1 ̂ݎs)
	// 0x088 ` 0x388 ͈̔͂`FbN.
	// WX^ 0x00`0x0f ̉ɓǂݏ\Ȃ甭.
	// ł 0x0c(ssg coarse tune)  0xc3 .
	// ŏɌ OPN ^C}Ɏg.
#define TEST_REG (0x0c)
#define TEST_VAL (0xc3)
	static const uint8_t int_irq_table[] = { 0x0b, 0x15, 0x12, 0x14 };
	port = 0x088;
	while(port <= 0x388)
	{
		out8(port, TEST_REG);
		FM_WAIT_TMP;
		out8(port + 2, TEST_VAL); // *8ah
		FM_WAIT_TMP;
		if(in8(port + 2) == TEST_VAL)
		{
			// OPN(A) ΉR[hȂ̂Ŕωꗗɂ͒ǉȂ.
			//sources[n].ioport.addr0 = port;
			//sources[n].ioport.data0 = port + 2;
			//sources[n].type_ = SRC_TYPE_OPN; //  OPN Œ.

			// ɊXe[^X`FbN.
			out8(port, 0x0e);
			FM_WAIT_TMP;
			const uint8_t st = in8(port + 2) >> 6;
			// INT5(st == 11b)Ɋ OPN(A) ꍇ㏑o^.
			if((st == 0x03) || !timer_opn_found)
			{
				opn_addr = port;
				opn_data = port + 2; // data
				opn_int_status = st;
				opn_irq = int_irq_table[opn_int_status];
				timer_opn_found = 1;
				//timer_opn_idx = n_sources;
			}
			//if(++n == N_MAX_SOURCES) goto detect_end;
		}
		port += 0x100;
	}
#undef TEST_VAL
#undef TEST_REG
#endif

	//--- OPL3 T
	// YMF7x4  OPL3 T(CPU 386ȍ~ v86 [h PCI BIOS g鎞̂).
	if(!(3 <= cpu_type && cpu_type <= 4)) goto skip_ymf7x4;
	if(!check_pci_bios()) goto skip_ymf7x4;
	for(uint8_t i = 0; i < N_PCI_DEVICE_ID; ++i)
	{
		const uint16_t is_ymf724 = (PCI_DEVICE_IDS[i] == PCI_DEVICE_ID_YMF724);
		uint16_t pos;
		for(uint16_t idx = 0; ; ++idx)
		{
			uint16_t ret = find_pci_device(PCI_VENDOR_ID_YAMAHA, PCI_DEVICE_IDS[i], idx, &pos);
			if(!ret) break;

			const uint16_t setting = check_ymf_setting(pos);
			if(!setting) continue;

			uint16_t port_opl3 = 0, port_sb16 = 0;
			if(setting & 2) port_opl3 = get_ymf_port(pos, is_ymf724, 1);
			if(setting & 1) port_sb16 = get_ymf_port(pos, is_ymf724, 0);
			if(port_opl3) {
				add_source(port_opl3, port_opl3 + 1, port_opl3 + 2, port_opl3 + 3, SRC_TYPE_OPL3);
				if(port_sb16) {
					//  YMF7x4  SB16 |[gd񋓂Ȃ悤ɋL^.
					ymf7x4_ignore_sources[ymf7x4_n_ignore].ioport.addr0 = port_sb16;
					ymf7x4_ignore_sources[ymf7x4_n_ignore].ioport.data0 = port_sb16 + 1;
					ymf7x4_ignore_sources[ymf7x4_n_ignore].ioport.addr1 = port_sb16 + 2;
					ymf7x4_ignore_sources[ymf7x4_n_ignore].ioport.data1 = port_sb16 + 3;
					ymf7x4_n_ignore += 1;
				}
			} else {
				if(port_sb16)
					add_source(port_sb16, port_sb16 + 1, port_sb16 + 2, port_sb16 + 3, SRC_TYPE_OPL3);
			}
		}
	}
skip_ymf7x4:
	;
	uint8_t port_val;
#if TARGET == TARGET_98
	// PC-98x1 ł 20d*h ̒T (SB16/98)
	uint8_t sb16_found_flag = 0; // 80d*h ̒T΂p SB16/98 tO.
	for(uint8_t i = 0x02; i <= 0x0e; i += 2)
	{
		port = 0x20d0 + i; // 20d2h, 20d4h, ..., 20deh
		port_val = in8(port);
		if(port_val != 0xff)
		{
			add_source(port, port + 0x100, port + 0x200, port + 0x300, SRC_TYPE_OPL3);
			sb16_found_flag |= (1 << (i / 2)); // ((4bit)/2)bit ڂ1ɂ.
		}
	}
	// PC-98x1 ł *0d*h ̒T (T64S)
	for(uint8_t y = 0; y < 3; ++y)
	{
		uint16_t tmp_p = 0x1000 * (y + 2) * 2 + 0xd0; // 40d0h, 60d0h, 80d0h
		for(uint8_t x = 0; x < 4; ++x)
		{
			// 20d*h  SB16/98  80d*h  MPU-401 ŎgĂ̂ŒTȂ.
			if((tmp_p == 0x80d0) && (sb16_found_flag & (1 << x)))
				continue;
			port = tmp_p + (x * 2); // *0d0h, *0d2h, *0d4h, *0d6h
			port_val = in8(port);
			if(port_val != 0xff)
				add_source(port, port + 0x100, port + 0x200, port + 0x300, SRC_TYPE_OPL3);
		}
	}
	// PC-98x1 ł 1488h ̃`FbN (PC-9801-118)
	/* TODO: @ł̓mFłĂȂ.
	port = 0x1488;
	port_val = in8(port);
	if(port_val != 0xff)
		add_source(port, port + 1, port + 2, port + 3, SRC_TYPE_OPL3);
	*/
#else
	// PC/AT ł̒T.
	// 220h, 240h, 260h, 280h (SoundBlaster)
	// 220h/240h ̉ 388h ɂ悤Ȃ̂ 388h ͒TȂ.
	port = 0x220;
	for (uint8_t i = 0; i < 4; ++i)
	{
		port_val = in8(port);
		if(port_val != 0xff)
			add_source(port, port + 1, port + 2, port + 3, SRC_TYPE_OPL3);
		port += 0x20;
	}
#endif

	if(n_sources == 0) return DETECT_NOT_FOUND;
	if(!timer_opn_found) return DETECT_NO_TIMER;
	return DETECT_OK;
}

void stop_opn_timer()
{
	const uint16_t* p = &opn_addr;
	const uint16_t pa = *(p + 0); // OPN addr port
	const uint16_t pd = *(p + 1); // OPN data port
	out8(pa, 0x27);
	FM_WAIT_TMP;
	out8(pd, 0x30); // 0b00110000 (^C}~)
}

void cleanup_sb()
{
	mask_sb_dma((sb_dma_idx < 2) ? sb_dma_idx : 3);
	while(in8(sb_base_addr + 0x0c) & 0x80);
	out8(sb_base_addr + 0x0c, 0xda); // stop auto-init DMA
}

void set_vectors(uint8_t timer_irq)
{
	// __far ̑ SEG_TSR_GROUP ƐAhXȂ͗l.
	// extern void SEG_TSR_GROUP tsr_top(); // NG
	extern void __far tsr_top();
	extern void __far tsr_fm_main();

	void(__far* func)();
	// hCopxN^.
	get_vector_f(&func, TSR_VECTOR);
	tsr_orig_vec = func;
	set_vector_f(tsr_top, TSR_VECTOR);
	// OPN(A)荞݃xN^.
	get_vector_f(&func, timer_irq);
	fm_orig_vec = func;
	set_vector_f(tsr_fm_main, timer_irq);
}

void restore_vectors(uint8_t timer_irq)
{
	set_vector_f(tsr_orig_vec, TSR_VECTOR);
	set_vector_f(fm_orig_vec, timer_irq);
}

// 8259A ̊}XNƊxN^̐ݒɕKvȊe̒l߂.
#if TARGET == TARGET_98
void get_interrupt_param_opn(uint16_t* io_port, uint8_t* imr_bit, uint8_t* timer_irq)
{
	static const uint8_t is_slave_pic[] = { 0, 1, 1, 1 };
	static const uint8_t imr_bit_table[] = { 0x08, 0x20, 0x04, 0x10 };

	*io_port = is_slave_pic[opn_int_status] ? IOPORT_PIC_S_IMR : IOPORT_PIC_M_IMR;
	*imr_bit = imr_bit_table[opn_int_status];
	*timer_irq = opn_irq;
}
#else
void get_interrupt_param_sb(uint16_t* io_port, uint8_t* imr_bit, uint8_t* timer_irq)
{
	// IRQ2  IRQ9 ɐڑĂ̂Ƃ.
	static const uint8_t is_slave_pic[] = {1, 0, 0, 1};
	static const uint8_t imr_bit_table[] = { 0x02, 0x20, 0x80, 0x40 };
	static const uint8_t irq_vec_table[] = { 0x71, 0x0d, 0x0f, 0x72 };

	*io_port = is_slave_pic[sb_irq_idx] ? IOPORT_PIC_S_IMR : IOPORT_PIC_M_IMR;
	*imr_bit = imr_bit_table[sb_irq_idx];
	*timer_irq = irq_vec_table[sb_irq_idx];
}
#endif

// 8259A ̊}XNƊxN^̐ݒ.
// stayed_timer_type Oɐݒ肳ĂKv.
void setup_interrupt()
{
	// ȉ io_port, imr_bit, timer_irq ̏l PIT 풓̒l.
	uint16_t io_port = IOPORT_PIC_M_IMR;
	uint8_t imr_bit = 0x01;
	uint8_t timer_irq = 0x08;
#if TARGET == TARGET_98
	if(stayed_timer_type == TIMER_TYPE_OPN) // OPN ɏ풓Ȃϐ.
		get_interrupt_param_opn(&io_port, &imr_bit, &timer_irq);
#else
	if(stayed_timer_type == TIMER_TYPE_SB)
		get_interrupt_param_sb(&io_port, &imr_bit, &timer_irq);
#endif

	// ݂̊荞݃}XN擾ĈꎞIɃ}XN.
	clear_interrupt_flag();
	const uint8_t orig_imr = in8(io_port);
	io_wait(2);
	out8(io_port, orig_imr | imr_bit);
	io_wait(2);
	set_interrupt_flag();

	set_vectors(timer_irq);

	// 荞݃}XN.
	clear_interrupt_flag();
	out8(io_port, orig_imr & (~imr_bit));
	io_wait(2);
	set_interrupt_flag();

	orig_imr_masked = ((orig_imr & imr_bit) != 0);
}

// 8259A ̊}XNƊxN^풓ȌԂɖ߂.
void restore_interrupt()
{
	uint16_t io_port = IOPORT_PIC_M_IMR;
	uint8_t imr_bit = 0x01;
	uint8_t timer_irq = 0x08;
#if TARGET == TARGET_98
	if(stayed_timer_type == TIMER_TYPE_OPN)
		get_interrupt_param_opn(&io_port, &imr_bit, &timer_irq);
#else
	if(stayed_timer_type == TIMER_TYPE_SB)
		get_interrupt_param_sb(&io_port, &imr_bit, &timer_irq);
#endif

	// ݂̊荞݃}XN擾Ē}XN.
	clear_interrupt_flag();
	const uint8_t curr_imr = in8(io_port);
	io_wait(2);
	out8(io_port, curr_imr | imr_bit);
	io_wait(2);
	set_interrupt_flag();

	restore_vectors(timer_irq);

	// X}XNĂȂꍇ̓}XN.
	if(orig_imr_masked) return;
	clear_interrupt_flag();
	out8(io_port, curr_imr & (~imr_bit));
	io_wait(2);
	set_interrupt_flag();
}

void add_source(uint16_t addr0, uint16_t data0, uint16_t addr1, uint16_t data1, uint8_t type)
{
	IOPort p;
	p.addr0 = addr0;
	p.data0 = data0;
	p.addr1 = addr1;
	p.data1 = data1;

	if(n_sources < N_MAX_SOURCES)
	{
		// IO |[gߋo^ꂽ̂ƏdĂo^Ȃ.
		for(uint8_t i = 0; i < n_sources; ++i)
		{
			if(sources[i].ioport.addr0 == 0) continue;
			if(sources[i].ioport.addr1 == 0) continue;
			const IOPort SEG_TSR_GROUP* src_p = &(sources[i].ioport);
			if(!check_ioport(&p, src_p)) return;
		}
		for(uint8_t i = 0; i < ymf7x4_n_ignore; ++i)
		{
			if(!check_ioport(&p, &(ymf7x4_ignore_sources[i].ioport))) return;
		}

		sources[n_sources].ioport = p;
		sources[n_sources].type_ = type;
		n_sources += 1;
	}
}

// IOPort 2ׂă|[gɏdΔ0A0Ԃ.
// TSR_GROUP ɂ IOPort łrł悤 far |C^Ŏ󂯂.
uint16_t check_ioport(const IOPort __far* p0, const IOPort __far* p1)
{
	const uint16_t p0a0 = p0->addr0;
	const uint16_t p0d0 = p0->data0;
	const uint16_t p0a1 = p0->addr1;
	const uint16_t p0d1 = p0->data1;
	const uint16_t p1a0 = p1->addr0;
	const uint16_t p1d0 = p1->data0;
	const uint16_t p1a1 = p1->addr1;
	const uint16_t p1d1 = p1->data1;

	if(p0a0 == p1a0 || p0a0 == p1d0 || p0a0 == p1a1 || p0a0 == p1d1) return 0;
	if(p0d0 == p1a0 || p0d0 == p1d0 || p0d0 == p1a1 || p0d0 == p1d1) return 0;
	if(p0a1 == p1a0 || p0a1 == p1d0 || p0a1 == p1a1 || p0a1 == p1d1) return 0;
	if(p0d1 == p1a0 || p0d1 == p1d0 || p0d1 == p1a1 || p0d1 == p1d1) return 0;

	return 1;
}

void print_stayed_msg()
{
	putstr("Mem: ");
	print_u16(tsr_psp_seg);
	putchar('-');
	print_u16(mbuf_seg + mbuf_parasz);
	putstr(" (");
	print_u16(remain_parasz);
	putstr(" paras), music_buf: ");
	print_u16(mbuf_parasz);
	putstr(" paras\r\n");

	putstr("Sound:\r\n");
	for(uint8_t i = 0; i < n_sources; ++i)
	{
		static const char* source_names[] = {
			"OPNA", "OPN2", "OPN", "OPL2", "OPL3", "OPL4", "Y8950",
			"PPZ8", "TMS3631", "ACPCM(256K)", "ADPCM(32K)"
		};

		putchar(' '); putchar(' ');
		print_u8(i);
		putstr(": ");
		putstr(source_names[(sources + i)->type_]);
		putstr(", port: ");
		print_u16((sources + i)->ioport.addr0);
		putstr(", wait: ");
		print_u16((sources + i)->ioport.wait_);
		putstr("\r\n");
	}

#if TARGET == TARGET_98
	if(stayed_timer_type == TIMER_TYPE_OPN)
	{
		static const uint8_t int_name_table[] = { 0x00, 0x06, 0x41, 0x05 };
		putstr("INT: ");
		print_u8_noprefix(int_name_table[opn_int_status]);
		putstr("(OPN(A) timer_b), port: ");
		print_u16(opn_addr);
		putstr(", wait: ");
		print_u16(opn_wait);
		putstr("\r\n");
	}
	else
	{
		putstr("IRQ: 08h (8253 timer), sysclk: ");
		if(stayed_timer_type == TIMER_TYPE_PIT_5M) putstr("5MHz\r\n");
		else putstr("8MHz\r\n");
	}
#else
	if(stayed_timer_type == TIMER_TYPE_PIT) putstr("IRQ: 08h (8253 timer)\r\n");
	else putstr("IRQ: Sound Blaster\r\n");
#endif

#if TARGET == TARGET_98
	putstr("풓܂\r\n");
#else
	putstr("Stayed.\r\n");
#endif
}

#if defined(_DEBUG)
void print_dbg_stayed_msg()
{
	putstr("--- cont_seg_tbl: init, play, mute\r\n");
	for(uint8_t i = 0; i < 5; ++i)
	{
		const uint16_t seg = cont_seg_tbl[i];
		print_u16(seg);
		if(seg == 0) putstr(": N/A\r\n");
		else
		{
			const uint16_t __far* tbl = (uint16_t __far*)make_far_ptr(seg, 0);
			putstr(": ");
			print_u16(tbl[0]);
			putstr(", ");
			print_u16(tbl[1]);
			putstr(", ");
			print_u16(tbl[2]);
			putstr("\r\n");
		}
	}
	putstr("\r\n--- idx: type_, cont_seg, cont_data_seg | addr0, wait_, tsr_grp_seg\r\n");
	for(uint8_t i = 0; i < n_sources; ++i)
	{
		print_u8(i);
		putstr(": ");
		print_u8(sources[i].type_);
		putstr(", ");
		print_u16(sources[i].cont_seg);
		putstr(", ");
		const uint16_t cont_data_seg = sources[i].cont_data_seg;
		print_u16(cont_data_seg);
		putstr(" | ");
		// DriverParam
		const DriverParam __far* p = (DriverParam __far*)make_far_ptr(cont_data_seg, 0);
		print_u16(p->ioport.addr0);
		putstr(", ");
		print_u16(p->ioport.wait_);
		putstr(", ");
		print_u16(p->tsr_group_seg);
		putstr("\r\n");
	}
}
#endif
