;--------------------------------------------------------
; N2KD FM Driver version 1.0a (beta 2b)
; not_tsr.asm
; Copyright (C) 2021-2026 Y. Shiokami
; Released under the 3-clause BSD License.
;--------------------------------------------------------

.186
.model small

include common.inc

;--- not_tsr.c
EXTERN _calced_waits:word
EXTERN check_cont_:near
;---

;--- tsr.asm
EXTERN _sources:byte
EXTERN _opn_wait:word, _cont_seg_tbl:word, _sysclk_type:byte, _n_sources:byte
EXTERN tsr_data_head:byte, tsr_remove_data_tail:byte
EXTERN _mbuf_seg:word
EXTERN call_cont_proc_all_far:far

;--- tsr_opna.asm
;EXTERN tsr_opna_tail:byte
;_TSR_OPNA_TEXT SEGMENT PARA PUBLIC USE16 'TSR_OPNA_CODE'
;_TSR_OPNA_TEXT ENDS
;--- tsr_opl3.asm
EXTERN tsr_opl3_tail:byte
EXTERN data_opl3_tail:byte, data_opl2_tail:byte
;--- tsr_ppz8.asm
EXTERN tsr_ppz8_tail:byte
EXTERN data_ppz8_tail:byte
;--- --- ---


DGROUP GROUP _DATA, CONST2

_DATA SEGMENT PUBLIC USE16 'DATA'
	EVEN
;		db 4 dup('=')
; R[h̃TCỸe[u(g̕яƃN͓łƂ)
; TCY̒l͎sɃpOtPʂɕϊ.
code_parasz_tbl	dw 0, ; OPNA
		   offset _TSR_OPL3_TEXT:tsr_opl3_tail, ; OPL3
		   offset _TSR_PPZ8_TEXT:tsr_ppz8_tail, ; PPZ8
		   0, ; ADPCM
		   0  ; TMS3631
;		db 4 dup('=')
; vTCY(para)
removed_parasz	dw 0
; e̐pobt@̃TCY(sɃpOtPʂɕϊ)
data_parasz_tbl	dw 0, ; OPNA
		   0, ; OPN2
		   0, ; OPN
		   offset data_opl2_tail, ; OPL2 (test)
		   offset data_opl3_tail, ; OPL3
		   0, ; OPL4
		   0, ; Y8950
		   offset data_ppz8_tail, ; PPZ8
		   0, ; TMS3631
		   0, ; ADPCM_256K
		   0  ; ADPCM_32K
; EFCgvZ.
remesured	db 0 ; EFCgvɍČv?
_DATA ENDS

CONST2 SEGMENT PUBLIC USE16 'DATA'
	EVEN
; EFCgvZp폜.
; 폜(OPNA, OPN2, OPN, OPL2, OPL3, OPL4, ...ȉ)
;  OPN(A)͈ԎԂ̂EFCgŌvZĂg.
DIVIDEND_5M	dw 0, 0, 13106, 0, 1412, 0, 0, 0, 0, 0, 0
DIVIDEND_8M 	dw 0, 0, 10649, 0, 1149, 0, 0, 0, 0, 0, 0
DIVIDEND_PC_AT	dw 0, 0, 6363, 0, 686, 0, 0, 0, 0, 0, 0
; YMF724 ̃KV[I[fBI IO |[g̃e[u.
TBL_YMF724_FMIO dw 388h, 398h, 3a0h, 3a8h
TBL_YMF724_SBIO dw 220h, 240h, 260h, 280h
CONST2 ENDS


_TEXT SEGMENT PUBLIC USE16 'CODE'
	ASSUME	cs:_TEXT, ds:DGROUP, ss:DGROUP

;--- int16_t check_stayed()
; 풓`FbN.
; : .
; ߒl: ax=(0=풓ĂȂ, 0=풓ς)
check_stayed_ PROC PUBLIC
	push	bx
	push	es
	mov	ax, 3500h + TSR_VECTOR
	int	21h ; 荞݃xN^擾 -> es:bx
	cmp	word ptr es:[bx + 3], '2N'
	jnz	not_stayed
	cmp	word ptr es:[bx + 5], 'DK'
	jnz	not_stayed
	cmp	byte ptr es:[bx + 7], 0
	jnz	not_stayed
	mov	ax, 1
	jmp	@F
not_stayed:
	xor	ax, ax
@@:	pop	es
	pop	bx
	ret
check_stayed_ ENDP


;---  void fm_wait_tmp(uint16_t wait_cnt)
; fmɃANZX()\Ȏԑ҂.
; : ax=EFCgl.
; ߒl: .
; pr:
; - IO |[g̒Tŉǂɂ邩Ȃ(busy ǂ߂Ȃ).
; - ƏIȂǂ̏xȂɕKvłȂ.
fm_wait_tmp_ PROC PUBLIC
	push	cx
	mov	cx, ax
	loop	$
	pop	cx
	ret
fm_wait_tmp_ ENDP


;--- void calc_fm_wait()
; ANZX wait vZ.
; : .
; ߒl: .
calc_fm_wait_ PROC PUBLIC
	pusha
	push	es
	; cx=0ffffh Ƃ loop ߂Ōo߂鎞Ԃv.
	cli
	; ^C}ݒ.
	mov	al, 00110110b ; JE^0, 16bitANZX, `g, 2iJEg.
	out	IOPORT_PIT_CW, al
	IO_WAIT	2
	mov	al, 0ffh
	out	IOPORT_PIT_CNT0, al
	IO_WAIT	2
	xor	al, al
	out	IOPORT_PIT_CNT0, al
	; ^C}xN^ݒ.
	mov	ax, 3500h + 08h	; ԍ 08h  PC-98x1  PC/AT œ.
	int	21h		; get current vector -> es:bx
	push	es		; save segment
	push	bx		; save offset
	mov	di, ds		; save ds
	mov	dx, cs
	mov	ds, dx
	mov	dx, offset calc_wait_vector
	mov	ah, 25h
	int	21h		; set interrupt vector <- ds:dx
	mov	ds, di		; restore ds
	; }XNݒ(IRQ0 ȊOS}XN, }XN PC-98x1  PC/AT ŋ)
	in	al, IOPORT_PIC_M_IMR
	mov	ah, al
	in	al, IOPORT_PIC_S_IMR	; (ah, al) = (imr_master, imr_slave)
	mov	si, ax			; save orig mask
	mov	al, 0feh
	out	IOPORT_PIC_M_IMR, al
	mov	al, 0ffh
	out	IOPORT_PIC_S_IMR, al
	; v (Čv̂ bp=0 ɂ͂ȂȂƉ)
	xor	bp, bp
	mov	al, 20h		; eoi
	sti
	mov	cx, 0ffffh
	loop	$
	cli
	; bp ꍇ̓EFCgvZʂ̌덷傫Ȃ̂ōČv.
.if(bp < 32)
	mov	[remesured], 1
	mov	bp, 1		; 0Zh~.
	mov	al, 20h		; eoi
	sti
@LOOP_IDX = 0
WHILE @LOOP_IDX LT 8
	mov	cx, 0ffffh
	loop	$
	@LOOP_IDX = @LOOP_IDX + 1
ENDM
	cli
.endif
	; ^C}ݒ̌n.
IF TARGET EQ TARGET_98
	; [h0ɂ(JE^ɂ͎芸0Ă)
	mov	al, 30h
	out	IOPORT_PIT_CW, al
	IO_WAIT	2
	xor	al, al
	out	IOPORT_PIT_CNT0, al
	IO_WAIT	2
	out	IOPORT_PIT_CNT0, al
ELSE
	; ȉԂɖ߂.
	mov	al, 00110110b
	out	IOPORT_PIT_CW, al
	IO_WAIT	2
	mov	al, 0ffh
	out	IOPORT_PIT_CNT0, al
	IO_WAIT	2
	out	IOPORT_PIT_CNT0, al
ENDIF
	; ^C}xN^A.
	pop	dx	; restore offset
	pop	ds	; restore segment
	mov	ax, 2500h + 08h
	int	21h
	mov	ds, di	; restore ds
	; }XNA.
	mov	dx, si
	mov	al, dh
	out	IOPORT_PIC_M_IMR, al
	mov	al, dl
	out	IOPORT_PIC_S_IMR, al
	mov	al, 60h			; IRQ0 ɑ΂w EOI 𔭍s.
	out	IOPORT_PIC_M_OCW2, al	;  CPU ł̃nOh~̂܂Ȃ.
	sti
	; ẽEFCgvZ.
IF TARGET EQ TARGET_98
	;--- PC-98x1 EFCgvZ.
	; VXeNbN(0000:0501h)
	xor	bx, bx
	mov	es, bx
	mov	ch, es:[0501h]
	mov	ax, TSR_GROUP
	mov	es, ax
	assume	es:TSR_GROUP
.if(ch & 80h)
	mov	es:[_sysclk_type], SYSCLK_8M
.else
	mov	es:[_sysclk_type], SYSCLK_5M
.endif
	; e wait vZ (bp=N, bx=0)
	mov	cl, N_SOURCE_TYPES
wait_calc_loop:
.if(ch & 80h)
	mov	ax, DIVIDEND_8M[bx]
.else
	mov	ax, DIVIDEND_5M[bx]
.endif
	call	calc_wait_div
	mov	_calced_waits[bx], ax
	add	bx, 2		; word access
	dec	cl
	jnz	wait_calc_loop
	; ^C}p OPN(A) ̃EFCg͂Őݒ.
	mov	ax, [_calced_waits + (SRC_TYPE_OPN * 2)] ; word access
	mov	es:[_opn_wait], ax
ELSE
	;--- PC/AT EFCgvZ.
	; ^C}p OPN(A) ͖̂ŃEFCgvZ͂Ȃ.
	xor	bx, bx
	mov	ax, TSR_GROUP
	mov	es, ax
	assume	es:TSR_GROUP
	mov	cl, N_SOURCE_TYPES
wait_calc_loop:
	mov	ax, DIVIDEND_PC_AT[bx]
	call	calc_wait_div
	mov	_calced_waits[bx], ax
	add	bx, 2
	dec	cl
	jnz	wait_calc_loop
ENDIF
	; WX^A.
	assume	es:nothing
	pop	es
	popa
	ret

; wait vZ֐.
; : ax=񐔂Ŋl, bp=.
; o: ax=wait l.
; WX^j: dx
calc_wait_div:
	cmp	[remesured], 0
	jnz	@F
	xor	dx, dx
	jmp	LL
@@:	mov	dx, 8
	mul	dx
LL:	div	bp ; dx:ax / bp -> ax ... dx
.if(dx != 0 && ax != 0ffffh) ; ]肪āAax ɑȂ1.
	inc	ax
.endif
	ret

; wait vɌĂ΂銄xN^֐.
calc_wait_vector:
	inc	bp
	out	IOPORT_PIC_M_OCW2, al ; send eoi
	iret
calc_fm_wait_ ENDP


;--- void init_parasz_tables()
; ëTCYi[Ăe[u̒lpOtPʂɕϊ.
; : .
; ߒl: .
init_parasz_tables_ PROC PUBLIC
	push	si
	;--- e̐R[h̃TCYpOtPʂɕϊ.
	xor	si, si
@@:	cmp	si, N_CONTROL_TYPES * 2
	jae	L1
	mov	ax, code_parasz_tbl[si]
	add	ax, 15
	rcr	ax, 1			; ŽʂLɈꂽꍇ΍.
	shr	ax, 3
	mov	code_parasz_tbl[si], ax
	add	si, 2
	jmp	@B
L1:	;--- e̐f[^̃TCYpOtPʂɕϊ.
	xor	si, si
@@:	cmp	si, N_SOURCE_TYPES * 2
	jae	L2
	mov	ax, data_parasz_tbl[si]
	add	ax, 15
	rcr	ax, 1
	shr	ax, 3
	mov	data_parasz_tbl[si], ax
	add	si, 2
	jmp	@B
L2:	;---
	pop	si
	ret
init_parasz_tables_ ENDP


;--- void remove_unused_code()
; 𐧌䂷̂ɕKvȃR[hɎc.
; PɌƁA̕ɋl߂.
; : .
; ߒl: .
; O: init_parasz_table() Ăяo.
remove_unused_code_ PROC PUBLIC
	local	use_flags[N_CONTROL_TYPES]:byte ; R[hKv?
	push	bx
	push	cx
	push	si
	push	di
	push	dx
	push	es
L4:	;--- use_flags  0 NA.
	mov	di, N_CONTROL_TYPES
@@:	mov	use_flags[di - 1], 0
	dec	di
	jnz	@B
	;---݂鉹ɕKvȐR[h̃`FbN.
	mov	ax, TSR_GROUP
	mov	es, ax
	assume	es:TSR_GROUP
	mov	cl, es:[_n_sources]
	mov	si, offset _sources
	assume	si:ptr Source
cont_check_loop:
	xor	dx, dx
	mov	dl, es:[si].type_	; dx = srct (uint8_t)
	xor	ch, ch
@@:	cmp	ch, N_CONTROL_TYPES
	jae	L1
	xor	ax, ax
	mov	al, ch			; ax = cont (uint8_t)
	mov	di, ax			; save cont idx
	call	check_cont_		; check_cont(cont, srct)
	or	use_flags[di], al	; ēx 0 NAĂ͂Ȃ.
	inc	ch
	jmp	@B
L1:	add	si, sizeof(Source)
	dec	cl
	jnz	cont_check_loop
	assume	si:nothing
	;--- ݂Ȃ̐R[hl߂.
	; AAR[hς݂̏ꍇɍs.
	xor	dx, dx			; cont_idx
code_remove_loop:
	cmp	dx, N_CONTROL_TYPES
	jae	code_remove_end
	mov	si, dx			; si = cont_idx
	cmp	use_flags[si], 0	; ?
	jnz	no_remove
	add	si, si			; word access
	cmp	code_parasz_tbl[si], 0	; R[h?
	jz	no_remove
	; R[h폜.
	mov	ax, code_parasz_tbl[si]
	add	[removed_parasz], ax
	mov	ax, si			; save cont_idx
	cmp	dx, N_CONTROL_TYPES - 1 ; Ō̃R[hȂ㑱̃R[h͖.
	je	remove_only_this
	mov	bx, si
	mov	di, es:_cont_seg_tbl[bx]	; Rs[ZOg.
@@:	add	bx, 2
	mov	si, es:_cont_seg_tbl[bx]	; Rs[ZOg.
	test	si, si
	jnz	next_impl_exist		; ̏ꍇ si=0 ƂȂ.
	cmp	bx, (N_CONTROL_TYPES - 1) * 2 ; 㑱̎ς݃R[h邩?
	jb	@B
remove_only_this:
	mov	bx, ax
	mov	code_parasz_tbl[bx], 0
	mov	es:_cont_seg_tbl[bx], 0
	jmp	code_remove_end		; cont_idx č폜I.
next_impl_exist: ; 폜Ώۂ̐R[hɑR[h݂.
	xor	cx, cx
@@:	cmp	bx, N_CONTROL_TYPES * 2
	jae	sum_size_end
	add	cx, code_parasz_tbl[bx]
	add	bx, 2
	jmp	@B
sum_size_end:
	shl	cx, 3		; cx = TCY (para size -> byte size)
	push	ds
	push	es
	mov	es, di
	mov	ds, si
	xor	di, di
	xor	si, si
	rep movsw
	pop	es
	pop	ds
	; e[uXV.
	mov	si, ax
	mov	ax, code_parasz_tbl[si]	; ax = ̃R[hړŏ para .
	mov	si, dx
	add	si, si
	mov	code_parasz_tbl[si], 0	; R[h̏̃NA.
	mov	es:_cont_seg_tbl[si], 0
	add	si, 2
update_tbl_loop:
	cmp	si, N_CONTROL_TYPES * 2
	jae	sub_seg_end
	cmp	es:_cont_seg_tbl[si], 0
	jz	skip
	sub	es:_cont_seg_tbl[si], ax	; R[h seg addr XV.
skip:	add	si, 2
	jmp	update_tbl_loop
sub_seg_end:
no_remove:
	inc	dx
	jmp	code_remove_loop
code_remove_end:
	;---
	assume	es:nothing
	pop	es
	pop	dx
	pop	di
	pop	si
	pop	cx
	pop	bx
	ret
remove_unused_code_ ENDP


;--- void calc_data_seg_pos()
; e̐pf[^obt@̃ZOgʒu߂.
; : .
; ߒl: .
calc_data_seg_pos_ PROC PUBLIC
	push	bx
	push	cx
	push	si
	push	di
	push	es
	;--- f[^obt@Ɏg̈̐擪̃ZOgAhX߂.
	mov	ax, TSR_GROUP
	mov	es, ax
	assume	es:TSR_GROUP
	mov	si, (N_CONTROL_TYPES - 1) * 2
@@:	cmp	code_parasz_tbl[si], 0
	jnz	L1
	sub	si, 2
	jmp	@B
L1:	mov	ax, code_parasz_tbl[si]	; si = ԍŌʒuR[h idx
	add	ax, es:_cont_seg_tbl[si]	; f[^obt@擪 seg addr
	;--- ZOgʒǔvZ.
	mov	cl, es:[_n_sources]
	mov	di, offset _sources
	assume	di:ptr Source
calc_seg_pos_loop:
	cmp	code_parasz_tbl[si], 0
	jz	skip
	mov	es:[di].cont_data_seg, ax	; seg addr ݒ.
	xor	bx, bx
	mov	bl, es:[di].type_
	add	bx, bx				; word access
	add	ax, data_parasz_tbl[bx]
skip:	add	di, sizeof(Source)
	dec	cl
	jnz	calc_seg_pos_loop
	assume	di:ptr nothing
	;--- ȃobt@̐擪ZOg͂ŋL^.
	mov	es:[_mbuf_seg], ax
	;---
	assume	es:nothing
	pop	es
	pop	di
	pop	si
	pop	cx
	pop	bx
	ret
calc_data_seg_pos_ ENDP


;--- uint16_t calc_max_para_size()
; 풓ɃɎcƂłő̃pOt߂.
; : .
; ߒl: 풓ɃɎcƂłő̃pOt.
; ݎLĂpOt߂ĕԂ.
; ύXĂȂΏ]̒l.
; (svO MAXALLOC=0ffffh ɂȂĂ邽)
calc_max_para_size_ PROC PUBLIC
	push	bx
	push	ds
	;---
	mov	ah, 62h
	int	21h		; bx = segment of PSP
	dec	bx		; bx = segment of MCB
	mov	ds, bx
	mov	ax, ds:[3]	; ̃vOLĂpOt.
	;---
	pop	ds
	pop	bx
	ret
calc_max_para_size_ ENDP


;--- void fetch_tsr_info()
; 풓vO _TSR_DATA 猻݂ _TSR_DATA ɒlRs[.
; ۂ _TSR_DATA łȂ TSR_GROUP ZOgz̃ANZXȂ̂Œ.
; : .
; ߒl: .
fetch_tsr_info_ PROC PUBLIC
	push	es
	push	ds
	pusha		; ȒP̂(j󂳂郌WX^)
	;---
	; 풓ĂvO TSR_GROUP ̃ZOg擾.
	mov	ax, 3500h + TSR_VECTOR
	int	21h		; get vector -> es:bx
	mov	ax, es:[bx - 2]	; TSR_GROUP ͂ɕۑĂ.
	mov	ds, ax		; src
	mov	ax, TSR_GROUP
	mov	es, ax		; dst
	mov	si, offset tsr_data_head
	mov	di, si
	mov	cx, offset tsr_remove_data_tail
	sub	cx, si
	inc	cx
	shr	cx, 1		; _TSR_DATA  word Pʂ̃TCY.
	rep	movsw
	;---
	popa
	pop	ds
	pop	es
	ret
fetch_tsr_info_ ENDP


;--- uint16_t get_tsr_group_seg()
; TSR_GROUP ̃ZOgAhXԂ.
; : .
; ߒl: ax=TSR_GROUP_SEG
get_tsr_group_seg_ PROC PUBLIC
	mov	ax, TSR_GROUP
	ret
get_tsr_group_seg_ ENDP


;--- uint16_t get_cont_seg(uint8_t src_type)
; ^CvɑΉR[h̃ZOgAhXԂ.
; Ή̉̏ꍇ0Ԃ.
; : al=^Cv.
; ߒl: ax=R[h̃ZOgAhX(ΉȂ0)
get_cont_seg_ PROC PUBLIC
	; TODO: IɃe[uł悤ɂ.
.if(al == SRC_TYPE_OPL3)
	mov	ax, _TSR_OPL3_TEXT
.else
	xor	ax, ax
.endif
	ret
get_cont_seg_ ENDP


;--- void mute_sources_not_tsr()
; 풓yщɌĂяođS~[g.
; sources y n_sources ̐ݒ肪ĂKv.
; , ߒl: .
mute_sources_not_tsr_ PROC PUBLIC
	push	es
	push	ds
	pusha		; ȒP̂(j󂳂郌WX^)
	;---
	mov	di, MUTE_PROC_OFFSET
	call	call_cont_proc_all_far
	;---
	popa
	pop	ds
	pop	es
	ret
mute_sources_not_tsr_ ENDP


;---- uint16_t check_ymf_setting(uint16_t device_pos)
; : ax=foCXʒu.
; ߒl: SB16 y OPL3 p\ǂ(0=ps\, 1=\)
;	bit7-2: gp.
;	bit1  : OPL3 (0=ps\, 1=\)
;	bit0  : SB16 (0=ps\, 1=\)
check_ymf_setting_ PROC PUBLIC
	push	di
	push	cx
	push	bx
	;---
	mov	bx, ax
	mov	di, 40h		; LAD(Legacy Audio Control)
	mov	ax, 0b109h
	int	1ah
	test	ah, ah
	mov	ax, 0		; tOωȂ.
	jnz	Lend
	test	cx, 8000h	; LAD=0 ?
	jnz	Lend
	and	cx, 03h		; LAD ̉ 2bit ̂܂ܖ߂l.
	mov	ax, cx
	;---
Lend:	pop	bx
	pop	cx
	pop	di
	ret
check_ymf_setting_ ENDP


;--- uint16_t get_ymf_port(uint16_t device_pos, uint16_t is_ymf724,
;						uint16_t type)
; : ax=foCXʒu, dx=foCX YMF724 ǂ, bx=Ώۉ.
;	bx=(0: SB16, 1: OPL3)
; ߒl: (0=G[, 0=YMF7x4  OPL3  IO |[g)
get_ymf_port_ PROC PUBLIC
	cmp	bx, 1
	jbe	@F
	ret
@@:	push	cx
	push	si
	push	di
	;---
	mov	si, bx		; save bx
	mov	bx, ax
	mov	ax, 0b109h
	test	dx, dx
	jz	Lnot724
	;--- YMF724 ł IO |[g擾.
	mov	di, 42h		; Extended Legacy Audio Control
	int	1ah
	jc	Lpci_err
	test	si, si
	jz	Lsb162
	and	cx, 03h		; [1:0]=FMIO
	mov	bx, cx
	add	bx, bx		; word access
	mov	ax, [TBL_YMF724_FMIO + bx]
	jmp	Lend
Lsb162:	and	cx, 0ch		; [3:2]=SBIO
	mov	bx, cx
	shr	bx, 1		; word access
	mov	ax, [TBL_YMF724_SBIO + bx]
	jmp	Lend
Lnot724:;--- YMF744,754 ł IO |[g擾.
	shl	si, 1		; SB16  OPL3 ̃WX^Ԃ̍.
	mov	di, 62h		; Sound Blaster Base Address
	sub	di, si		; si != 0 Ȃ di=60h ɂȂ.
	int	1ah
	jc	Lpci_err
	mov	ax, cx
Lend:	;---
	pop	di
	pop	si
	pop	cx
	ret
Lpci_err:
	xor	ax, ax
	jmp	@B
get_ymf_port_ ENDP


IF TARGET EQ TARGET_PC
;--- uint16_t check_sb_dsp(uint16_t base_addr)
; : ax=SB ̃x[XAhX.
; ߒl: 茋(0=SB DSP , 0=炸)
;	ꍇ (((minor) << 8) | (major)) Ԃ.
check_sb_dsp_ PROC PUBLIC
	push	es
	push	bx
	push	dx
	push	si
	mov	si, ax			; si=base
	;--- EFCgKvȂ̂ŃVXe^C}ɏ풓.
	mov	ax, 3508h		; IRQ 0
	int	21h
	mov	cs:[origoff], bx
	mov	cs:[origseg], es
	mov	ah, 25h
	mov	dx, offset cs:vec
	push	ds
	push	cs
	pop	ds
	int	21h
	pop	ds
	;--- DSP Zbg.
	lea	dx, [si + 6]		; dx=reset port (2*6h)
	mov	al, 1
	out	dx, al
	mov	cs:[timer_cnt], 0
@@:	cmp	cs:[timer_cnt], 2	; 1ɂȂƃEFCgs.
	jb	@B			; Ǝv̂2܂ő҂.
	xor	al, al
	out	dx, al
	;--- DSP data port ̃|[O.
	xor	bx, bx			; bx=Δ0
	mov	cs:[timer_cnt], 0
Lwait:	lea	dx, [si + 0eh]		; dx=read-buffer status (2*eh)
	in	al, dx
	test	al, al
	js	@F
	cmp	cs:[timer_cnt], 2
	jae	Lerr			; Ȃ.
	jmp	Lwait
@@:	lea	dx, [si + 0ah]		; dx=read data port (2*ah)
	in	al, dx
	cmp	al, 0aah
	jnz	Lerr
	inc	bx
Lerr:	;--- n
	mov	ax, 2508h
	mov	dx, cs:[origoff]
	push	ds
	mov	ds, cs:[origseg]
	int	21h
	pop	ds
	;--- ȂȂ DSP ̃o[W擾͂Ȃ.
	test	bx, bx
	jz	Lend
	;--- check DSP version
	lea	dx, [si + 0ch]		; dx=write-buffer status (2*ch)
@@:	in	al, dx
	test	al, al
	js	@B			; wait for write
	mov	al, 0e1h		; DSP version
	out	dx, al
	lea	dx, [si + 0eh]
@@:	in	al, dx
	test	al, al
	jns	@B			; wait for read
	lea	dx, [si + 0ah]
	in	al, dx			; al=major version
	mov	bl, al
	lea	dx, [si + 0eh]
@@:	in	al, dx
	test	al, al
	jns	@B			; wait for read
	lea	dx, [si + 0ah]
	in	al, dx			; al=minor version
	mov	bh, al
Lend:	;---
	mov	ax, bx
	pop	si
	pop	dx
	pop	bx
	pop	es
	ret
	;---
timer_cnt db ?
	;--- VXe^C}풓[`.
vec:	inc	cs:[timer_cnt]
	db	0eah			; vector chain  far jmp
origoff	dw	?
origseg	dw	?
check_sb_dsp_ ENDP
ENDIF ; IF TARGET EQ TARGET_PC


_TEXT ENDS

END
