//--------------------------------------------------------
// N2KD FM Driver version 1.0a (beta 2b)
// not_tsr.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include "not_tsr.h"
#include "common.h"
#include "tsr.h"
#include "subr.h"
#include "str_proc.h"

#include <stdint.h>

// EFCǧvZ not_tsr.asm  calc_fm_wait_ ōsĂ.
// not_tsr.c ł͉LEFCge[uɑ΂Ă͓ǂݎ肵sȂ.
uint16_t calced_waits[N_SOURCE_TYPES] = { 0 };

// uBLASTER=vŎn܂ϐGgT.
// ߒl: (: 0, 炸: 0)
// ꍇ pos Ɋϐ̐ݒl̊Jnʒu index Ԃ.
static int8_t search_blaster_envvar(const char __far* env, uint16_t* pos)
{
	static const char BLASTER_STR[] = "BLASTER=";
	static const uint8_t BLASTER_LEN = 8;

	uint16_t ret = 0;
	while(1)
	{
		// ϐ̖[̊mF.
		const uint16_t tmp0 = *(uint16_t __far*)(env + ret + 0);
		const uint16_t tmp1 = *(uint16_t __far*)(env + ret + 2);
		if(tmp0 == 0 && tmp1 == 1) { return 0; }

		if(strncmp(env + ret, BLASTER_STR, BLASTER_LEN) == 0)
			break; // .

		uint16_t l = strlen(env + ret) + 1; // NULL ΂.
		if(0xffff - ret < l) { return 0; } // ꉞ[vh~.
		ret += l;
	}

	*pos = ret + BLASTER_LEN;
	return 1;
}

// BLASTER ϐ̃p[X.
BlasterParseResult parse_blaster_envvar(const char __far* env)
{
	BlasterParseResult ret;
	ret.addr = 0xffff;
	ret.irq = 0xff;
	ret.dma = 0xff;
	ret.status = BLASTER_ST_NOT_DEFINED;

	uint16_t pos;
	if(!search_blaster_envvar(env, &pos))
		return ret; // 炸.

	// BLASTER ϐ A, I, D ̒l.
	// ς猩Ȃő return .
	ret.status = BLASTER_ST_PARSE_FAILED;
	env += pos;
	uint16_t val;
	char ch;
	while((ch = *env++) != '\0')
	{
		if(ch == 'A') // 16ip[X.
		{
			if(!parse_hex_u16(&env, &val)) { return ret; }
			ret.addr = val;
		}
		else if(ch == 'I' || ch == 'D') // 10ip[X.
		{
			if(!parse_dec_u16(&env, &val)) { return ret; }
			if(0xff < val) { return ret; } // uint8_t ͈͊O.
			if(ch == 'I') ret.irq = (uint8_t)val;
			else ret.dma = (uint8_t)val;
		}
		else if(ch == 'M' || ch == 'P')
		{
			// G[ɂ͂Ȃ鍀(16ip[X)
			if(!parse_hex_u16(&env, &val)) { return ret; }
		}
		else if(ch == 'H')
		{
			// G[ɂ͂Ȃ鍀(10ip[X)
			if(!parse_dec_u16(&env, &val)) { return ret; }
		}
		else { return ret; } // m̋L.
		while(is_whitespace(*env)) { ++env; }
	}

	// 蓾l`FbN.
	if(!(ret.addr == 0x220 || ret.addr == 0x240
		|| ret.addr == 0x260 || ret.addr == 0x280))
		return ret;
	if(!(ret.irq == 2 || ret.irq == 5 || ret.irq == 7 || ret.irq == 10))
		return ret;
	if(!(ret.dma == 0 || ret.dma == 1 || ret.dma == 3))
		return ret;

	ret.status = BLASTER_ST_PARSE_OK;
	return ret;
}

// vÕp[X.
ArgParseResult parse_args(const char __far* argstr, uint16_t arglen)
{
	ArgParseResult ret;
	ret.command = ' ';
	ret.music_mem_sz = -1;

	char ch;
	uint8_t idx = 0;
	uint8_t flag = 0; // ėptO.

	while((flag == 0) && (idx < arglen))
	{
		ch = argstr[idx++];
		if(is_whitespace(ch)) continue;
		if((ch == 's') || (ch == 'r') || (ch == '?'))
		{
			ret.command = ch;
			flag = 1;
			break;
		}
		else goto parse_args_unknown_cmd;
	}
	if(flag == 0)
	{
		// LȃR}h.
parse_args_unknown_cmd:
		ret.status = PARSE_ERR_UNKNOWN_CMD;
		return ret;
	}

	// R}hvO̕Ȃ return
	if(idx == arglen) goto parse_args_no_error;

	uint16_t n_ws = count_whitespaces(argstr + idx);
	if(n_ws == 0)
	{
		// R}h1łȂ.
		ret.status = PARSE_ERR_UNKNOWN_CMD;
		return ret;
	}
	idx += n_ws;

	// IvṼp[X.
	flag = 0;
	while(idx < arglen)
	{
		ch = argstr[idx];
		if(is_whitespace(ch)) { idx += 1; continue; }
		if((ch != '/') && (ch != '-')) goto parse_args_unknown_opt;

		ch = argstr[++idx]; // i==(arglen-1) ł '\0' Ȃ̂ł OK
		if(ch == 'm') // ȃobt@TCY.
		{
			for(++idx; is_whitespace(argstr[idx]); ++idx); // 󔒂΂.
			// 1023ȉ10i̐lǂ(ŃpOtPʂɂۂɈȂől)
			int16_t m = 0;
			while(1)
			{
				uint8_t c = argstr[idx++];
				if((c < '0') || ('9' < c)) break;
				c -= '0';
				if(103 <= m) goto parse_args_invalid_opt_arg;
				if((102 == m) && (4 <= c)) goto parse_args_invalid_opt_arg;
				m = 10 * m + c;
			}
			ret.music_mem_sz = m;
		}
		else
		{
parse_args_unknown_opt:
			ret.status = PARSE_ERR_UNKNOWN_OPT;
			return ret;
		}
	}

parse_args_no_error:
	ret.status = PARSE_ERR_NO_ERROR;
	return ret;

parse_args_invalid_opt_arg:
	ret.status = PARSE_ERR_INVALID_OPT_ARG;
	return ret;
}


// hCo̊ef[^̈.
// hCoR[ḧړSďIĂĂяo.
// : .
// ߒl: .
void init_drv_data()
{
	const uint16_t tsr_grp_seg = get_tsr_group_seg();

	// F cont_seg, wait ݒ.
	for(uint8_t i = 0; i < n_sources; ++i)
	{
		const uint8_t type = sources[i].type_;
		sources[i].cont_seg = get_cont_seg(type);
		sources[i].ioport.wait_ = calced_waits[type];
	}

	// DrvProcTable ݒ.
	for(uint8_t i = 0; i < N_CONTROL_TYPES; ++i)
	{
		const uint16_t cont_seg = cont_seg_tbl[i];
		if(cont_seg == 0) continue;

		DrvProcTable __far* dpt = (DrvProcTable __far*)make_far_ptr(cont_seg, 0);
		dpt->tsr_group_seg = tsr_grp_seg;
	}
}

// 鉹ɂ鐧R[hKvׂ.
// : al=R[h̎, dl=̎
// ߒl: al=Kvǂ(0: sv, 0: Kv)
uint8_t check_cont(uint8_t cont, uint8_t src_type)
{
	if(cont == CONT_OPNA)
	{
		if(src_type == SRC_TYPE_OPN
			|| src_type == SRC_TYPE_OPNA
			|| src_type == SRC_TYPE_OPN2)
		{
			return 1;
		}
	}
	else if(cont == CONT_OPL3)
	{
		if(src_type == SRC_TYPE_OPL2
			|| src_type == SRC_TYPE_Y8950
			|| src_type == SRC_TYPE_OPL3
			|| src_type == SRC_TYPE_OPL4)
		{
			return 1;
		}
	}
	else if(cont == CONT_PPZ8)
	{
		if(src_type == SRC_TYPE_PPZ8) return 1;
	}
	else if(cont == CONT_ADPCM)
	{
		if(src_type == SRC_TYPE_ADPCM_256K
			|| src_type == SRC_TYPE_ADPCM_32K)
		{
			return 1;
		}
	}
	else if(cont == CONT_TMS3631)
	{
		if(src_type == CONT_TMS3631) return 1;
	}

	return 0;
}

// RS-232C(1)Ńf[^𑗐Mł悤ɂ.
// fobOpȂ̂łȊOɓɐݒ͂Ȃ.
// : .
// ߒl: .
#if defined(_DEBUG)
void init_rs232c()
{
	// 8253A ̃JE^2 9600bps pɐݒ肷.
	out8(0x77, 0xb6); // JE^2, 16bit ǂݏ, `g, oCiJEg.
	const uint8_t val = *(uint8_t __far*)make_far_ptr(0, 0x501); // 0000:0501h(x[XNbN)
	uint8_t cnt = 16; // 5MHz n.
	if(val & 0x80) cnt = 13; // 8MHz n.
	out8(0x75, cnt);

	// 8251 \tgEFAZbg.
	const uint16_t serial_io_cmd = 0x32; // mode set / command word write
	for(uint8_t i = 0; i < 3; ++i)
	{
		out8(serial_io_cmd, 0); // dummy instruction
		io_wait(6);
	}
	out8(serial_io_cmd, 0x40); // software reset
	io_wait(6);

	// 8251 [h[h.
	out8(serial_io_cmd, 0x4e); // 1 stop bit, non parity, 8bit, 1/16 clock
	io_wait(6);

	// 8251 R}h[h.
	out8(serial_io_cmd, 0x13); // RTS=0, error clear, recv disable, DTR=1, send enable
}
#endif

// A󔒕̐𐔂.
// : JEgΏۂ̕ւ̃|C^.
// ߒl: A󔒕̌.
uint16_t count_whitespaces(const char __far* str)
{
	uint16_t idx = 0;
	while(1)
	{
		const char ch = str[idx];
		if(is_whitespace(ch)) idx += 1;
		else break;
	}
	return idx;
}

// 풓p "N2KD" .
// : .
// ߒl: .
// xNg̐Ėŏ̂Ōďo^C~Oɒ.
void erase_stay_marker()
{
	void __far* pv;
	get_vector_p(&pv, 0x4e);
	char __far* pc = (char __far*)pv;
	pc[3] = 0;
	pc[4] = 0;
	pc[5] = 0;
	pc[6] = 0;
}

// 풓Ɋȅ풓ΌĂяo.
void call_each_remove_proc()
{
	// F cont_seg, wait ݒ.
	for(uint8_t i = 0; i < n_sources; ++i)
	{
		if(sources[i].type_ == SRC_TYPE_OPL3)
		{
			uint16_t seg = sources[i].cont_data_seg;
			remove_opl3(seg);
		}
	}
}
