//--------------------------------------------------------
// N2KD FM Driver version 1.0a (beta 2b)
// not_tsr.h
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#ifndef N2KD_NOT_TSR_H
#define N2KD_NOT_TSR_H

#include "dos_defs.h"

#include <stdint.h>

//--- variables
// no extern variables

//--- functions
// not_tsr.c
#define PARSE_ERR_NO_ERROR			0
#define PARSE_ERR_UNKNOWN_CMD		1
#define PARSE_ERR_UNKNOWN_OPT		2
#define PARSE_ERR_INVALID_OPT_ARG	3

typedef struct {
	char command;
	int16_t music_mem_sz; // set -1 if not specified
	uint16_t status;
} ArgParseResult;

#define BLASTER_ST_PARSE_OK	0
#define BLASTER_ST_NOT_DEFINED	1
#define BLASTER_ST_PARSE_FAILED	2

typedef struct {
	uint16_t addr;
	uint8_t irq;
	uint8_t dma;
	uint8_t status;
} BlasterParseResult;

ArgParseResult parse_args(const char __far* argstr, uint16_t arglen);
uint8_t check_cont(uint8_t cont, uint8_t src_type);
void init_drv_data();
void init_rs232c();
uint16_t count_whitespaces(const char __far* str);
void erase_stay_marker();
void call_each_remove_proc();
BlasterParseResult parse_blaster_envvar(const char __far* env);

// not_tsr.asm
int16_t check_stayed();
void fm_wait_tmp(uint16_t wait_cnt);
void calc_fm_wait();
void init_parasz_tables();
void remove_unused_code();
void calc_data_seg_pos();
uint16_t calc_max_para_size();
void fetch_tsr_info();
uint16_t get_tsr_group_seg();
uint16_t get_cont_seg(uint8_t src_type);
void mute_sources_not_tsr();

uint16_t check_ymf_setting(uint16_t device_pos);
uint16_t get_ymf_port(uint16_t device_pos, uint16_t is_ymf724, uint16_t type);

#if TARGET == TARGET_PC
uint16_t check_sb_dsp(uint16_t base_addr);
#endif

// tsr.asm ̔풓.
#if TARGET == TARGET_PC
void mask_dma(uint8_t dma_channel);
uint16_t setup_sb_dma(uint8_t dma_channel);
#endif

#endif // N2KD_NOT_TSR_H
