//--------------------------------------------------------
// N2KD FM Driver version 1.0a (beta 2b)
// str_proc.c
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#include "str_proc.h"

// 16i̕1𐔒lɒ.
// ߒl: (߂ꍇ: 0x00-0x0f, ߂Ȃꍇ: -1)
static int8_t parse_hex_char(const char ch)
{
	if('0' <= ch && ch <= '9') return (ch - '0');
	if(ch == 'A' || ch == 'a') return 0x0a;
	if(ch == 'B' || ch == 'b') return 0x0b;
	if(ch == 'C' || ch == 'c') return 0x0c;
	if(ch == 'D' || ch == 'd') return 0x0d;
	if(ch == 'E' || ch == 'e') return 0x0e;
	if(ch == 'F' || ch == 'f') return 0x0f;
	return -1;
}

// 10i̕1𐔒lɒ.
// ߒl: (߂ꍇ: 0x00-0x09, ߂Ȃꍇ: -1)
static int8_t parse_dec_char(const char ch)
{
	if('0' <= ch && ch <= '9') return (ch - '0');
	return -1;
}

int8_t strncmp(const char __far* sa, const char __far* sb, uint16_t n)
{
	char ca, cb;
	for(uint16_t i = 0; i < n; ++i)
	{
		ca = *sa++;
		cb = *sb++;

		const tmp = ca - cb;
		if(tmp < 0) return -1;
		if(0 < tmp) return 1;

		if(ca == '\0') return 0; // skip check of (tmp == 0)
	}
	return 0;
}

uint16_t strlen(const char __far* s)
{
	uint16_t ret = 0;
	while(s[ret] != '\0') { ++ret; }
	return ret;
}

// Ȃ16i̕𐔒lɒ.
// ߒl: (: 0, s: 0)
// p[Xłꍇ s l̎̕܂Ői.
uint8_t parse_hex_u16(const char __far** p_s, uint16_t* p_ret)
{
	const char __far* s = *p_s;
	uint16_t ret = 0;
	uint8_t n_digits = 0;
	while(1)
	{
		const int8_t v = parse_hex_char(*s);
		if(v < 0)
		{
			if(n_digits == 0) { return 0; } // 1lȂ.
			break;
		}
		if(4 <= n_digits) { return 0; } // 4葽.
		ret = ((ret) << 4) + v;
		++s;
		++n_digits;
	}

	*p_s = s;
	*p_ret = ret;
	return 1;
}

// Ȃ16i̕𐔒lɒ.
// ߒl: (: 0, s: 0)
// p[Xłꍇ s l̎̕܂Ői.
uint8_t parse_dec_u16(const char __far** p_s, uint16_t* p_ret)
{
	const char __far* s = *p_s;
	uint16_t ret = 0;
	uint8_t n_digits = 0;
	while(1)
	{
		const int8_t v = parse_dec_char(*s);
		if(v < 0)
		{
			if(n_digits == 0) { return 0; }
			break;
		}
		if(5 <= n_digits) { return 0; } // 5葽.
		if(ret == 6553 && 5 < v) { return 0; } // 65535傫.
		ret = (ret * 10) + v;
		++s;
		++n_digits;
	}

	*p_s = s;
	*p_ret = ret;
	return 1;
}
