;--------------------------------------------------------
; N2KD FM Driver version 1.0a (beta 2b)
; subr.asm
; Copyright (C) 2021-2026 Y. Shiokami
; Released under the 3-clause BSD License.
;--------------------------------------------------------

.186
.model small

INCLUDE common.inc

DGROUP GROUP _DATA, _BSS

PUBLIC get_vector_p_

_DATA SEGMENT PUBLIC USE16 'DATA'
msg_0x		db '0x', 0
_DATA ENDS

_BSS SEGMENT PUBLIC USE16 'BSS'
dec_print_buf	db 5 dup(?)	; uint16_t ܂ł̕\l5m.
_BSS ENDS

_TEXT SEGMENT PUBLIC USE16 'CODE'
	assume	cs:_TEXT, ds:DGROUP, ss:DGROUP

; int 29h gĕo͂邩ǂ.
USE_INT_29H equ 0

; \[`̂ .8086 ŃAZu.
; 8086 ΉbZ[W̕\łȂĂ͂ȂȂ.
.8086
;--- void putchar(char c)
; : ax=\镶.
; ߒl: .
putchar_ PROC PUBLIC
IF USE_INT_29H
	int	29h
ELSE
	push	ax		; int 29h Ȃ ax ͉Ȃ̂,
	push	dx		; ax ۑȂƒuɂȂȂ.
	mov	dl, al
	mov	ah, 02h
	int	21h
	pop	dx
	pop	ax
ENDIF
	ret
putchar_ ENDP


;--- void putstr(const char* str)
; NULL I[ȕ\.
; : ds:ax=̃|C^.
; ߒl: .
putstr_ PROC PUBLIC
	push	si
	mov	si, ax
L1:	mov	al, [si]
	test	al, al
	jz	@F
IF USE_INT_29H
	int	29h
ELSE
	call	putchar_
ENDIF
	inc	si
	jmp	L1
@@:	pop	si
	ret
putstr_ ENDP


;--- void putstr_far(const char __far* str)
; NULL I[ȕ\.
; : dx:ax= far |C^.
; ߒl: .
putstr_far_ PROC PUBLIC
	push	ds
	mov	ds, dx
	call	putstr_
	pop	ds
	ret
putstr_far_ ENDP
.186


;--- void print_u8(uint8_t val)
; uint8_t Ȓl 0x** ̌`ŕ\.
; : al=\l.
; ߒl: .
print_u8_ PROC PUBLIC
	push	ax
	mov	ax, offset msg_0x
	call	putstr_
	pop	ax
	; ̂܂ print_u8_noprefix ɗꗎ
print_u8_ ENDP


;--- void print_u8_noprefix(uint8_t val)
; uint8_t Ȓl ** (16i)̌`ŕ\.
; : al=\l.
; ߒl: .
print_u8_noprefix_ PROC PUBLIC
	push	ax
	mov	ah, al
	shr	al, 4
	cmp	al, 0ah
	jb	L1
	sub	al, (0ah - 'a')
	jmp	@F
L1:	add	al, '0'
@@:
IF USE_INT_29H
	int	29h
ELSE
	call	putchar_
ENDIF
	mov	al, ah
	and	al, 0fh
	cmp	al, 0ah
	jb	L2
	sub	al, (0ah - 'a')
	jmp	@F
L2:	add	al, '0'
@@:
IF USE_INT_29H
	int	29h
ELSE
	call	putchar_
ENDIF
	pop	ax
	ret
print_u8_noprefix_ ENDP


;--- void print_u16(uint16_t val)
; uint16_t Ȓl 0x**** ̌`ŕ\.
; : ax=\l.
; ߒl: .
print_u16_ PROC PUBLIC
	push	ax
	mov	ax, offset msg_0x
	call	putstr_
	pop	ax
	xchg	ah, al
	call	print_u8_noprefix_
	xchg	ah, al
	jmp	print_u8_noprefix_
print_u16_ ENDP


;--- void print_u8_dec(uint8_t val)
; uint8_t Ȓl 0`255 ̌`ŕ\.
; : al=\l.
; ߒl: .
print_u8_dec_ PROC PUBLIC
	;--- 0̏ꍇ͕ʂŏ.
	test	al, al
	jnz	@F
	mov	al, '0'
	jmp	putchar_
	;---
@@:	push	dx
	push	bx
	;--- 10ŊĊe̒lo.
	mov	dl, 10
	xor	bx, bx
@@:	xor	ah, ah
	div	dl			; ax / dl -> al ... ah
	mov	[dec_print_buf + bx], ah
	test	al, al
	jz	Lprint
	inc	bx
	jmp	@B
	;--- e̒l\.
Lprint:	mov	al, [dec_print_buf + bx]
	add	al, '0'
	call	putchar_
	test	bx, bx
	jz	Lend
	dec	bx
	jmp	Lprint
	;--
Lend:	pop	bx
	pop	dx
	ret
print_u8_dec_ ENDP


;--- void free_segment(uint16_t seg)
; ^ꂽZOg̃.
; : ax=ZOg.
; ߒl: .
free_segment_ PROC PUBLIC
	push	es
	mov	es, ax
	mov	ah, 49h
	int	21h		;  (ex=segment to free)
	pop	es
	ret
free_segment_ ENDP


;--- uint8_t in8(uint16_t port)
; 1oCgǂݎ in ߂s.
; : ax=|[g.
; ߒl: in l.
in8_ PROC PUBLIC
	push	dx
	mov	dx, ax
	in	al, dx
	pop	dx
	ret
in8_ ENDP


;--- void out8(uint16_t port, uint8_t val)
; 1oCgo͂ out ߂s.
; : ax=|[g, dx=o͂l.
; ߒl: .
out8_ PROC PUBLIC
	xchg	ax, dx
	out	dx, al
	xchg	ax, dx
	ret
out8_ ENDP


;--- void get_vector_f(void(__far** func)(), uint8_t vec)
;--- void get_vector_p(void __far** ptr, uint8_t vec)
; 荞݃xN^擾.
; : ds:ax=**func([ax]=off,[ax+2]=seg), dl=vec
; ߒl: .
get_vector_p_:
get_vector_f_ PROC PUBLIC
	push	si
	push	bx
	push	es
	;---
	mov	si, ax
	mov	ah, 35h
	mov	al, dl
	int	21h		; get vec -> es:bx
	mov	[si], bx	; save off
	mov	bx, es
	mov	[si + 2], bx	; seve seg
	;---
	pop	es
	pop	bx
	pop	si
	ret
get_vector_f_ ENDP


;--- void set_vector_f(void(__far* func)(), uint8_t vec)
; 荞݃xN^ݒ.
; : ax=off, dx=seg, bl=vec
; ߒl: .
set_vector_f_ PROC PUBLIC
	push	dx
	push	ds
	;---
	mov	ds, dx
	mov	dx, ax
	mov	ah, 25h
	mov	al, bl
	int	21h		; set vec <- ds:dx
	;---
	pop	ds
	pop	dx
	ret
set_vector_f_ ENDP


;--- uint16_t get_psp_seg()
; : .
; ߒl: segment of PSP
get_psp_seg_ PROC PUBLIC
	push	bx
	mov	ah, 62h
	int	21h		; seg of PSP -> bx
	mov	ax, bx
	pop	bx
	ret
get_psp_seg_ ENDP


;--- uint16_t get_env_area_seg()
; ϐ̈̃ZOgAhX擾.
; : .
; ߒl: ax=ϐ̃ZOgAhX.
get_env_area_seg_ PROC PUBLIC
	call	get_psp_seg_
	push	es
	mov	es, ax
	mov	ax, es:[2ch]	; ϐ̈̃ZOg.
	pop	es
	ret
get_env_area_seg_ ENDP


;--- void free_env_area()
; ϐ̈.
; : .
; ߒl: .
free_env_area_ PROC PUBLIC
	call	get_env_area_seg_
	push	es
	mov	es, ax
	mov	ah, 49h
	int	21h		; ϐ̈.
	pop	es
	ret
free_env_area_ ENDP


;--- void clear_interrupt_flag()
; : .
; ߒl: .
clear_interrupt_flag_ PROC PUBLIC
	cli
	ret
clear_interrupt_flag_ ENDP


;--- void set_interrupt_flag()
; : .
; ߒl: .
set_interrupt_flag_ PROC PUBLIC
	sti
	ret
set_interrupt_flag_ ENDP


;--- void io_wait(uint16_t cnt)
; cnt  IO |[gANZXp̑ҋ@s.
; : ax=ҋ@s.
; ߒl: .
io_wait_ PROC PUBLIC
	test	ax, ax
	jnz	@F
	ret
@@:	push	cx
	mov	cx, ax
L1:	IO_WAIT	1
	loop	L1
	pop	cx
	ret
io_wait_ ENDP


;--- void __far* make_far_ptr(uint16_t seg, uint16_t off)
; far |C^𓾂.
; : Ԃ far |C^̃ZOgAhXƃItZbgAhX.
; ߒl: far |C^.
make_far_ptr_ PROC
	xchg	ax, dx
	ret
make_far_ptr_ ENDP


;--- uint16_t check_cpu()
; CPU 𒲂ׂ.
; : .
; ߒl: 茋(0=8086, 2=80286, 3=80386, 4=80486ȍ~, 30=V30)
check_cpu_ PROC
.8086	;--- push sp ̎dlp 8086/80186/V30 ȊO.
	push	sp
	pop	ax
	cmp	ax, sp
	jz	check_v86
.186	;--- 80186 ̔.
	push	cx
	mov	ax, 0ffffh
	mov	cl, 32
	shl	ax, cl	; 8086  V30 32Vtg ax=0 ɂȂ.
	test	ax, ax
	pop	cx
	jz	not_186
	mov	ax, 1
	ret
.8086	;--- 8086  V30 ̔.
not_186:
	push	dx
	mov	dx, sp		; save sp
	push	cs
	; 8086  V30 ŋ̈Ⴄߗ.
	; 8086: pop cs, adc al, al
	; V30 : clr1, al (al  cl rbgڂ0ɂ)
db	0fh, 12h, 0c0h
	cmp	dx, sp
	jnz	v30
	xor	ax, ax
	jmp	@F
v30:	add	sp, 2		; push cs ̂̕Ă.
	mov	ax, 30
@@:	pop	dx
	ret
.286	;---  v86 [hǂ肷.
	; ̑̕O: veNg[hł̃vO𓮂Ƃ͂Ȃ.
	; AA[h v86 [ĥǂ炩œĂ锤ƂO.
check_v86:
	smsw	ax
	test	ax, 1		; check PE (protect enable) bit
	jz	check_286	; 0 Ȃ烊A[h.
	mov	ax, 3		; 1 Ȃ v86 [hƔf.
	ret
check_286:
	;--- tOWX^ 12-15bit ڂ0ǂŔ.
	push	dx
	pushf
	pop	ax		; ax = flags
	mov	dx, ax		; save original flags
	or	ax, 0f000h
	push	ax
	popf			; flags = 12-15bit ڂ1ɂl.
	pushf
	pop	ax		; ax = flags
.if(!(ax & 0f000h))		; ̌tOAŝŐɔ.
	mov	ax, 2
.else
	mov	ax, 3
.endif
	push	dx
	popf			; restore flags
	pop	dx
	cmp	ax, 2
	jnz	check_386
	ret
.386	;--- eflags  AC rbgύXsǂŔ.
check_386:
	push	edx
	push	ecx
	pushfd
	pop	eax		; eax = eflags
	mov	edx, eax	; save original eflags
	mov	ecx, eax
	and	ecx, (1 SHL 18)	; AC rbg̒l𒊏o.
	xor	eax, (1 SHL 18)	; AC rbg𔽓].
	push	eax
	popfd			; eflags = AC ]l.
	pushfd
	pop	eax		; eax = eflags
	and	eax, (1 SHL 18)
	xor	eax, ecx	; ύXłȂ ZF=1 ɂȂ.
.if(zero?)
	mov	ax, 3
.else
	mov	ax, 4
.endif
	push	edx
	popfd
	pop	ecx
	pop	edx
	ret
.186
check_cpu_ ENDP


;--- check_pci_bios()
; PCI BIOS g邩ׂ.
; : .
; ߒl: 茋(0=gȂ, 1=g)
; ̃[`̎sɂ386߂KvAO`FbNĂȂ̂Œ.
check_pci_bios_ PROC PUBLIC
.386
	push	dx
	push	bx
	push	cx
	;---
	xor	edx, edx
	clc
	mov	ax, 0b101h
	int	1ah
.if((ah == 0) || !(carry?)) && (edx == 20494350h)
	mov	ax, 1
.else
	xor	ax, ax
.endif
	;---
	pop	cx
	pop	bx
	pop	dx
	ret
.186
check_pci_bios_ ENDP


;--- uint16_t find_pci_device(uint16_t vendor_id, uint16_t device_id,
;				uint16_t device_idx, uint16_t* device_pos)
; PCI foCXT.
; : ax=vendor_id, dx=device_id, bx=device_idx, ds:cx=*device_pos
; ߒl: 0=炸, 1=.
find_pci_device_ PROC PUBLIC
	push	dx
	push	cx
	push	bx
	push	si
	push	di
	;---
	mov	di, cx		; save *device_pos
	mov	si, bx		; si = device_idx
	mov	cx, dx		; cx = device_id
	mov	dx, ax		; dx = vendor_id
	mov	ax, 0b102h
	int	1ah
.if(ah == 0)
	mov	ax, 1
	mov	[di], bx
.else
	xor	ax, ax
.endif
	;---
	pop	di
	pop	si
	pop	bx
	pop	cx
	pop	dx
	ret
find_pci_device_ ENDP

_TEXT ENDS

END
