//--------------------------------------------------------
// N2KD FM Driver version 1.0a (beta 2b)
// subr.h
// Copyright (C) 2021-2026 Y. Shiokami
// Released under the 3-clause BSD License.
//--------------------------------------------------------

#ifndef N2KD_SUBR_H
#define N2KD_SUBR_H

#include "dos_defs.h"

#include <stdint.h>

void print_u8_noprefix(uint8_t val);
void print_u8(uint8_t val);
void print_u16(uint16_t val);
void print_u8_dec(uint8_t val);

void putchar(char c);
void putstr(const char* str);
void putstr_far(const char __far* str);

uint8_t is_whitespace(const char c);

void free_segment(uint16_t seg);

uint8_t in8(uint16_t port);
void out8(uint16_t port, uint8_t val);

void get_vector_f(void(__far** func)(), uint8_t vec);
void set_vector_f(void(__far* func)(), uint8_t vec);
void get_vector_p(void __far** ptr, uint8_t vec);

uint16_t get_psp_seg();
uint16_t get_env_area_seg();
void free_env_area();

void clear_interrupt_flag();
void set_interrupt_flag();

void io_wait(uint16_t cnt);

void __far* make_far_ptr(uint16_t seg, uint16_t off);

uint16_t check_cpu();
uint16_t check_pci_bios();
uint16_t find_pci_device(uint16_t vendor_id, uint16_t device_id, uint16_t device_idx, uint16_t* device_pos);

#endif
