;--------------------------------------------------------
; N2KD FM Driver version 1.0a (beta 2b)
; tsr.asm
; Copyright (C) 2021-2026 Y. Shiokami
; Released under the 3-clause BSD License.
;--------------------------------------------------------

.186
.model small

include common.inc
include version.inc


; ^C}S OPN(A) ݃}N.
; ZOgႤ̐R[h call ł͌ĂׂȂ̂łŒ`.
WRITE_TIMER_OPN_AX MACRO
	call	tsr_write_timer_opn
ENDM
WRITE_TIMER_OPN MACRO addr, val
	SET_WRITE_ARG	(addr), (val)
	call	tsr_write_timer_opn
ENDM


;--- tsr.h ɋLڂĂϐ.
; Source[]
PUBLIC	_sources
; uint16_t
PUBLIC	_opn_addr, _opn_data, _opn_wait, _tsr_psp_seg,
	_remain_parasz, _mbuf_seg, _mbuf_parasz
; uint8_t
PUBLIC	_opn_int_status, _opn_irq, _orig_imr_masked, _n_sources,
	_stayed_timer_type, _sysclk_type,
	_sb_irq_idx, _sb_dma_idx, _sb_base_addr
IF TARGET EQ TARGET_PC
PUBLIC	_sb_dma_ack_port, _sb_write_port
ENDIF
; void(__far* __far func)()
PUBLIC	_tsr_orig_vec, _fm_orig_vec

;--- tsr.h ɋLڂĂȂϐ.
PUBLIC	tsr_data_head, tsr_remove_data_tail
PUBLIC	_cont_seg_tbl

;--- ̃ZOg̏풓[`ANZXϐ.
PUBLIC	new_timer_b_val, new_timer_5m_val, new_timer_8m_val,
	new_timer_pc_at_val, new_timer_sb_val,
	new_timer_n_wait, timer_sb_n_samples


_TSR_DATA SEGMENT PARA PUBLIC USE16 'TSR_DATA'
tsr_data_head:
source_list_music:	; ȃf[^̉.
			db (sizeof(SourceInMusic) * N_MAX_SOURCES) dup (0)
_sources:		; F̏.
			db (sizeof(Source) * N_MAX_SOURCES) dup(0)
; R[h̃ZOgAhX.
_cont_seg_tbl		dw 0, ; OPNA
			   _TSR_OPL3_TEXT, ; OPL3
			   _TSR_PPZ8_TEXT, ; PPZ8
			   0, ; ADPCM
			   0  ; TMS3631
_tsr_orig_vec		dd ? ; far pointer
_fm_orig_vec		dd ? ; far pointer
_opn_addr		dw ? ; ^C} OPN AhX|[g.
_opn_data		dw ? ; ^C} OPN f[^|[g.
_opn_wait		dw ? ; ^C} OPN ANZXEFCg.
_sb_base_addr		dw ? ; SB IO |[gx[XAhX.
_tsr_psp_seg		dw ? ; 풓vO PSP
_n_sources		db 0 ; hCoǗ̉.
_opn_int_status		db ? ; ^C} OPN 荞݃Xe[^X.
_opn_irq		db ? ; ^C} OPN IRQ ԍ.
_sb_irq_idx		db ? ; ^C} SB irq_idx=(0,1,2,3) <-> IRQ=(2,5,7,10)
_sb_dma_idx		db ? ; ^C} SB dma_idx=(0,1,2) <-> DMA=(0,1,2)
_sysclk_type		db ?
_stayed_timer_type	db ? ; ǂ̃^C}ɏ풓.
_orig_imr_masked	db 0
tsr_remove_data_tail:	; 풓ɕKvȃf[^.

; 풓ɂ͕KvȂf[^.
	EVEN
;-------------------------------------------
; hCo䏈֐e[u.
TSR_FUNC_MAX	equ 0eh
TSR_JMP_TBL	dw offset tsr_con_00h, offset tsr_con_01h, offset tsr_con_02h,
		   offset tsr_con_03h, offset tsr_con_04h, offset tsr_con_05h,
		   offset tsr_con_06h, offset tsr_con_07h, offset tsr_con_08h,
		   offset tsr_con_09h, offset tsr_con_0ah, offset tsr_con_0bh,
		   offset tsr_con_0ch, offset tsr_con_0dh
;-------------------------------------------
; 䏈e[u(PC-98x1 ̏ꍇ̂ݎgp)
; tp^C}Jnp֐e[u(я _stayed_timer_type ̒lɑΉ)
IF TARGET EQ TARGET_98
INT_TIMER_STARTER_TBL	dw TSR_GROUP:start_int_timer_opn,
			   TSR_GROUP:start_int_timer_5m,
			   TSR_GROUP:start_int_timer_8m
; tp^C}ݒlXVp֐e[u(я͓)
TIMER_VAL_UPDATER_TBL	dw TSR_GROUP:update_timer_val_opn,
			   TSR_GROUP:update_timer_val_5m,
			   TSR_GROUP:update_timer_val_8m
ELSE
INT_TIMER_STARTER_TBL	dw TSR_GROUP:start_int_timer_pc_at,
			   TSR_GROUP:start_int_timer_sb
TIMER_VAL_UPDATER_TBL	dw TSR_GROUP:update_timer_val_pc_at,
			   TSR_GROUP:update_timer_val_sb
ENDIF
;-------------------------------------------
; far call ̃AhXu.
far_call_off		dw ?
far_call_seg		dw ?
; call_cont_proc_mall/_all  push/pop ȗp.
ccp_save_cx		dw ?
ccp_save_bx		dw ?
ccp_save_di		dw ?
;-------------------------------------------
title_ptr		dw ? ; ȏ񕶎ւ̃ItZbg(̏ԕK{)
composer_ptr		dw ? ; ZOg _mbuf_seg ̒l.
arranger_ptr		dw ?
comment_ptr		dw ?
_remain_parasz		dw ? ; 풓ɃɎcpOtTCY.
_mbuf_seg		dw ? ; ȃobt@擪ZOgAhX.
_mbuf_parasz		dw ? ; pOtPʂł̋ȃobt@TCY.
curr_timer_val		dw 0ffffh ; PC/AT  PIT ɍ킹l.
new_timer_b_val		dw 0 ; curr_timer_val Ƃ̂ȕւɂ邽 dw
new_timer_5m_val	dw 0 ; (V^C}[l != ^C}[l) ^̏ꍇ,
new_timer_8m_val	dw 0 ; ^C}XV.
new_timer_pc_at_val	dw 0
new_timer_sb_val	dw 0
IF TARGET EQ TARGET_PC
orig_timer_int_cnt	dw 0 ;  PIT ĂԂ߂̃JE^.
_sb_write_port		dw ? ; SB write |[g (2*ch)
_sb_dma_ack_port	dw ? ; SB 8bit DMA ACK |[g (2*eh)
sb_dma_base_addr	dw ? ; DMAC ɐݒ肷x[XAhX.
dmac_cnt_port		dw ? ; e|Ǘp DMA ch ̃JEgw背WX^ʒu.
ENDIF
;------------------------------------------- (word ANZX byte ϐ)
timer_wait_cnt		db 0 ; ^C}荞ݑҋ@JE^.
timer_n_wait		db 0 ; ^C}荞ݑҋ@.
;-------------------------------------------
IF TARGET EQ TARGET_PC
sb_dma_page_addr	db ? ; DMA ̃y[WWX^̃b`ɓl.
ENDIF
driver_flags		db 0 ; hCotO.
play_status		db PLST_STOP
n_sources_music		db ? ; ȃf[^ɒ`Ă鉹.
timer_sb_n_samples	db ? ; ^C}p SB DMA ̓]obt@.
new_timer_n_wait	db 0
;-------------------------------------------
; 䊄̌Ăяo\^C~Oe[u.
; Ăяo\ȏꍇ (1 << PLST_**)  bit 𗧂Ă.
;  MSB=1 ̏ꍇȃf[^[h`FbNs.
TSR_FUNC_CALLABLE_TIMING db \
	1fh, 01h, 1fh, 85h,	; ah=00h-03h
	06h, 02h, 07h, 07h,	; ah=04h-07h
	01h, 87h, 07h, 07h,	; ah=08h-0bh
	87h, 87h, 81h		; ah=0ch-0eh

; hCotOl`.
DRV_FLAG_IN_FM_TSR	equ 01h
DRV_FLAG_IN_CTL_TSR	equ 02h
DRV_FLAG_LOAD_OK	equ 04h	; Őȃf[^[hǂ.
DRV_FLAG_CHAIN_ORIG_VEC	equ 08h ; ̃xN^Ƀ`FC邩ǂ(PC/AT p)
;-------------------------------------------
IF TARGET EQ TARGET_PC
; SB  PCM DMA obt@.
; DMA  64KiB E΍ 63oCg(vO͍ő32oCg)
sb_dma_buf db 63 dup(80h) ; 80h=.
ENDIF

_TSR_DATA ENDS


_TSR_TEXT SEGMENT PARA PUBLIC USE16 'TSR_CODE'
	ASSUME	cs:TSR_GROUP, ds:TSR_GROUP

	; 풓 _TSR_DATA f[^ɐGp.
	; u풓xN^擾(tsr_top_ 擾)  2߂v TSR_GROUP .
	EVEN
	dw	TSR_GROUP

;===========================================
tsr_top_ PROC PUBLIC
	jmp	near ptr tsr_main
	db	'N2KD', 0,		; 풓`FbNpf[^.
		DRIVER_VERSION_MAJOR, DRIVER_VERSION_MINOR,
		DRIVER_VERSION_PATCH, DRIVER_VERSION_BETA

;--- dl ---
; 1. 䊄ďoւ̃G[̓`B CF  ax ōs.
; 2. eł ax ̂ݐݒ肷(CF  iret ̒O ax Đݒ)
; 3. eɓO ds = cs Ƃ.
; 4. bx, ds ͊eɔԑO push .

tsr_main:
	;--- ēh~`FbN.
	test	cs:[driver_flags], DRV_FLAG_IN_CTL_TSR
	jz	@F
	mov	ax, TSRERR_IN_TSR_FLAG
	iret
@@:	or	cs:[driver_flags], DRV_FLAG_IN_CTL_TSR
	sti
	;--- xN^ԍ`FbN.
	push	bx		; ds AȂƂ̌ˍŐ push
	cmp	ah, TSR_FUNC_MAX
	jbe	@F
	mov	ax, TSRERR_NOT_IMPLEMENTED
	jmp	tsr_L1
@@:	;--- Ăяo^C~O`FbN.
	; al ͐xN^̈ɂȂĂ邩Ȃ̂ŎgȂ.
	xor	bh, bh
	mov	bl, ah
	push	cx
	mov	cl, cs:[play_status]
	mov	ch, 1
	shl	ch, cl		; ch=`FbNprbg.
	test	ch, cs:[TSR_FUNC_CALLABLE_TIMING + bx]
	pop	cx		; tOωȂ.
	jnz	@F
	mov	ax, TSRERR_UNCALLABLE_STATUS
	jmp	tsr_L1
	;--- ȃ[hς݂ǂ`FbN.
@@:	test	cs:[TSR_FUNC_CALLABLE_TIMING + bx], 80h
	jz	@F
	test	cs:[driver_flags], DRV_FLAG_LOAD_OK
	jnz	@F
	mov	ax, TSRERR_MUSIC_DATA_NOT_LOADED
	jmp	tsr_L1
	;---
@@:	push	ds
	mov	bx, cs
	mov	ds, bx
	xor	bx, bx
	mov	bl, ah
	add	bx, bx		; word access
	jmp	[TSR_JMP_TBL + bx]
tsr_func_end::
	; ̏ ds j󂵂Ă̂ pop O ds gꍇ͗vC.
	pop	ds
tsr_L1:
	pop	bx
	; G[̗Lɍ킹ăX^bÑtO CF ύX.
	push	bp
	mov	bp, sp
	or	word ptr [bp + 6], 1
	test	ax, ax
	jnz	@F
	and	word ptr [bp + 6], NOT 1
@@:	pop	bp
	cli
	and	cs:[driver_flags], NOT DRV_FLAG_IN_CTL_TSR
	iret			; xN^`FC.

tsr_func_end_no_ds_pop::	; ds AɏIꍇ.
	add	sp, 2		; ds ς܂ĂX^bNj.
	jmp	tsr_L1
tsr_top_ ENDP

;------------------------------------------- ah = 00h
; hCoo[W擾.
tsr_con_00h PROC PRIVATE
	mov	dx, (DRIVER_VERSION_MINOR SHL 8) + DRIVER_VERSION_MAJOR
	mov	cx, (DRIVER_VERSION_BETA SHL 8) + DRIVER_VERSION_PATCH
	xor	ax, ax
	jmp	tsr_func_end
tsr_con_00h ENDP
;------------------------------------------- ah = 01h
; ȃf[^[hƍĐ(̂ŉ̕Ŏ)
;------------------------------------------- ah = 02h
; ĐXe[^X擾.
tsr_con_02h PROC PRIVATE
	mov	dl, [play_status]
	xor	ax, ax
	jmp	tsr_func_end
tsr_con_02h ENDP
;------------------------------------------- ah = 03h
; Đ.
tsr_con_03h PROC PRIVATE
	;--- ݂̃Xe[^X`FbN.
	; al ͈łȂŌj󂳂̂ push O̕ύXłȂ.
@@:	mov	al, [play_status]
	cmp	al, PLST_PLAYING
	jz	all_skip
	cmp	al, PLST_STOP
	jz	init
	push	dx		;  PLST_PAUSE m.
	push	bx
	jmp	start_int
init:	;--- ~̏.
	push	dx
	push	bx
	push	cx
	push	es
	push	di
	mov	di, INIT_PROC_OFFSET
	call	call_cont_proc_mall
	pop	di
	pop	es
	pop	cx
	; STOP ̎ timer_wait_cnt 0ɂ.
	mov	[timer_wait_cnt], 0
start_int:
	;--- ĐXe[^XXV.
	mov	[play_status], PLST_PLAYING
	;--- Jn.
	; fobOpoCił̓hCoł̉tJn͍sȂ.
	; MEMO: ďo͕ςȂ̂ŏ풓Ɏȏɂ̂.
IFE _DEBUG
	xor	bx, bx
	mov	bl, [_stayed_timer_type]
	add	bx, bx		; word access
	call	[INT_TIMER_STARTER_TBL + bx]
ENDIF
	;---
	pop	bx
	pop	dx
all_skip:
	xor	ax, ax
	jmp	tsr_func_end
tsr_con_03h ENDP
;------------------------------------------- ah = 04h
; ~.
tsr_con_04h PROC PRIVATE
.if([play_status] == PLST_PAUSE)
	mov	[play_status], PLST_STOP ; ꎞ~Ȃ炻̂܂ܒ~Ɉڍs.
.else
	mov	[play_status], PLST_STOP_REQ
.endif
	xor	ax, ax
	jmp	tsr_func_end
tsr_con_04h ENDP
;------------------------------------------- ah = 05h
; ꎞ~.
tsr_con_05h PROC PRIVATE
	mov	[play_status], PLST_PAUSE_REQ
	xor	ax, ax
	jmp	tsr_func_end
tsr_con_05h ENDP
;------------------------------------------- ah = 06h
; ȃf[^obt@ZOgAhX擾.
tsr_con_06h PROC PRIVATE
	mov	ds, [_mbuf_seg]
	xor	dx, dx
	xor	ax, ax
	jmp	tsr_func_end_no_ds_pop
tsr_con_06h ENDP
;------------------------------------------- ah = 07h
; ȃf[^obt@TCY擾.
tsr_con_07h PROC PRIVATE
	mov	dx, [_mbuf_parasz]
	xor	ax, ax
	jmp	tsr_func_end
tsr_con_07h ENDP
;------------------------------------------- ah = 08h
; ȃf[^obt@TCYݒ.
tsr_con_08h PROC PRIVATE
	mov	[_mbuf_seg], es
	mov	[_mbuf_parasz], dx
	xor	ax, ax
	jmp	tsr_func_end
tsr_con_08h ENDP
;------------------------------------------- ah = 09h
; ȏ擾.
tsr_con_09h PROC PRIVATE
	cmp	al, 4
	ja	inv_query_num
	jb	get_info_str
	;--- (al == 4)
	mov	cl, [n_sources_music]
	jmp	Lok
	;--- (al < 4)
get_info_str:
	mov	bl, al
	xor	bh, bh
	add	bx, bx
	mov	dx, [bx + title_ptr]
	mov	es, [_mbuf_seg]
Lok:	xor	ax, ax
	jmp	tsr_func_end
tsr_con_09h ENDP
;------------------------------------------- ah = 0ah
; FĂ鉹̌擾.
tsr_con_0ah PROC PRIVATE
	mov	dl, [_n_sources]
	xor	ax, ax
	jmp	tsr_func_end
tsr_con_0ah ENDP
;------------------------------------------- ah = 0bh
; FĂ鉹̏擾.
tsr_con_0bh PROC PRIVATE
	cmp	al, [_n_sources]
	jae	inv_src_idx
	cmp	dl, 1
	ja	inv_query_num
	;--- Source ̔zɃANZX̂ (dl=0, dl=1 ̏ꍇƂɓ)
	mov	ah, sizeof(Source)
	mul	ah
	mov	bx, ax
	assume	bx:ptr Source
.if(dl)
	mov	dx, [bx].cont_data_seg
.else
	mov	cl, [bx].type_
	xor	dx, dx
	cmp	cl, SRC_TYPE_PPZ8	; PPZ8 ̏ꍇ IO |[g̒l.
	jz	Lok
	mov	dx, [bx].ioport.addr0
.endif
	assume	bx:nothing
Lok:	xor	ax, ax
	jmp	tsr_func_end
	;---
inv_src_idx::
	mov	ax, TSRERR_INVALID_SRC_INDEX
	jmp	tsr_func_end
	;---
inv_query_num::
	mov	ax, TSRERR_INVALID_QUERY_NUM
	jmp	tsr_func_end
tsr_con_0bh ENDP
;------------------------------------------- ah = 0ch
; ȃ[h̉̏擾.
tsr_con_0ch PROC PRIVATE
	cmp	al, [_n_sources]
	jae	inv_src_idx
	;---
	test	dl, dl
	jnz	inv_query_num
	;---
	push	cx
	mov	dl, sizeof(Source)
	mul	dl
	mov	bx, ax
	assume	bx:ptr Source
	mov	ax, [bx + _sources].cont_data_seg ; 擾Ώۉ̐ data seg
	assume	bx:ptr SourceInMusic
	mov	bx, offset source_list_music
	xor	cx, cx			; (ch, cl)=(found flag, loop counter)
search_loop:
	cmp	[bx].cont_seg, 0	; cont_seg == 0 Ȃ特.
	jz	@F
	cmp	ax, [bx].cont_data_seg	; cont_data_seg Ȃ犄攭.
	jnz	@F
	mov	ah, cl			; ah ɉ idx ۑ.
	inc	ch
	jmp	search_end
@@:	cmp	cl, [n_sources_music]
	jae	search_end
	add	bx, sizeof(SourceInMusic)
	inc	cl
	jmp	search_loop
search_end:
	assume	bx:nothing
	test	ch, ch
	jnz	found
	pop	cx
	mov	ax, TSRERR_NOT_ASSIGNED
	jmp	@F
found:	mov	dl, ah
	pop	cx
	xor	ax, ax
@@:	jmp	tsr_func_end
tsr_con_0ch ENDP
;------------------------------------------- ah = 0dh
; ȃf[^̉擾.
tsr_con_0dh PROC PRIVATE
	cmp	al, [n_sources_music]
	jae	inv_src_idx
	;---
	cmp	dl, N_MUSIC_QUERY
	jae	inv_query_num
	;---
	push	es
	mov	bl, sizeof(SourceInMusic)
	mul	bl
	add	ax, offset source_list_music
	mov	bx, ax
	assume	bx:ptr SourceInMusic
	cmp	[bx].cont_seg, 0
	jz	Lnot_assigned
	; music_query_proc ďo.
	call	call_music_query_proc
	assume	bx:nothing
	xor	ax, ax
@@:	pop	es
L0:	jmp	tsr_func_end
Lnot_assigned:
	mov	ax, TSRERR_NOT_ASSIGNED
	jmp	@B
tsr_con_0dh ENDP
;-------------------------------------------
; xN^ ah = 01h ̋ȃf[^[h̎.
tsr_con_01h PROC PRIVATE
	cld		; int ŌĂ΂̂ iret ŃtOA.
	push	es
	push	si
	push	di
	push	cx
	push	dx
	push	bp
	;--- [htONA.
	and	[driver_flags], NOT DRV_FLAG_LOAD_OK
	;--- OPN ^C}~.
IF TARGET EQ TARGET_98
.if ([_stayed_timer_type] == TIMER_TYPE_OPN)
	call	stop_int_timer_opn
.endif
ENDIF
	;--- es:si ȃobt@Ɍ.
	mov	es, [_mbuf_seg]
	xor	si, si
	;--- check magic
	lodsw	es:[si]
	cmp	ax, '2N' OR 8080h
	jnz	invalid_data
	lodsw	es:[si]
	cmp	ax, 'MK' OR 8080h
	jnz	invalid_data
	;--- check version
	; beta ǂɂ炸o[W͈vKv.
	lodsw	es:[si]		; ax = version (major)
	cmp	ax, DRIVER_VERSION_MAJOR
	jz	@F
unsupported_ver:
	mov	ax, TSRERR_UNSUPPORTED_VERSION
	jmp	Lend
@@:
IF DRIVER_VERSION_BETA EQ 0
	;  beta o[W(啛o[WŔ)
	lodsw	es:[si]		; ax = version (minor)
	cmp	ax, DRIVER_VERSION_MINOR
	ja	unsupported_ver
	lodsw	es:[si]		; ax = version (beta)
	test	ax, ax		; beta=0 łȂĂ͂ȂȂ.
	jnz	unsupported_ver
ELSE
	; beta o[W(So[ẄvKv)
	lodsw	es:[si]		; ax = version (minor)
	cmp	ax, DRIVER_VERSION_MINOR
	jnz	unsupported_ver
	lodsw	es:[si]		; ax = version (beta)
	cmp	ax, DRIVER_VERSION_BETA
	jnz	unsupported_ver
ENDIF
	;--- ȃf[^̉.
	lodsw	es:[si]
	mov	[n_sources_music], al
	;--- ȏ񕶎ItZbg.
	mov	di, offset title_ptr
	mov	cl, 4
@@:	lodsw	es:[si]
	mov	[di], ax
	add	di, 2
	dec	cl
	jnz	@B
	;--- epȃf[^̃ZOgAhX[h.
	assume	di:ptr SourceInMusic
	mov	di, offset source_list_music
	mov	bx, [_mbuf_seg]
	mov	cl, [n_sources_music]
Lload_seg_addr:
	lodsw	es:[si]
	mov	dx, ax
	lodsw	es:[si]		; ax:dx = ȃf[^̃ItZbg.
	test	dx, 0fh		; 16oCgACg`FbN.
	jz	@F
invalid_data:			; short jmp œ͂悤ɂɔzu.
	mov	ax, TSRERR_INVALID_DATA
	jmp	Lend
@@:	shr	ax, 1
	rcr	dx, 1
	shr	ax, 1
	rcr	dx, 1
	shr	ax, 1
	rcr	dx, 1
	shr	ax, 1
	rcr	dx, 1		; 4rbgEVtg.
	test	ax, ax		; 16rbgɒlcĂȂmF.
	jnz	invalid_data
	add	dx, bx		; dx = ȃf[^JnZOg.
	mov	[di].music_data_seg, dx
	; epȃf[^̐擪̉^Cv[h.
	mov	bp, es		; save es
	mov	es, dx
	mov	ax, word ptr (Header_Source ptr es:[0]).source_type
	mov	[di].type_, al	; (ah, al)=(source_type, flags)
	mov	es, bp
	; 񏉊.
	mov	[di].cont_seg, 0
	; loop tail
	add	di, sizeof(SourceInMusic)
	dec	cl
	jnz	Lload_seg_addr
	assume	di:nothing
	;--- FXg̊񏉊.
	assume	di:ptr Source
	mov	di, offset _sources
	mov	cl, [_n_sources]
	xor	al, al
@@:	mov	[di].flags, al	; 0NA.
	; loop tail
	add	di, sizeof(Source)
	dec	cl
	jnz	@B
	assume	di:nothing
	;--- ȒtO.
	; (ch=Ȓ, cl=[vϐ, di=Ȓ\)
	assume	di:ptr SourceInMusic
	xor	cl, cl
	mov	di, offset source_list_music
	mov	ch, [n_sources_music]
Lsrc_flag_init:
	cmp	cl, ch
	jae	Lsrc_flag_init_end
	mov	[di].sim_flags, SIM_FLAG_INIT_VAL
	add	di, sizeof(SourceInMusic)
	inc	cl
	jmp	Lsrc_flag_init
Lsrc_flag_init_end:
	;--- .
	; (ch,cl)=([v idx), di=ȃf[^̉\, bx=F.
	mov	di, offset source_list_music
	xor	cl, cl
msrc_loop_begin:
; for(msrc_idx = 0; msrc_idx < n_sources_music; ++msrc_idx) {
	cmp	cl, [n_sources_music]
	jnb	msrc_loop_end
	;  for .
	assume	bx:ptr Source
	mov	bx, offset _sources
	xor	ch, ch
src_loop_begin:
; for(src_idx = 0; src_idx < _n_sources; ++src_idx) {
	cmp	ch, [_n_sources]
	jnb	src_loop_end
	test	[bx].flags, SOURCE_FLAG_ASSIGNED
	jnz	src_loop_continue		; ς݂ȂXLbv.
	mov	al, [bx].type_
	cmp	[di].type_, al
	jz	@F				; ̎ނႤȂXLbv.
src_loop_continue:
	add	bx, sizeof(Source)
	inc	ch
	jmp	src_loop_begin
@@:	; s.
	or	[bx].flags, SOURCE_FLAG_ASSIGNED
	mov	ax, [bx].cont_seg
	mov	dx, [bx].cont_data_seg
	mov	[di].cont_seg, ax
	mov	[di].cont_data_seg, dx
	; [h֐Ă(P̂ŌĂԂ̂ call_cont_proc_mall ͎gȂ)
	push	es
	mov	es, ax				; es=R[h̃ZOg.
	mov	[far_call_seg], ax
	mov	ax, (DrvProcTable ptr es:[0]).init_proc
	mov	[far_call_off], ax
	mov	es, [di].music_data_seg
	push	ds
	push	bx
	push	di
	push	cx
	mov	ds, dx
	call	dword ptr cs:[far_call_off]
	pop	cx
	pop	di
	pop	bx
	pop	ds
	pop	es	; src_loop_begin ւ͍sȂ(break )
src_loop_end:
	assume	bx:nothing
; }
	add	di, sizeof(SourceInMusic)
	inc	cl
	jmp	msrc_loop_begin
msrc_loop_end:
	assume	di:nothing
; }	;---
	or	[driver_flags], DRV_FLAG_LOAD_OK ; [h.
	xor	ax, ax
Lend:	pop	bp
	pop	dx
	pop	cx
	pop	di
	pop	si
	pop	es
	jmp	tsr_func_end
tsr_con_01h ENDP


;===========================================
; ^C}̊荞݂ŌĂяo鉉t.
tsr_fm_main_ PROC PUBLIC
IF _DEBUG
	;--- debug rh̏ꍇe̍XV𒼐ڌĂŏI.
	pusha
	push	es
	push	ds
	mov	ax, cs
	mov	ds, ax
	mov	di, PLAY_PROC_OFFSET
	call	call_cont_proc_mall
	pop	ds
	pop	es
	popa
	retf
ENDIF
	pusha
	push	es
	push	ds
	mov	ax, cs
	mov	ds, ax		; ds = TSR_GROUP
IF TARGET EQ TARGET_98
	;--- PC-98 ̏ꍇ EOI M.
	cmp	[_stayed_timer_type], TIMER_TYPE_OPN
	je	Leoi_opn
	call	send_EOI_to_master
	jmp	Leoi_finish
Leoi_opn:
	cmp	[_opn_irq], 8
	jae	@F
	call	send_EOI_to_master
	jmp	L1
@@:	call	send_EOI_to_slave
L1:	;--- OPN(A) ɏ풓Ăꍇ̊mF.
	; MEMO: ̊֐͂łĂ΂Ȃ̂ŁA֐̒gWJĂǂ.
	call	handle_timer_int_opn
	jz	tsr_fm_end
Leoi_finish:
ELSE
	;--- PC/AT ̏ꍇ SB ̊ EOI M or  PIT ďo.
.if([_stayed_timer_type] == TIMER_TYPE_SB)
	; SB ̏ꍇA܂ EOI M.
	cmp	[_sb_irq_idx], 0
	je	@F
	cmp	[_sb_irq_idx], 3
	je	@F
	call	send_EOI_to_master
	jmp	L5
@@:	call	send_EOI_to_slave
L5:	; mF͌󖢎(Iɕʂ̋@\Ȃǉ)
	mov	dx, [_sb_dma_ack_port]
	in	al, dx			; ACK
.else	; PIT ̏ꍇ.
	mov	ax, [orig_timer_int_cnt]
	add	ax, [curr_timer_val]
	inc	ax ; inc ł CF ωȂ.
	jc	L2 ; Ĉꂽ猳̊Ă.
	jz	L2 ;  0ffffh ɂȂ猳̊Ă.
	dec	ax ; : jc ̉ӏAꂽꍇ ax -= 0ffffh Kv,
	jmp	L3 ;     inc ax ł.
L2:	or	[driver_flags], DRV_FLAG_CHAIN_ORIG_VEC
L3:	mov	[orig_timer_int_cnt], ax
	call	send_EOI_to_master
.endif
ENDIF
	;--- ēh~`FbN.
	test	[driver_flags], DRV_FLAG_IN_FM_TSR
	jnz	tsr_fm_end
	;--- ~yшꎞ~ǂ`FbN.
	mov	al, [play_status]
	cmp	al, PLST_STOP
	jz	tsr_fm_end
	cmp	al, PLST_PAUSE
	jz	tsr_fm_end
	;--- Đ.
	or	[driver_flags], DRV_FLAG_IN_FM_TSR
	sti			; 犄.
	;--- Đԃ`FbN (al=play_status)
	cmp	al, PLST_PLAYING
	jz	Lplay
	;  PLST_STOP_REQ  PLST_PAUSE_REQ m.
IF TARGET EQ TARGET_98
.if ([_stayed_timer_type] == TIMER_TYPE_OPN)
	call	stop_int_timer_opn
.endif
ENDIF
	mov	di, MUTE_PROC_OFFSET
	call	call_cont_proc_mall		; Sp[g~[g.
	; Xe[^X.
	cmp	[play_status], PLST_PAUSE_REQ
	jz	Lpause
	mov	[play_status], PLST_STOP
	jmp	tsr_fm_and_end
Lpause:	mov	[play_status], PLST_PAUSE
	jmp	tsr_fm_and_end
Lplay:	;--- EFCg񐔊mF.
	mov	ax, word ptr [timer_wait_cnt] ; al=cnt, ah=n_wait
	cmp	al, ah
	jae	@F
	inc	al
	mov	[timer_wait_cnt], al
	jmp	tsr_fm_and_end
@@:	mov	[timer_wait_cnt], 0
	;--- e̍XVĂяo.
	mov	di, PLAY_PROC_OFFSET
	call	call_cont_proc_mall
	;--- ^C}ݒlXV`FbN.
	; MEMO: ďo͕ςȂ̂ŏ풓Ɏȏɂ̂.
	xor	bx, bx
	mov	bl, [_stayed_timer_type]
	add	bx, bx				; word access
	call	[TIMER_VAL_UPDATER_TBL + bx]
	;--- n.
tsr_fm_and_end:
	cli
	and	[driver_flags], NOT DRV_FLAG_IN_FM_TSR
tsr_fm_end:
IF TARGET EQ TARGET_98
	pop	ds
	pop	es
	popa
	iret
ELSE
	test	[driver_flags], DRV_FLAG_CHAIN_ORIG_VEC
	jz	@F
	and	[driver_flags], NOT DRV_FLAG_CHAIN_ORIG_VEC
	pop	ds
	pop	es
	popa
	jmp	dword ptr cs:[_fm_orig_vec]	; vector chain
@@:	pop	ds
	pop	es
	popa
	iret
ENDIF
tsr_fm_main_ ENDP


;-------------------------------------------
;  OPN(A)  timer_b mFAtO̓K؂ȑs.
; : .
; ߒl: ZF=(0=timer_b ł, 1=timer_b łȂ)
; j: ax, dx, cx
IF TARGET EQ TARGET_98
handle_timer_int_opn PROC PRIVATE
	mov	cl, 00001010b	;  OPN(A) 27h ɏޒl(timer_a  off)
	mov	dx, [_opn_addr]
	in	al, dx
	mov	ch, al		; save status
	test	al, 01h		; check tiemr_a
	jz	@F
	or	cl, 10h		; RESET(timer_a) = 1
@@:	test	al, 02h		; check tiemr_b
	jz	@F
	or	cl, 20h		; RESET(timer_b) = 1
@@:	mov	ah, cl
	mov	al, 27h
	WRITE_TIMER_OPN_AX	; reset timer
	test	ch, 02h
	ret
handle_timer_int_opn ENDP
ENDIF


;-------------------------------------------
; EOI M.
; , ߒl, .
; j: al
; master ւ EOI ǒ wait Ȃ̂Œ.
send_EOI_to_slave PROC PRIVATE
	mov	al, 20h
	out	IOPORT_PIC_S_OCW2, al	; send EOI to slave
	IO_WAIT	2
	mov	al, 0bh
	out	IOPORT_PIC_S_OCW2, al	; ISR read mode set (slave)
	IO_WAIT	2
	in	al, IOPORT_PIC_S_OCW2
	test	al, al			; slave PIC in-service?
	jne	@F
send_EOI_to_master::
	mov	al, 20h
	out	IOPORT_PIC_M_OCW2, al	; send EOI to master
@@:	ret
send_EOI_to_slave ENDP


;-------------------------------------------
; ^C}S OPN(A) ɒl.
; : (ah,al)=(ޒl,AhX)
; ߒl: .
; j: ax, dx
IF TARGET EQ TARGET_98
tsr_write_timer_opn PROC PRIVATE
	push	cx
	;--- write address
	mov	dx, [_opn_addr]
	out	dx, al
	mov	cx, [_opn_wait]
	loop	$
	;--- write data
	mov	al, ah
	mov	dx, [_opn_data]
	out	dx, al
	mov	cx, [_opn_wait]
	loop	$
	;---
	pop	cx
	ret
tsr_write_timer_opn ENDP
ENDIF

; tJn OPN(A) ̃^C}ݒ菈.
; : .
; ߒl: .
; j: ax, dx
IF TARGET EQ TARGET_98
start_int_timer_opn PROC PRIVATE
	mov	ax, TIMER_B_INIT_VAL
	mov	[new_timer_b_val], ax
	mov	[curr_timer_val], ax
	mov	ah, al
	mov	al, 26h
	WRITE_TIMER_OPN_AX
	WRITE_TIMER_OPN		27h, 00111010b
	ret
start_int_timer_opn ENDP

; ^C}S OPN(A) ̃^C}~.
; : .
; ߒl: .
; j: ax, dx
stop_int_timer_opn PROC PRIVATE
	WRITE_TIMER_OPN	27h, 30h
	ret
stop_int_timer_opn ENDP

; ^C}S OPN(A)  timer_b lXV.
; : .
; ߒl: .
; j: ax, dx
update_timer_val_opn PROC PRIVATE
	mov	ax, [new_timer_b_val]
	cmp	ax, [curr_timer_val]
	je	@F
	mov	ah, al
	mov	al, 26h
	WRITE_TIMER_OPN_AX
	WRITE_TIMER_OPN		27h, 00001010b	; LOAD=1, ENABLE=1 (timer_b)
@@:	ret
update_timer_val_opn ENDP
ENDIF

; tJn PIT ^C}ݒ菈.
; : .
; ߒl: .
; j: ax, dx
IF TARGET EQ TARGET_98
start_int_timer_8m:
	mov	ax, PIT_8M_INIT_VAL
	mov	[new_timer_8m_val], ax
	jmp	LL1
start_int_timer_5m:
	mov	ax, PIT_5M_INIT_VAL
	mov	[new_timer_5m_val], ax
LL1:	mov	[curr_timer_val], ax
	jmp	set_int_timer_pit
ELSE
start_int_timer_pc_at:
	mov	ax, PIT_PC_AT_INIT_VAL
	mov	[new_timer_pc_at_val], ax
	mov	[curr_timer_val], ax
	jmp	set_int_timer_pit
ENDIF

; e|ύX PIT ^C}ݒ菈.
; : .
; ߒl: .
; j: ax, dx
IF TARGET EQ TARGET_98
update_timer_val_8m:
	mov	ax, [new_timer_8m_val]
	cmp	ax, [curr_timer_val]
	jz	LL3
	jmp	set_int_timer_pit
LL3:	ret
update_timer_val_5m:
	mov	ax, [new_timer_5m_val]
	cmp	ax, [curr_timer_val]
	jz	LL3
	; set_int_timer_pit ɗꗎ.
ELSE
update_timer_val_pc_at:
	mov	ax, [new_timer_pc_at_val]
	cmp	ax, [curr_timer_val]
	jnz	set_int_timer_pit
	ret
ENDIF

; PIT ^C}JEglݒ菈.
; : ax=ݒl(16bit)
; ߒl: .
; j: ax, dx
; curr_timer_val ւ̐ݒōs.
; Ō PIT ւ݂̏̌ wait Ȃ̂Œ.
set_int_timer_pit PROC PRIVATE
	mov	[curr_timer_val], ax
	mov	dx, ax			; save counter value
	cli
	; JE^0 `g[hœ(16bit l)
	mov	al, 36h
	out	IOPORT_PIT_CW, al
	IO_WAIT	2
	mov	al, dl		; .
	out	IOPORT_PIT_CNT0, al
	IO_WAIT	2
	mov	al, dh		; .
	out	IOPORT_PIT_CNT0, al
	sti
	ret
set_int_timer_pit ENDP

IF TARGET EQ TARGET_PC
; SB DSP ݊֐.
; : ah=ޒl, dx=SB write port
; ߒl: .
; j: .
write_to_sb_dsp PROC PRIVATE
@@:	in	al, dx
	test	al, al
	js	@B
	mov	al, ah
	out	dx, al
	ret
write_to_sb_dsp ENDP

; tJn SB DMA ݒ菈.
; : .
; ߒl: .
; j: ax, dx
start_int_timer_sb PROC PRIVATE
	mov	[new_timer_sb_val], SB_TIME_CONST_INIT_VAL
	mov	[timer_sb_n_samples], SB_XFER_COUNT_INIT_VAL
	mov	[new_timer_n_wait], SB_N_WAIT_INIT_VAL
	; update_timer_val_sb ɗꗎ.
start_int_timer_sb ENDP

; e|ύX SB DMA ݒ菈.
; : .
; ߒl: .
; j: ax, dx
; new_timer_sb_val ɍXVΑ̃p[^SXV.
update_timer_val_sb PROC PRIVATE
	mov	ax, [new_timer_sb_val]
	cmp	ax, [curr_timer_val]
	je	L1
	mov	[curr_timer_val], ax
	mov	dx, [_sb_write_port]
	mov	ah, 40h
	call	write_to_sb_dsp
	mov	ah, byte ptr [curr_timer_val]
	call	write_to_sb_dsp
	mov	ah, 48h
	call	write_to_sb_dsp
	mov	ah, [timer_sb_n_samples]
	call	write_to_sb_dsp
	xor	ah, ah
	call	write_to_sb_dsp
	mov	ah, 1ch
	call	write_to_sb_dsp
	; 肵ĕ򂷂薳ɃRs[.
	mov	al, [new_timer_n_wait]
	mov	[timer_n_wait], al
L1:	ret
update_timer_val_sb ENDP
ENDIF

;-------------------------------------------
; music_query_proc ďőʉ.
; : dl=query, ds:bx=ďoΏۂ̋Ȓ\̂̃AhX.
; ߒl: query , ds=cs
; j: ax, es
; ds=cs ƂĂ̂ TSR_GROUP ̌ĂяoOƂĂ邽.
call_music_query_proc PROC PRIVATE
	assume	bx:ptr SourceInMusic
	mov	es, [bx].cont_seg
	mov	[far_call_seg], es
	mov	ax, (DrvProcTable ptr es:[0]).music_query_proc
	mov	[far_call_off], ax
	mov	es, [bx].music_data_seg
	mov	ds, [bx].cont_data_seg
	push	bx
	call	dword ptr cs:[far_call_off]
	pop	bx
	push	cs
	pop	ds	; ds=cs
	ret
	assume	bx:nothing
call_music_query_proc ENDP

;-------------------------------------------
; Ȓ̊eɑ΂ď֐Ăяo.
; : di=Ăяo֐ DrvProcTable ̃ItZbg.
; ߒl: .
; j: ax, dx, bx, cx, es
; Ăяoꂽ̏.
; Eds=̈̃ZOgAhX.
; Ees=ȃf[^̂ZOgAhX.
; EĂяo֐Ŕj\Ȃ̂ ax, dx, cx, bx, di, ds, es
; Ej󂳂邱Ƃɑ΂Ă̊֐Ŗ΍Ȃ̂ si, bp
; call_cont_proc_all ƊԈႦȂ悤ɒ.
call_cont_proc_mall PROC PRIVATE
	assume	bx:ptr SourceInMusic
	mov	bx, offset [source_list_music]
	mov	cl, [n_sources_music]
call_loop:
	mov	ax, [bx].cont_seg
	test	ax, ax
	jz	skip_call
	; Ăяo.
	push	ds
	mov	[ccp_save_cx], cx
	mov	[ccp_save_bx], bx
	mov	[ccp_save_di], di
	mov	[far_call_seg], ax
	mov	cx, [bx].music_data_seg
	mov	dx, [bx].cont_data_seg	; ds ̂ŐɃ[h.
	mov	ds, ax
	mov	es, cx
	mov	ax, word ptr (DrvProcTable ptr ds:[di])
	mov	cs:[far_call_off], ax	; ł ds ύXς݂Ȃ̂ŗv cs
	mov	ds, dx
	call	dword ptr cs:[far_call_off]
	pop	ds
	mov	cx, [ccp_save_cx]
	mov	bx, [ccp_save_bx]
	mov	di, [ccp_save_di]
skip_call:
	add	bx, sizeof(SourceInMusic)
	dec	cl
	jnz	call_loop
	assume	bx:nothing
	ret
call_cont_proc_mall ENDP


;-------------------------------------------
; ꂽeɑ΂ď֐Ăяo.
; : di=Ăяo֐ DrvProcTable ̃ItZbg.
; ߒl: .
; j: ax, bx, cx, dx, es
; Ăяoꂽ̏.
; Eds=̈̃ZOgAhX.
; Ees=m(֐ɂĂ es mƌĂׂȂ̂Œ)
; EĂяo֐Ŕj\Ȃ̂ ax, dx, cx, bx, di, ds, es
; Ej󂳂邱Ƃɑ΂Ă̊֐Ŗ΍Ȃ̂ si, bp
; call_cont_proc_mall ƊԈႦȂ悤ɒ.
call_cont_proc_all PROC PRIVATE
	assume	bx:ptr Source
	mov	bx, offset [_sources]
	mov	cl, [_n_sources]
call_loop:
	mov	ax, [bx].cont_seg
	test	ax, ax
	jz	skip_call
	mov	[ccp_save_cx], cx
	mov	[ccp_save_bx], bx
	mov	[ccp_save_di], di
	mov	[far_call_seg], ax
	mov	es, ax
	mov	ax, word ptr (DrvProcTable ptr es:[di])
	mov	[far_call_off], ax
	push	ds
	mov	ds, [bx].cont_data_seg
	call	dword ptr cs:[far_call_off]
	pop	ds
	mov	cx, [ccp_save_cx]
	mov	bx, [ccp_save_bx]
	mov	di, [ccp_save_di]
skip_call:
	add	bx, sizeof(Source)
	dec	cl
	jnz	call_loop
	assume	bx:nothing
	ret
call_cont_proc_all ENDP
; ꂽeɑ΂ď֐Ăяo(ʃZOgĂԎp)
; : di=Ăяo֐ DrvProcTable ̃ItZbg.
; ߒl: ; j: ax, bx, cx, dx, ds, es
call_cont_proc_all_far PROC PUBLIC
	push	cs
	pop	ds			; ds = cs
	call	call_cont_proc_all
	retf
call_cont_proc_all_far ENDP

;-------------------------------------------
; 풓̍ŏIyя풓Is.
; ̓Iɂ́Aȉ2ނ̏Y.
; Ë鏈.
; Ë̒l𗘗pĎs鏈.
; ̈̏ɂA풓͈͂̃f[^邽.
; ̃[`͏풓͈͂ɎĂ.
; : .
; ߒl: .
final_setup_and_exit_ PROC PUBLIC
	push	cs
	pop	ds			; ds = cs
	;--- ŏI[v.
	mov	dl, [_n_sources]
	mov	bx, offset [_sources]
	assume	bx:ptr Source
	assume	di:ptr DriverParam
	; DriverParam ݒ.
@@:	mov	es, [bx].cont_data_seg
	xor	di, di			; es:[0]  DriverParam .
	mov	al, [bx].type_
	mov	es:[di].type_, al
	mov	es:[di].tsr_group_seg, cs
	lea	di, [di].ioport
	lea	si, [bx].ioport
	mov	cx, sizeof(IOPort) / 2
	rep	movsw			; IOPort ̃Rs[.
	add	bx, sizeof(Source)
	dec	dl
	jnz	@B
	assume	di:nothing
	assume	bx:nothing
	;--- ֐ďo.
	mov	di, FIN_PROC_OFFSET
	call	call_cont_proc_all
	;--- ~[g֐ďo.
	mov	di, MUTE_PROC_OFFSET
	call	call_cont_proc_all
	;--- 풓ďI.
	mov	dx, [_remain_parasz]
	mov	ax, 3100h
	int	21h
final_setup_and_exit_ ENDP

_TSR_TEXT ENDS


;-------------------------------------------
; 풓ɒuR[h.
; tsr.asm Œ`萔g̗RΓKXŎ.
DGROUP GROUP CONST2

CONST2 SEGMENT PUBLIC USE16 'DATA'
start_addr_reg_tbl dw 00h, 02h, 04h, 06h
count_reg_tbl dw 01h, 03h, 05h, 07h
page_addr_reg_tbl dw 87h, 83h, 81h, 82h
CONST2 ENDS

_TEXT SEGMENT PUBLIC USE16 'CODE'
	ASSUME	cs:_TEXT, ds:DGROUP, ss:DGROUP

IF TARGET EQ TARGET_PC
;--- void mask_dma(uint8_t dma_channel)
; : al=DMA ̃`l(0, 1, 3 ̉ꂩ)
; ߒl: .
mask_sb_dma_ PROC
	cmp	al, 4
	jb	@F
	ret
@@:	cmp	al, 2
	jnz	@F
	ret
@@:	;---
	or	al, 04h			; MSAK_ON=1
	out	0ah, al			; mask DMA
	ret
mask_sb_dma_ ENDP

;--- uint16_t setup_sb_dma(uint8_t dma_channel)
; : al=DMA ̃`l(0, 1, 3 ̉ꂩ)
; ߒl: (0: , 0: s)
; SB p DMA obt@̏s.
setup_sb_dma_ PROC
	push	es
	push	bx
	push	cx
	push	dx
	;--- `FbN.
	cmp	al, 4
	jae	Lfail
	cmp	al, 2
	jz	Lfail
	xor	bx, bx
	mov	bl, al			; save DMA channel
	;---
	xor	cx, cx
	mov	ax, TSR_GROUP
	mov	es, ax
	assume	es:TSR_GROUP
REPEAT	4
	shl	ax, 1
	rcl	cx, 1
ENDM
	; cx:ax=(ZOg << 4)
	add	ax, offset TSR_GROUP:sb_dma_buf
	adc	cx, 0
	; wrap around `FbN.
	test	cx, 0fff0h
	jnz	Lfail
	; 64KiB E`FbN.
	add	ax, 32 - 1
.if(!carry?)
	; Jオ薳Ȃ sb_dma_buf 擪g.
	sub	ax, 32 - 1
.else
	; Jオ sb_dma_buf  64KiB ÊƂ납g.
	inc	cl
	xor	ax, ax
.endif
	mov	es:[sb_dma_base_addr], ax
	mov	es:[sb_dma_page_addr], cl
	;--- DMA ̐ݒ.
	mov	al, bl			; al=DMA channel
	mov	ch, bl			; save DMA channel
	add	bx, bx			; word access
	or	al, 04h			; MSAK_ON=1
	out	0ah, al			; mask DMA
	; start addr
	out	0ch, al			; clear flip-flop
	mov	ax, es:[sb_dma_base_addr]
	mov	dx, [start_addr_reg_tbl + bx]
	out	dx, al
	mov	al, ah
	out	dx, al			; start addr
	; count
	out	0ch, al			; clear flip-flop
	mov	dx, [count_reg_tbl + bx]
	mov	es:[dmac_cnt_port], dx
	mov	al, 32 - 1
	out	dx, al
	xor	al, al
	out	dx, al			; ]oCg=32 (Őݒ)
	mov	dx, [page_addr_reg_tbl + bx]
	mov	al, cl
	out	dx, al			; page addr
	; mode
	mov	al, ch
	or	al, 01011000b		; mem to io, auto-init, single xfer
	out	0bh, al
	mov	al, ch			; al=DMA channel
	out	0ah, al			; clear mask
	;---
	mov	ax, 1
@@:	pop	dx
	pop	cx
	pop	bx
	pop	es
	assume	es:nothing
	ret
Lfail:	xor	ax, ax
	jmp	@B
setup_sb_dma_ ENDP
ENDIF ; TARGET EQ TARGET_PC

_TEXT ENDS


END
