;--------------------------------------------------------
; N2KD FM Driver version 1.0a (beta 2b)
; tsr_opl3.asm
; Copyright (C) 2021-2026 Y. Shiokami
; Released under the 3-clause BSD License.
;--------------------------------------------------------

.186
.model small

include common.inc

PUBLIC tsr_opl3_tail
PUBLIC data_opl3_tail, data_opl2_tail

EXTERN	new_timer_b_val:word,
	new_timer_5m_val:word,
	new_timer_8m_val:word,
	new_timer_pc_at_val:word,
	new_timer_sb_val:word,
	new_timer_n_wait:byte,
	timer_sb_n_samples:byte

; fobOpw}N.
TSR_OPL3_PROC_VISIBILITY equ PRIVATE

;==========================================================
; \̂萔.
;----------------------------------------------------------
; ȃf[^wb_.
OPL3DataHeader STRUCT
	type_			db ?
	data_flags		db ?
	voice_data_offset	dw 2 dup(?)
	part_data_offset	dw n_parts_OPL3 dup(?)
	csm_param_offset	dw ?
OPL3DataHeader ENDS

OPL3PartStatus STRUCT
	play_ptr		dw ?
	voice_data		dw ?
	detune			dw ?
	fine_detune		dw ?
	part_flags		dw ?
	loop_start_pos		dw ?
	repeat_idx		dw ?
	fnum_blk_store		dw N_FNUM_BLK_STORE dup(?)
	repeat_start_ptr	dw REPEAT_NEST_MAX dup(?)
	repeat_end_ptr		dw REPEAT_NEST_MAX dup(?)
	repeat_counter		db REPEAT_NEST_MAX dup(?)
	keyon_ksl_tl_val	db 2 dup(?)
	curr_ksl_tl_val		db 2 dup(?)
	main_counter		db ?
	keyoff_timing		db ?
	kon_val			db ?
	volume			db ?
	tie_status		db ?
	gate_uQ			db ?
	gate_lq			db ?
	note_op			db ?
	panpot_val		db ?
		EVEN
	lfo			LFOStatus N_LFO dup({})
	portament		Portament {}
OPL3PartStatus ENDS
IF sizeof(OPL3PartStatus) MOD 2 NE 0
	.err <sizeof OPL3PartStatus is odd.>
ENDIF
CURR_KSL_TL_OFFSET equ 2 ; keyon_ksl_tl_val  curr_ksl_tl_val ̋.

OPL3_PART_FLAG_FINISHED	equ 01h

BASE_AM_VIB_EGT_KSR_ML	equ  20h
BASE_KSL_TL		equ  40h
BASE_AR_DR		equ  60h
BASE_SL_RR		equ  80h
BASE_F_NUM_L		equ 0a0h
BASE_KON_BLK_FNUM_H	equ 0b0h
BASE_CHDCBA_FB_CNT	equ 0c0h
BASE_WS			equ 0e0h

; part_stats[part_idx + 3] 𓾂鎞Ɏg萔(L͗)
;	mov	di, si
;	add	di, THREE_NEXT_ADDEND
THREE_NEXT_ADDEND 	equ sizeof(OPL3PartStatus) * 3

; hCotO.
DRV_FLAG_OPL3_HAS_A1	equ 01h ; A1 |[g(WX^)Ă邩.

; 񏉊̃tOl.
DRV_FLAG_OPL3_INIT_OPL3	equ 01h
DRV_FLAG_OPL3_INIT_OPL2	equ 00h
; tÕtOp mask
DRV_FLAG_OPL3_INIT_AND_MASK	equ 01h
DRV_FLAG_OPL3_INIT_OR_MASK	equ 00h

; 4OP ֘AtO.
I4O_4OP		equ 01h
I4O_4OP_SHITA	equ 02h
I4O_2OP_VOICE	equ 04h ; OP_SELECT_VOICE Ŏgp.

OPL3_VOL_MAX	equ 3fh


;==========================================================
; 풓f[^.
;----------------------------------------------------------
; ۂ 0000h ɏoł͂Ȃ.
; oCiɃZOgo͂Ȃ@ȊOȂ.
; p[gȊO OPL, OPL2, OPL3 ɂ炸ʂ̃f[^\Ƃ.
; 啶͉tɂ͕ωȂl̈.
_TSR_OPL3_DATA SEGMENT PARA USE16 AT 0000h
driver_param		DriverParam {}
voice_buf		dw ?
drum_voice_buf		dw ?
opl3_write_proc		dw ?
part_idx		dw ?	; |C^ƂĎĝ word TCY.
status_addr		dw ?
lfo_val_volumes		dw 4 dup(?)
lfo_val_tune		dw ?
pi_mod9			db ?
pi_mod9_A1_3		db ?
base_addend		db ?
base_addend_3		db ?
is_4op_flags		db ?
lfo_on_flags		db ?
;base_addends		db (n_parts_OPL3 / 2) dup(?)
n_parts			db ?
driver_flags		db ?
connection_sel		db 7 dup(?)
	EVEN
parts			OPL3PartStatus n_parts_OPL2 dup({})
data_opl2_tail:
			OPL3PartStatus n_parts_OPL2 dup({})
data_opl3_tail:
_TSR_OPL3_DATA ENDS


;==========================================================
; 풓R[h.
;----------------------------------------------------------
_TSR_OPL3_TEXT SEGMENT PARA PUBLIC USE16 'TSR_OPL3_CODE'
	assume	cs:_TSR_OPL3_TEXT, ds:_TSR_OPL3_DATA

; ֐ItZbge[u.
proc_tbl DrvProcTable { offset init_proc,
			offset play_proc,
			offset mute_proc,
			offset fin_proc,
			offset music_query_proc,
			0 }

; LFO Xe[^XzItZbge[u.
lfo_offset_tbl:
	@LFO_OFFSET_IDX = 0
	REPEAT N_LFO
		dw sizeof(LFOStatus) * @LFO_OFFSET_IDX
		@LFO_OFFSET_IDX = @LFO_OFFSET_IDX + 1
	ENDM

; tߏ̃Wve[u.
  ; 0x00, 0x01
TBL_OP_PROC dw	offset proc_nop, offset proc_select_voice,
  ; 0x02, 0x03, 0x04
  offset proc_rest, offset proc_play_end, offset proc_set_volume,
  ; 0x05, 0x06, 0x07
  offset proc_repeat_start, offset proc_repeat_escape, offset proc_repeat_end,
  ; 0x08, 0x09, 0x0a
  offset proc_direct_out, offset proc_nop, offset proc_nop,
  ; 0x0b, 0x0c, 0x0d
  offset proc_gate_hQ, offset proc_gate_lq, proc_detune,
  ; 0x0e, 0x0f, 0x10
  offset proc_lfo_set_param, offset proc_lfo_set_wave, offset proc_lfo_switch,
  ; 0x11;, 0x12, 0x13
  offset proc_change_volume, offset proc_set_panpot, offset proc_portament,
  ; 0x14, 0x15
  offset proc_loop_start_pos, offset proc_set_timer_b
  ; 0x16, 0x17, 0x18
dw offset proc_hw_lfo_set_param, offset proc_set_lfo_op, proc_fine_detune,
  ; 0x19
  offset proc_set_fnum_blk

; fnum vZpe[u.
fnum12_u16_det0 dw 345, 365, 387, 410, 435, 460, 488, 517, 547, 580, 615, 651
conv_12_ocs_pos dw 0, 85, 171, 256, 341, 427, 512, 597, 683, 768, 853, 939
fnum_ocs_u16	dw 5638h, 581bh, 5a09h, 5c02h, 5e06h, 6015h, 6230h, 6456h,
		   6688h, 68c7h, 6b12h, 6d6bh, 6fd0h, 7243h, 74c3h, 7752h,
		   79efh, 7c9ah, 7f55h, 821fh, 84f8h, 87e1h, 8adbh, 8de5h,
		   9101h, 942eh, 976ch, 9abdh, 9e21h, 0a197h, 0a521h, 0a8beh
coeff_ons_fracp_u16 dw 0000h, 02c6h, 058dh, 0854h, 0b1bh, 0de3h, 10abh, 1374h,
		       163eh, 1908h, 1bd2h, 1e9dh, 2168h, 2434h, 2700h, 29cdh,
		       2c9ah, 2f68h, 3236h, 3505h, 37d4h, 3aa4h, 3d74h, 4045h,
		       4316h, 45e8h, 48bah, 4b8ch, 4e5fh, 5133h, 5407h, 56dch

; LFO ̔g`ŗL̍XV֐e[u.
TBL_LFO_UPDATE_SUBPROC dw offset update_triangle, offset update_oneshot

base_addends	db 00h, 01h, 02h, 08h, 09h, 0ah, 10h, 11h, 12h

;----------------------------------------------------------
; OPL3 WX^݊֌W.
;----------------------------------------------------------
; l݃}N.
WRITE_OPL3_A0_IMM MACRO addr, val
	SET_WRITE_ARG	(addr), (val)
	call	write_opl3_A0
ENDM
WRITE_OPL3_A1_IMM MACRO addr, val
	SET_WRITE_ARG	(addr), (val)
	call	write_opl3_A1
ENDM
; ax ݃}N.
WRITE_OPL3_A0_AX MACRO
	call	write_opl3_A0
ENDM
WRITE_OPL3_A1_AX MACRO
	call	write_opl3_A1
ENDM

; ݌ҋ@}N.
WAIT_OPL3 MACRO
	push	cx
	mov	cx, [driver_param].ioport.wait_
	loop	$
	pop	cx
ENDM

;-------------------------------------------
; RS-232C ʃ[`.
IF _DEBUG
include tsr_rs.inc
ENDIF

;-------------------------------------------
; OPL3 WX^݊֐.
; : (ah,al)=(ޒl,AhX)
; ߒl: .
; j: ax, dx
write_opl3_A0 PROC TSR_OPL3_PROC_VISIBILITY
IF _DEBUG
	mov	dx, ax		; save ax
	mov	al, '['
	call	send_com_ch	; [
	mov	al, dl
	call	send_com_al	; (al)
	mov	al, ','
	call	send_com_ch	; ,
	mov	al, '0'
	call	send_com_ch	; 0
	mov	al, ','
	call	send_com_ch	; ,
	mov	al, dh
	call	send_com_al	; (ah)
	mov	al, ']'
	call	send_com_ch	; ]
	mov	ax, dx		; restore ax
ENDIF
	mov	dx, [driver_param].ioport.addr0
	out	dx, al
	WAIT_OPL3
	mov	dx, [driver_param].ioport.data0
	mov	al, ah
	out	dx, al
	WAIT_OPL3
	ret
write_opl3_A0 ENDP
write_opl3_A1 PROC TSR_OPL3_PROC_VISIBILITY
IF _DEBUG
	mov	dx, ax		; save ax
	mov	al, '['
	call	send_com_ch	; [
	mov	al, dl
	call	send_com_al	; (al)
	mov	al, ','
	call	send_com_ch	; ,
	mov	al, '1'
	call	send_com_ch	; 1
	mov	al, ','
	call	send_com_ch	; ,
	mov	al, dh
	call	send_com_al	; (ah)
	mov	al, ']'
	call	send_com_ch	; ]
	mov	ax, dx		; restore ax
ENDIF
	mov	dx, [driver_param].ioport.addr1
	out	dx, al
	WAIT_OPL3
	mov	dx, [driver_param].ioport.data1
	mov	al, ah
	out	dx, al
	WAIT_OPL3
	ret
write_opl3_A1 ENDP


;-------------------------------------------
; ȃf[^擾.
; dl DrvProcTable ̐Q.
music_query_proc PROC PRIVATE
	; pNG͌ݎ.
;	test	dl, dl
;	jns	@F
	;--- pNG.
;	retf
	;--- OpNG.
@@:	xor	bx, bx
	assume	bx:ptr OPL3DataHeader	; es:[bx]=ȃf[^wb_.
	cmp	dl, MUSIC_QUERY_DATA_FLAG
	jnz	Lret
	mov	dl, es:[bx].data_flags
Lret:	retf
	assume	bx:nothing
music_query_proc ENDP


;-------------------------------------------
; 풓̍ŏI.
; dl DrvProcTable ̐Q.
fin_proc PROC PRIVATE
	mov	al, (DriverParam ptr ds:[0]).type_
.if(al == SRC_TYPE_OPL3)
	mov	dh, N_PARTS_OPL3
	mov	al, DRV_FLAG_OPL3_INIT_OPL3
.elseif(al == SRC_TYPE_OPL2)
	mov	dh, N_PARTS_OPL2
	mov	al, DRV_FLAG_OPL3_INIT_OPL2
.endif
	mov	[n_parts], dh
	mov	[driver_flags], al
	retf
fin_proc ENDP


;-------------------------------------------
; ĐỎyѐ̏Ƌȃ[h.
; dl DrvProcTable ̐Q.
init_proc PROC PRIVATE
	;--- OPL3 ݒ.
	WRITE_OPL3_A0_IMM 04h, 0e0h	; reset int, mask int, stop timer
	WRITE_OPL3_A1_IMM 05h, 01h	; NEW=1
	WRITE_OPL3_A0_IMM 0bdh, 00h	; RHY=0
	WRITE_OPL3_A1_IMM 04h, 00h	; CONNECTION_SEL=0
	WRITE_OPL3_A0_IMM 08h, 00h	; NTS=0
	call	mute_proc_near		; S TL=63
	;--- S KON=0 (fnum, blk ͔j󂳂)
	mov	bl, [driver_flags]
	mov	cl, 0b0h
.while(cl <= 0b8h)
	mov	al, cl
	xor	ah, ah
	WRITE_OPL3_A0_AX
	test	bl, DRV_FLAG_OPL3_HAS_A1
	jz	@F			; A1 |[g.
	mov	al, cl
	xor	ah, ah
	WRITE_OPL3_A1_AX
@@:	inc	cl
.endw
	;--- S AR=0 (Fw莞̃L[Ił̔h~,  DR=0 ɂȂ)
	mov	cl, 60h
.while(cl <= 75h)
	;.if(cl != 66h && cl != 67h && cl != 6eh && cl != 6fh)
	mov	al, cl
	and	al, 07h
	cmp	al, 6
	jae	@F
	mov	al, cl
	xor	ah, ah
	WRITE_OPL3_A0_AX
	test	bl, DRV_FLAG_OPL3_HAS_A1
	jz	@F			; A1 |[g.
	mov	al, cl
	xor	ah, ah
	WRITE_OPL3_A1_AX
@@:	inc	cl
.endw
	;--- hCoʐ̏ (bl=driver_flags)
	mov	al, bl	; bl ̂܂܂ al ŌvZ1oCg.
	and	al, DRV_FLAG_OPL3_INIT_AND_MASK
	or	al, DRV_FLAG_OPL3_INIT_OR_MASK
	mov	[driver_flags], al
	xor	bx, bx
	assume	bx:ptr OPL3DataHeader	; es:[bx]=ȃf[^wb_.
	mov	dl, al			; dl=driver_flags
	xor	ax, ax
	mov	word ptr [connection_sel + 0], ax
	mov	word ptr [connection_sel + 2], ax
	mov	word ptr [connection_sel + 4], ax
	mov	[connection_sel + 6], al
	mov	[voice_buf], ax
	mov	[drum_voice_buf], ax
	mov	cx, es:[bx].voice_data_offset[0]
.if(cx)
	mov	[voice_buf], cx
.endif
	mov	cx, es:[bx].voice_data_offset[2]
.if(cx)
	mov	[drum_voice_buf], cx
.endif
	assume	bx:nothing
	;--- ep[g̐̏ (ax=0, dl=driver_flags)
	; TODO: OPL3 ȊŐȃf[^wb_ǂލۂ̗̌ǂl.
	; 0 (sizeof(OPL3PartStatus) ͋Ȃ̂ŎO2Ŋ؂)
	mov	cx, sizeof(OPL3PartStatus) / 2 * (n_parts_OPL3 / 2)
	test	dl, DRV_FLAG_OPL3_HAS_A1
	jz	@F
	add	cx, sizeof(OPL3PartStatus) / 2 * (n_parts_OPL3 / 2)
@@:	mov	bx, es			; save es
	mov	di, ds
	mov	es, di
	mov	di, offset parts
	pushf
	cld
	rep	stosw
	popf
	mov	es, bx			; restore es
	; 0ȕ̐ݒ.
	xor	bx, bx
	assume	bx:ptr OPL3DataHeader	; es:[bx]=ȃf[^wb_.
	mov	di, offset parts
	assume	di:ptr OPL3PartStatus
	xor	cx, cx
part_init_loop:
	mov	dx, di			; save di
	mov	di, cx
	add	di, di			; word access
	mov	ax, es:[bx].part_data_offset[di]
	mov	di, dx			; restore di
.if(ax)
	mov	[di].play_ptr, ax
.else
	or	[di].part_flags, OPL3_PART_FLAG_FINISHED
.endif
	mov	[di].keyoff_timing, 1	; t[vł̖ʂȃL[Ith~.
	mov	[di].repeat_idx, -1
	mov	[di].panpot_val, 30h	; .

	add	di, sizeof(OPL3PartStatus)
	inc	cx
	cmp	cl, [n_parts]
	jb	part_init_loop
	assume	di:nothing
	assume	bx:nothing
	retf
init_proc ENDP


;-------------------------------------------
; S`lɂ({)
; , ߒl: .
; j: ax, dx, cx, bl
mute_proc_near PROC PRIVATE
	mov	bl, [driver_flags]
	mov	cl, 40h
.while(cl <= 55h)
	;.if(cl != 46h && cl != 47h && cl != 4eh && cl != 4fh)
	mov	al, cl
	and	al, 07h
	cmp	al, 6
	jae	skip_write
	mov	al, cl
	mov	ah, 3fh
	call	write_opl3_A0
	test	bl, DRV_FLAG_OPL3_HAS_A1
	jz	skip_write		; A1 |[g.
	mov	al, cl
	mov	ah, 3fh
	call	write_opl3_A1
skip_write:
	inc	cl
.endw
	ret
mute_proc_near ENDP


;-------------------------------------------
; S`lɂ(֐e[uo^p)
; dl DrvProcTable ̐Q.
; S`l TL 63ɂ.
mute_proc PROC PRIVATE
	call	mute_proc_near
	retf
mute_proc ENDP

;-------------------------------------------
; t.
; dl DrvProcTable ̐Q.
play_proc PROC TSR_OPL3_PROC_VISIBILITY
	;--- T-VRAM()eXg.
IF _DEBUG
	push	es
	mov	ax, 0a200h
	mov	es, ax
	mov	bx, (80 * 2 * 12) + (8 / 2) ; 12sڂ8ڂ̑𑀍.
	mov	al, es:[bx]
	or	al, 14h ; ]Ac.
	sub	al, 20h ; F̕ύX.
	mov	es:[bx], al
	pop	es
ENDIF
	;--- OPL3 XVJn.
	mov	[opl3_write_proc], write_opl3_A0
	mov	[part_idx], 0
	mov	si, offset parts
	assume	si:ptr OPL3PartStatus
	;--- OPL3 XV[v.
	; XV[v͌ [si] XVΏۂ̃p[g OPL3PartStatus w.
opl3_upd_loop_start:
	test	[si].part_flags, OPL3_PART_FLAG_FINISHED
	jz	@F
	jmp	opl3_upd_loop_tail
@@:	mov	ax, [part_idx]
	cmp	ax, 9
	jb	part_idx_lt_9
	ja	@F
	mov	[opl3_write_proc], write_opl3_A1 ; part_idx == 9 ̎ɕύX.
@@:	sub	ax, 9
	mov	dx, 3
	jmp	@F
part_idx_lt_9:
	xor	dx, dx
@@:	add	dx, ax
	mov	[pi_mod9], al
	mov	[pi_mod9_A1_3], dl
	mov	di, ax
	mov	al, cs:[base_addends + di]
	mov	ah, cs:[base_addends + di + 3]
	mov	[base_addend], al
	mov	[base_addend_3], ah
	mov	[status_addr], si
	;--- XVJn_ł 4OP Ԃ擾 (di=pi_mod9, dl=pi_mod9_A1_3)
.if(di < 6)
	xor	bh, bh
	mov	bl, dl
	cmp	di, 3
	jae	@F
	mov	al, [connection_sel + bx]
	jmp	set_i4o
@@:	mov	al, [connection_sel + bx - 3]
	test	al, al
	jz	set_i4o
	or	al, I4O_4OP_SHITA
.else
	xor	al, al
.endif
set_i4o:
	mov	[is_4op_flags], al
	;--- main_counter `FbN(1) (al=is_4op_flags, di=pi_mod9)
	mov	ah, al			; ah = is_4op_flags
	mov	al, [si].main_counter
.if((al > 0) && (al != [si].keyoff_timing))
	; L[IL[ItsȂ LFO ƃ|^g̍XV.
	; FwႵ 4OP Ȃȗ.
	cmp	[si].voice_data, 0
	jz	dec_main_cnt
	test	ah, I4O_4OP_SHITA
	jnz	dec_main_cnt
	call	update_lfo_and_portament
dec_main_cnt:
	dec	[si].main_counter
	jmp	opl3_upd_loop_tail
.endif
	;--- keyoff_timing ɂL[It ((ah,al)=(is_4op_flags,main_counter), di=pi_mod9)
	mov	bx, ax			; save (is_4op_flags, main_counter)
	cmp	al, [si].keyoff_timing
	jnz	skip_keyoff		; L[It̃^C~OłȂ.
	test	[si].kon_val, 20h
	jz	skip_keyoff		; L[IĂȂ.
	test	ah, I4O_4OP_SHITA
	jnz	skip_keyoff		; 4OP ̉.
	cmp	[si].tie_status, OP_NOP
	jnz	skip_keyoff		; ^CX[.
	; L[It{.
	mov	al, BASE_KON_BLK_FNUM_H
	add	ax, di			; al += pi_mod9
	mov	ah, [si].kon_val
	and	ah, NOT 20h		; KON=0
	mov	[si].kon_val, ah	; KON=0 ۑ.
	call	[opl3_write_proc]	; KON=0 .
	; RR ݒ(Xbg1, 2)
	mov	bp, [si].voice_data
	inc	bp
	mov	cl, [base_addend]
	call	keyoff_set_rr
	add	bp, 5
	add	cl, 3
	call	keyoff_set_rr
	; RR ݒ(Xbg3, 4)
.if(bh == I4O_4OP)
	add	bp, 5
	mov	cl, [base_addend_3]
	call	keyoff_set_rr
	add	bp, 5
	add	cl, 3
	call	keyoff_set_rr
.endif
skip_keyoff:
	;--- main_counter `FbN(2)
	; ((bh,bl)=(is_4op_flags,main_counter), di=pi_mod9)
	test	bl, bl
	jz	@F
	dec	bl
	mov	[si].main_counter, bl
	jmp	opl3_upd_loop_tail
@@:	;--- L[I, x, tỈꂩoĂ܂ŉt߂.
	; [ṽWX^.
	; ds:si=̃p[g̃Xe[^X̃AhX.
	; di=play_ptr (es:[di]=Ώۋȃf[^)
	mov	di, [si].play_ptr
op_loop_head:
op_loop_continue::
	mov	bl, es:[di]		; bl = opcode
	cmp	bl, MAX_OP_NUM
	ja	@F
	; Ή鏈ɑ΂ăe[uWv.
	xor	bh, bh
	add	bx, bx			; word access
	jmp	cs:[TBL_OP_PROC + bx]
@@:	; .
.if((bl >= 70h) && (bl <= 0ebh))
	mov	bh, bl
	and	bh, 0fh
	cmp	bh, 0bh
	jbe	proc_keyon		; bl=note_op, di=play_ptr
.endif
.if((bl >= OP_PLAY_FNUM_BLK_0) && (bl <= OP_PLAY_FNUM_BLK_0 + N_FNUM_BLK_STORE))
	jmp	proc_keyon		; bl=note_op, di=play_ptr
.endif
@@:	; sȖ߂̏ꍇ͉t𒆒f.
	or	[si].part_flags, OPL3_PART_FLAG_FINISHED
op_loop_exit::
	mov	[si].play_ptr, di	; save play_ptr
opl3_upd_loop_tail:
	add	si, sizeof(OPL3PartStatus)
	mov	ax, [part_idx]
	inc	ax
	cmp	al, [n_parts]
	jae	@F
	mov	[part_idx], ax
	jmp	opl3_upd_loop_start
@@:	;--- OPL3 XVI.
	assume	si:nothing
	retf
play_proc ENDP


;--- fnum  blk ̒lvZ.
; : si=Xe[^Xւ̃|C^.
; ߒl: dx=new_fnum, ch=new_blk
; j: ax, dx, cx, di
; Oɐ͈͂̒l [si].note_op ɐݒ肵Ă.
calc_fnum_and_blk PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	mov	al, [si].note_op
.if(al <= OP_PLAY_FNUM_BLK_0 + N_FNUM_BLK_STORE)
	; Fnum, BLK ڎwL[I.
	xor	ah, ah
	sub	ax, OP_PLAY_FNUM_BLK_0
	add	ax, ax			; word access
	lea	di, [si].fnum_blk_store
	add	di, ax
	mov	dx, [di]
	mov	ch, dh
	and	dx, 3ffh
	shr	ch, 2			; and ch, 7 ͏ȗ (RpCMp)
.else
	mov	ah, al
	and	al, 0fh
	shr	ah, 4
	sub	ah, 7			; (ah, al) = (oct, note12)
	mov	cx, ax			; (ch, cl) = (oct, note12)
	xor	ah, ah			; ax = note12
	mov	di, ax
	add	di, di			; word access
	;---
	mov	dx, [si].fine_detune
	add	dx, [lfo_val_tune]	; dx = fine_detune ̍v.
	test	dx, dx
	jnz	fine_det_non_zero
	;--- fine_detune == 0 Ȃ12K fnum ɒڕϊe[u.
	mov	dx, cs:[fnum12_u16_det0 + di]
	jmp	apply_detune
fine_det_non_zero:
	;--- ׂf`[Kpꂽ fnum, blk vZ.
	mov	ax, cs:[conv_12_ocs_pos + di] ; ax = pos
	xor	cl, cl
	shl	ch, 2			; cx = (oct << 10)
	add	ax, cx			; pos += (oct << 10)
	test	dx, dx
	js	@F			; ?
	mov	cx, 8192 - 1
	sub	cx, ax			; グɑ₹]T.
	cmp	dx, cx
	jbe	L1
	mov	ax, 8192 - 1		; ]T𒴂Ă͑₹Ȃ̂ŃLbv.
	jmp	add_fine_det_end
L1:	add	ax, dx
	jmp	add_fine_det_end
@@:	add	ax, dx
	jns	add_fine_det_end	; ɂȂĂ߂.
	xor	ax, ax
add_fine_det_end:
	mov	cx, ax			; cx = pos
	mov	di, ax			; di = pos
	and	di, 1fh			; di = pos % 32 (step32)
	add	di, di			; word access
	mov	dx, cs:[coeff_ons_fracp_u16 + di]
	mov	di, ax			; di = pos
	shr	di, 5
	and	di, 1fh			; di = (pos >> 5) % 32 (note32)
	add	di, di			; word access
	mov	ax, cs:[fnum_ocs_u16 + di]
	mov	di, ax			; save ax
	mul	dx			; dx:ax = dx * ax
	shr	dx, 4			; dx = (dx:ax >> 20)
	adc	dx, 0			; ľܓ.
	add	dx, di
	shr	dx, 6
	adc	dx, 0			; ľܓ, dx = new_fnum
	shr	ch, 2			; ch = oct (pos >> 10)
.endif
apply_detune:	; ch=oct, dx=fnum
	mov	ax, [si].detune
	test	ax, ax
	js	@F			; ?
	mov	di, 3ffh		; fnum ̍ől.
	sub	di, dx			; new_fnum ɑl.
.if(di < ax)
	mov	dx, 3ffh
.else
	add	dx, ax
.endif
	jmp	add_det_end
@@:	add	dx, ax
	jns	add_det_end
	xor	dx, dx
add_det_end:
	ret			; ch=new_oct, dx=detuned_new_fnum
	assume	si:nothing
calc_fnum_and_blk ENDP

;--- fnum  blk ̒l.
; : dx=new_fnum, ch=new_blk, cl=slur_flag, si=Xe[^Xւ̃|C^.
; ߒl: .
; j: ax, dx, cx, di
write_fnum_and_blk PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	mov	ah, dl			; ah = fnum(l)
	mov	dl, ch			; (dh, dl) = (fnum(h), blk)
	mov	di, dx			; save (fnum(h), blk)
	mov	ch, [pi_mod9]
	mov	al, BASE_F_NUM_L
	add	al, ch			; al = BASE_F_NUM_L + pi_mod9
	call	[opl3_write_proc]
	mov	ax, di			; restore (fnum(h), blk)
	shl	al, 2
	or	ah, al			; ah = [000b|blk|fnum(h)]
	mov	al, BASE_KON_BLK_FNUM_H
	add	al, ch			; al = BASE_KON_BLK_FNUM_H + pi_mod9
	test	cl, cl
	jz	@F			; X[ȂL[It.
	mov	di, ax			; save (val, addr)
	call	[opl3_write_proc]
	mov	ax, di			; restore (val, addr)
@@:	or	ah, 20h			; KON=1
	mov	[si].kon_val, ah
	jmp	[opl3_write_proc]
	assume	si:nothing
write_fnum_and_blk ENDP

;--- LFO ̍XV LFO ̒l̎擾s.
; : si=Xe[^Xւ̃|C^.
; ߒl: .
; j: ax, dx, cx, bx, di
; ̊ȒP̂߂ɍXVƌvZ͕ʂ̃[vŎĂ.
update_and_calc_lfo PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	assume	di:ptr LFOStatus
	lea	di, [si].lfo
	mov	cl, N_LFO
	;--- XV[v.
upd_loop_start:
	mov	al, [di].status
	test	al, LFO_STM_ACTIVE
	jz	upd_loop_tail
	; Ȃ clock_counter XVȂ.
	test	al, LFO_STB_SYNCED
	jz	@F
	and	al, NOT LFO_STB_SYNCED
	mov	[di].status, al		; lfo.status &= ~(LFO_STB_SYNCED)
	jmp	upd_loop_tail
@@:	mov	al, [di].clock_counter
	test	al, al
	jz	@F
	dec	al
	mov	[di].clock_counter, al	; lfo.clock_counter -= 1
	jmp	upd_loop_tail
@@:	mov	al, [di].speed
	mov	[di].clock_counter, al	; lfo.clock_counter = lfo.speed
	mov	al, [di].step
	cbw				; ax = (g)al
	add	[di].lfo_val, ax	; lfo.lfo_val += lfo.step
	mov	al, [di].depth_counter
	test	al, al
	jz	@F
	dec	al
	mov	[di].depth_counter, al	; lfo.depth_counter -= 1
	jmp	upd_loop_tail
@@:	mov	al, [di].n_step
	mov	[di].depth_counter, al	; lfo.depth_counter = lfo.n_step
	xor	bh, bh
	mov	bl, [di].wave_type
	add	bx, bx			; word access
	jmp	cs:[TBL_LFO_UPDATE_SUBPROC + bx]
lfo_special_upd_end::
upd_loop_tail:
	add	di, sizeof(LFOStatus)
	dec	cl
	jnz	upd_loop_start
	;--- vZ[v.
	xor	ax, ax
	mov	[lfo_val_volumes + 0], ax
	mov	[lfo_val_volumes + 2], ax
	mov	[lfo_val_volumes + 4], ax
	mov	[lfo_val_volumes + 6], ax
	mov	[lfo_val_tune], ax
	mov	[lfo_on_flags], al
	lea	di, [si].lfo
	mov	cl, N_LFO
	mov	bx, [si].voice_data
	mov	al, es:[bx + 0]
	mov	ah, al
	and	ah, 10h
	shr	ah, 3
	and	al, 01h
	or	al, ah
	xor	ah, ah			; ax = cnt 0`3ɑΉl.
	mov	si, ax			; si ɕۑ.
	mov	ch, 4
.if([is_4op_flags] != I4O_4OP)
	mov	ch, 2			; ch = 4op ? 4 : 2
.endif
	;--- vZ[v.
calc_loop_start:
	mov	al, [di].status
.if(al & LFO_STB_TUNE)
	mov	bx, [di].lfo_val
	add	[lfo_val_tune], bx	; lfo_val_tune += lfo_val
	or	[lfo_on_flags], 80h
.endif
.if(al & LFO_STB_VOLUME)
	xor	ah, ah			; op_idx
	mov	al, 1			; mask
    vol_loop_start:
	mov	bl, [di].op_mask
	test	bl, bl
	jz	@F
	test	bl, al			; lfo.op_mask & mask
	jz	vol_loop_tail
	jmp	vol_lfo_add
    @@:	mov	bx, offset TBL_LFO_MASK_4OP
	cmp	ch, 4			; [is_4op_flags] == I4O_4OP ̑
	jz	@F
	mov	bx, offset TBL_LFO_MASK_2OP
    @@:	test	cs:[bx + si], al	; tbl[cnt03] & mask
	jnz	vol_loop_tail
    vol_lfo_add:
	xor	bh, bh
	mov	bl, ah			; bx = op_idx
	add	bx, bx			; word access
	mov	dx, [di].lfo_val
	add	[lfo_val_volumes + bx], dx ; lfo_val_volumes[op_idx] += lfo.lfo_val
	or	[lfo_on_flags], al	; lfo_on_flags |= mask
    vol_loop_tail:
	shl	al, 1			; mask <<= 1
	inc	ah			; op_idx += 1
	cmp	ah, ch
	jb	vol_loop_start
.endif
calc_loop_tail:
	add	di, sizeof(LFOStatus)
	dec	cl
	jnz	calc_loop_start
	;---
	mov	si, [status_addr]
	ret
;  LFO vZ̑ΏۃIy[^p}XN`.
; ((1 << op_idx)Ԗڂ bit  1 ȂZȂ)
TBL_LFO_MASK_2OP db 01b, 00b
TBL_LFO_MASK_4OP db 0111b, 0110b, 0101b, 0010b
	assume	di:nothing
	assume	si:nothing
update_and_calc_lfo ENDP
; g`ŗL̍XV.
	assume	di:ptr LFOStatus
update_triangle PROC TSR_OPL3_PROC_VISIBILITY
	mov	al, [di].section
	test	al, 01h
	jnz	@F
	neg	[di].step	; A->B, C->D ̐؂ւ step 𕄍].
@@:	inc	al
	and	al, 03h
	mov	[di].section, al
	jmp	lfo_special_upd_end
update_triangle ENDP
update_oneshot PROC TSR_OPL3_PROC_VISIBILITY
	mov	[di].step, 0
	jmp	lfo_special_upd_end
update_oneshot ENDP
	assume	di:nothing


;--- LFO  [KSL|TL] ߂.
; : al=IWi [KSL|TL], dx=lfo_volume_val
; ߒl: al=LFO  [KSL|TL]
; j: cx
calc_lfoed_ksl_tl PROC TSR_OPL3_PROC_VISIBILITY
	mov	cx, ax		; save ax
	and	ax, 3fh		; ax = (int16_t)(ksl_tl & 0x3f)
	test	dx, dx
	js	minus
	cmp	ax, dx
	jae	L2
	xor	ax, ax
	jmp	L1
L2:	sub	ax, dx
	jmp	L1
minus:	sub	ax, 3fh
	cmp	ax, dx
	jle	L3		; if(tl - 0x3f > lfo_val)
	mov	ax, 3fh
	jmp	L1
L3:	add	ax, 3fh		; 3fh Ă̂߂.
	sub	ax, dx
L1:	and	cl, 0c0h
	or	ax, cx		; ah=0 Ȃ̂ or ŕł.
	ret
calc_lfoed_ksl_tl ENDP

;---  LFO ̒lg [KSL|TL] (curr_ksl_tl_val) XV.
; : di=keyon_ksl_tl_ue* bx=keyon_ksl_tl_shita*
; ߒl: .
; j: ax, dx, cx
; keyon ̃AhX keyon - curr Ԃ̃ItZbgp curr ɏ.
;  LFO ĂȂꍇ keyon ̒l̂܂ curr ɃRs[.
update_lfoed_ksl_tl PROC TSR_OPL3_PROC_VISIBILITY
	mov	ah, [lfo_on_flags]
	;---
	mov	al, [di + 0]
.if(ah & 01h)
	mov	dx, [lfo_val_volumes + 0]
	call	calc_lfoed_ksl_tl
.endif
	mov	[di + 0 + CURR_KSL_TL_OFFSET], al
	;---
	mov	al, [di + 1]
.if(ah & 02h)
	mov	dx, [lfo_val_volumes + 2]
	call	calc_lfoed_ksl_tl
.endif
	mov	[di + 1 + CURR_KSL_TL_OFFSET], al
	;---
	test	bx, bx
	jz	L1
	mov	al, [bx + 0]
.if(ah & 04h)
	mov	dx, [lfo_val_volumes + 4]
	call	calc_lfoed_ksl_tl
.endif
	mov	[bx + 0 + CURR_KSL_TL_OFFSET], al
	;---
	mov	al, [bx + 1]
.if(ah & 08h)
	mov	dx, [lfo_val_volumes + 6]
	call	calc_lfoed_ksl_tl
.endif
	mov	[bx + 1 + CURR_KSL_TL_OFFSET], al
	;---
L1:	ret
update_lfoed_ksl_tl ENDP

;--- L[IɃ{[l [KSL|TL](keyon_ksl_tl_val) vZ.
; : di=keyon_ksl_tl_ue* bx=keyon_ksl_tl_shita*
; ߒl: .
; j: ax, dx, cx
update_volumed_ksl_tl PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	mov	ch, [si].volume		; ʕۑ.
	mov	si, [si].voice_data
	assume	si:nothing
	mov	cl, es:[si]		; cl = cnt
	;--- Xbg1 (2OP/4OP )
	mov	al, es:[si + 2 + 0]
.if(cl & 01h)
	mov	ah, ch
	call	calc_volumed_ksl_tl
.endif
	mov	[di + 0], al
	;--- Xbg2 (2OP F)
	test	bx, bx
	jnz	@F
	mov	al, es:[si + 2 + 5]
	mov	ah, ch
	call	calc_volumed_ksl_tl
	mov	[di + 1], al
	mov	si, [status_addr]
	ret
@@:	;--- Xbg2 (4OP F)
	mov	al, es:[si + 2 + 5]
.if(cl & 10h)
	mov	ah, ch
	call	calc_volumed_ksl_tl
.endif
	mov	[di + 1], al
	; Xbg3 (4OP F)
	mov	al, es:[si + 2 + 10]
.if(cl & 11h)
	mov	ah, ch
	call	calc_volumed_ksl_tl
.endif
	mov	[bx + 0], al
	; Xbg4 (4OP F)
	mov	al, es:[si + 2 + 15]
	mov	ah, ch
	call	calc_volumed_ksl_tl
	mov	[bx + 1], al
	mov	si, [status_addr]
	ret
update_volumed_ksl_tl ENDP

;--- ʒꂽ [KSL|TL] vZ.
; : ah=volume, al=[KSL|TL] ̂Ƃ̒l.
; ߒl: al=vZʂ[KSL|TL]
; j: ah, dx
calc_volumed_ksl_tl PROC TSR_OPL3_PROC_VISIBILITY
	mov	dh, al		; save [KSL|TL]
	mov	dl, 3fh
	and	al, dl
	sub	al, dl
	neg	al		; al = -(TL - 3fh) = 3fh - TL
	mul	ah		; ax = al * ah = TL * volume
	div	dl		; ax/dl -> al=, ah=] (dl=3fh)
	cmp	ah, 20h		; ah  20h(=3fh/2+1)ȏȂ,
	sbb	al, -1		; al1𑫂(ľܓ)
	sub	dl, al		; dl = new_tl = 3fh - tl
	mov	al, dh		; restore [KSL|TL]
	and	al, 0c0h	; al = [KSL|0]
	or	al, dl
	ret
calc_volumed_ksl_tl ENDP

;--- [KSL|TL] WX^ɏ.
; : ah=[KSL|TL], cl=addr_addend
; ߒl: .
; j: ax, dx
set_ksl_tl PROC TSR_OPL3_PROC_VISIBILITY
	mov	al, BASE_KSL_TL
	add	al, cl			; (ah, al) = ([KSL|TL], addr)
	jmp	[opl3_write_proc]
set_ksl_tl ENDP

;--- ʐݒ莞̋ʏ.
; : al=ݒ肷鉹, ds:si=p[gXe[^X̃AhX.
; ߒl: .
; j: ax, dx, cx, bx, di
update_volume PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	mov	[si].volume, al
.if([si].voice_data == 0)
	ret			; FwOȂ牽Ȃ.
.endif
	xor	bx, bx
	lea	di, [si].keyon_ksl_tl_val
.if([is_4op_flags] == I4O_4OP)
	mov	bx, THREE_NEXT_ADDEND
	add	bx, di
.endif
	jmp	update_volumed_ksl_tl
	assume	si:nothing
update_volume ENDP

;--- L[It RR  EGT ݒ肷.
; : bp=slot_voice*, cl=addr_addend
; ߒl: .
; j: ax, dx
keyoff_set_rr PROC TSR_OPL3_PROC_VISIBILITY
	mov	ax, es:[bp + 3] ; (ah, al) = (slot_voice[4], slot_voice[3])
	and	ax, 0f0f0h	; ah &= 0f0h, al &= 0f0h
	shr	ah, 4
	or	ah, al		; ah = [SR|RR]
	mov	al, BASE_SL_RR
	add	al, cl		; (ah, al) = (val, addr)
	call	[opl3_write_proc]
	mov	ah, es:[bp]
	or	ah, 20h
	mov	al, BASE_AM_VIB_EGT_KSR_ML
	add	al, cl		; (ah, al) = (val, addr)
	jmp	[opl3_write_proc]
keyoff_set_rr ENDP

;--- LFO  on ɂۂ̋ʕ(Xe[^X͌ĂяoŐݒ肷邱)
; : ds:bx=on ɂ LFOStatus ւ̃|C^.
; ߒl: .
; j: dx
on_lfo_common PROC TSR_OPL3_PROC_VISIBILITY
	assume	bx:ptr LFOStatus
	mov	dx, word ptr [bx].delay ; (dh, dl) = (n_step, delay)
	mov	word ptr [bx].clock_counter, dx
	mov	dl, [bx].orig_step
	mov	[bx].step, dl
	mov	[bx].section, LFO_SECTION_A
	mov	[bx].lfo_val, 0
	assume	bx:nothing
	ret
on_lfo_common ENDP

;--- LFO  off ۂ̋ʕ.
; ẐŃ}Nɂ.
; bx  assume ͓ɐݒ肵Ȃ̂Œ.
; : ds:bx=LFOStatus ւ̃|C^.
; ߒl: .
; j: .
off_lfo_macro MACRO
	mov	[bx].lfo_val, 0
	mov	[bx].status, LFO_ST_OFF
ENDM

;--- LFOStatus ւ̃|C^̃[h.
; : bl=lfo_idx, ds:si=Xe[^Xւ̃|C^.
; ߒl: ds:bx=lfo_idx Ԗڂ LFOStatus ւ̃|C^.
; j: .
load_lfo_status_ptr PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	xor	bh, bh
	add	bx, bx		; word access
	mov	bx, cs:[lfo_offset_tbl + bx]
	lea	bx, [si].lfo[bx]
	assume	si:nothing
	ret
load_lfo_status_ptr ENDP

;--- L[I SR, TL ̐ݒ.
; : ah=[KSL|TL], es:di=slot_voice*, cl=addr_addend
; ߒl: .
; j: ax, dx
keyon_set_sr_tl PROC TSR_OPL3_PROC_VISIBILITY
	call	set_ksl_tl
	mov	ah, es:[di]
	mov	al, BASE_AM_VIB_EGT_KSR_ML
	add	al, cl
	call	[opl3_write_proc]	; EGT=0
	mov	ah, es:[di + 3]
	mov	al, BASE_SL_RR
	add	al, cl			; (ah, al) = ([SL|RR], addr) (RR as SR)
	jmp	[opl3_write_proc]
keyon_set_sr_tl ENDP

;--- Fݒ莞 AR, DR, WS ݒ.
; : es:bp=slot_voice*, cl=addr_addend
; ߒl: .
; j: ax, dx
select_voice_set_ar_dr_ws PROC TSR_OPL3_PROC_VISIBILITY
	mov	ah, es:[bp + 2]
	mov	al, BASE_AR_DR
	add	al, cl
	call	[opl3_write_proc]	; (ah, al) = ([AR|DR], addr)
	mov	ah, es:[bp + 4]
	and	ah, 07h			; ah = ([RR|0b|WS] & 07h)
	mov	al, BASE_WS
	add	al, cl			; (ah, al) = ([WS], addr)
	jmp	[opl3_write_proc]
select_voice_set_ar_dr_ws ENDP

;--- L[IyуL[ItȂꍇ LFO ƃ|^g̍XV.
; : ds:si=Xe[^Xւ̃|C^.
; ߒl: .
; j: ax, dx, cx, bx, di
update_lfo_and_portament PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	; LFO XV
	call	update_and_calc_lfo
	mov	bl, [lfo_on_flags]
	; |^gXVƉ LFO ݔ (bl=lfo_on_flags)
	cmp	[si].portament.counter, 0
	jnz	Lport
	test	bl, 80h
	jnz	Lwtlfo
	jmp	@F
Lport:	; |^gXV( LFO ݂ɗꗎ)
	dec	[si].portament.counter
	mov	dx, [si].portament.diff_l
	mov	ax, [si].portament.diff_h
	add	[si].portament.val_l, dx
	adc	[si].portament.val_h, ax
	cmp	dh, 80h
	mov	ax, [si].portament.val_h
	sbb	ax, -1			; 16rbg̍ŏʌĎľܓ.
	add	[lfo_val_tune], ax
Lwtlfo:	; |^gƉ LFO ̌ʂ.
	test	[si].kon_val, 20h
	jz	@F			; keyon ̂ fnum  blk 𑀍삷.
	call	calc_fnum_and_blk
	xor	cl, cl			; dx=new_fnum, ch=new_blk, cl=slur_flag
	call	write_fnum_and_blk
	;  LFO ̌ʂWX^ɏ (bl=lfo_on_flags)
@@:	test	bl, 0fh
	jz	L_end
	xor	bx, bx
	lea	di, [si].keyon_ksl_tl_val
	cmp	[is_4op_flags], I4O_4OP
	jnz	@F
	mov	bx, THREE_NEXT_ADDEND
	add	bx, di		; bx = (&(part_status) + 3)->keyon_ksl_tl_val
@@:	call	update_lfoed_ksl_tl
	mov	cl, [base_addend]
	mov	ah, [si].curr_ksl_tl_val[0]
	call	set_ksl_tl
	add	cl, 3
	mov	ah, [si].curr_ksl_tl_val[1]
	call	set_ksl_tl
	test	bx, bx			; (ah == I4O_4OP) ̂Ƃ (bx != 0)
	jz	L_end
	add	si, THREE_NEXT_ADDEND
	mov	cl, [base_addend_3]
	mov	ah, [si].curr_ksl_tl_val[0]
	call	set_ksl_tl
	add	cl, 3
	mov	ah, [si].curr_ksl_tl_val[1]
	call	set_ksl_tl
	sub	si, THREE_NEXT_ADDEND
	assume	si:nothing
L_end:	ret
update_lfo_and_portament ENDP

;------------------------------------------- note_op
; ŗL̈: bl=note_op, es:di=ȃf[^.
proc_keyon PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	;--- Xe[^XXV.
	mov	[si].note_op, bl
	mov	al, es:[di + 1]
	mov	[si].main_counter, al
	add	di, 2
	;--- ^CŎ̔߂ƌqĂ邩`FbN.
	mov	ah, [si].tie_status			; ah = old_tie_status
	mov	al, es:[di] ; ̃^CȂ.
.if(al == OP_TIE || al == OP_SLUR)
	inc	di
.else
	mov	al, OP_NOP
.endif
	mov	[si].tie_status, al
	;--- L[If.
	test	[is_4op_flags], I4O_4OP_SHITA
	jnz	op_loop_exit		; 4OP .
	cmp	[si].voice_data, 0
	jz	op_loop_exit		; Fw.
	;--- ^CȊȌꍇL[Is(ah=old_tie_status)
	mov	bp, di				; save di
	push	ax				; save ah=old_tie_status
	cmp	ah, OP_TIE
	jnz	@F
	push	offset skip_keyon
	jmp	update_lfo_and_portament
@@:	; L[I LFO ̓.
	mov	cl, N_LFO
	lea	bx, [si].lfo
	assume	bx:ptr LFOStatus
lfo_sync_loop:
	mov	al, [bx].status
.if((al & LFO_STM_ACTIVE) && !(al & LFO_STB_NKSYNC))
	and	al, NOT LFO_STB_WAIT
	or	al, LFO_STB_SYNCED
	mov	[bx].status, al
	call	on_lfo_common
.endif
	add	bx, sizeof(LFOStatus)
	dec	cl
	jnz	lfo_sync_loop
	assume	bx:nothing
	; LFO vZ.
	call	update_and_calc_lfo
	xor	bx, bx
.if([lfo_on_flags] & 0fh)
	lea	di, [si].keyon_ksl_tl_val
	cmp	[is_4op_flags], I4O_4OP
	jnz	@F
	mov	bx, THREE_NEXT_ADDEND
	add	bx, di
@@:	call	update_lfoed_ksl_tl
	mov	bx, CURR_KSL_TL_OFFSET
.endif
	; Xbg1, 2 SR, TL ݒ (bx=ksl_tl_offset)
	mov	di, [si].voice_data
	inc	di
	mov	cl, [base_addend]
	mov	ah, [si].keyon_ksl_tl_val[0 + bx]
	call	keyon_set_sr_tl
	add	di, 5
	add	cl, 3
	mov	ah, [si].keyon_ksl_tl_val[1 + bx]
	call	keyon_set_sr_tl
	; Xbg3, 4 SR, TL ݒ.
.if([is_4op_flags] == I4O_4OP)
	add	si, THREE_NEXT_ADDEND
	add	di, 5
	mov	cl, [base_addend_3]
	mov	ah, [si].keyon_ksl_tl_val[0 + bx]
	call	keyon_set_sr_tl
	add	di, 5
	add	cl, 3
	mov	ah, [si].keyon_ksl_tl_val[1 + bx]
	call	keyon_set_sr_tl
	sub	si, THREE_NEXT_ADDEND
.endif
skip_keyon:
	pop	ax			; restore ah=old_tie_status
	;--- fnum, blk ݒ (ah=old_tie_status, bp=saved di)
	mov	bh, ah			; bh = old_tie_status
	call	calc_fnum_and_blk	; dx = new_fnum, ch = new_blk
	xor	cl, cl
	cmp	bh, OP_SLUR
	sbb	cl, -1			; OP_NOP < OP_TIE < OP_SLUR Ȃ̂ŉ.
	call	write_fnum_and_blk
	;--- keyoff_timing ̐ݒ (bp=saved di)
.if([si].tie_status != OP_NOP)
	mov	[si].keyoff_timing, 0
.else
	mov	al, [si].main_counter
	mov	dx, word ptr [si].gate_uQ	; (dh, dl) = (gate_lq, gate_uQ)
	; gate_uQ == 16 Ȃ1NbN.
	cmp	dl, 16
	jnz	@F
	mov	[si].keyoff_timing, al
	jmp	calc_gate_end
@@:	; gate_uQ == 0 Ȃ Q ɂL[ItʒuύXȂ.
	mov	cl, al		; save main_counter
	test	dl, dl
	jnz	@F
	xor	al, al
	jmp	calc_q
@@:	; gate_uQ != 16 ̏ꍇ Q ɂL[ItʒuvZ.
	inc	al	; {̔.
	mul	dl	; ax = (main_counter + 1) * gate_uQ
	shr	ax, 4	; ax /= 16
	adc	ax, 0	; ľܓ, al = Q lL[Itʒu.
calc_q:	; q ɂL[ItʒuvZ.
	add	al, dh	; al = Q,q 𗼕lL[Itʒu.
	jc	L4	; Q,q l 255 𒴂ꍇ.
	cmp	al, cl	; keyoff_timing  main_counter 𒴂Ȃ`FbN.
	jbe	@F
L4:	mov	al, cl
@@:	mov	[si].keyoff_timing, al
.endif
calc_gate_end:
	;---
	mov	di, bp			; restore di
	jmp	op_loop_exit
	assume	si:nothing
proc_keyon ENDP

;------------------------------------------- OP_NOP
proc_nop PROC TSR_OPL3_PROC_VISIBILITY
	inc	di
	jmp	op_loop_continue
proc_nop ENDP
;------------------------------------------- OP_SELECT_VOICE
proc_select_voice PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	;--- Ff[^ւ̃|C^ݒ.
	xor	bx, bx
	mov	bl, es:[di + 1]
	add	di, 2
	shl	bx, 2		; bx = idx * 4
	mov	ax, bx
	add	bx, bx		; bx = idx * 8
	add	bx, ax		; bx = idx * (4 + 8) = idx * 12
	add	bx, [voice_buf]
	mov	[si].voice_data, bx
	;--- 4OP FȂ珈Ȃ.
	mov	ch, [is_4op_flags]
	test	ch, I4O_4OP_SHITA
	jnz	op_loop_continue
	;--- ύX悪 2OP FL^.
	mov	bp, bx			; voice_data ۑ.
	mov	bl, es:[bx]
	test	bl, 80h
	jz	@F
	or	ch, I4O_2OP_VOICE
@@:	;--- ^CX[̏ꍇAFύXO TL=3fh ɂ.
	; (KSL ͌Őݒ肳̂Ŗ)
	cmp	[si].tie_status, OP_NOP
	jnz	skip_tl_3fh
	; Xbg1, 2
	mov	ah, 3fh
	mov	cl, [base_addend]
	mov	al, BASE_KSL_TL
	add	al, cl
	call	[opl3_write_proc]
	mov	ah, 3fh
	mov	al, BASE_KSL_TL + 3
	add	al, cl
	call	[opl3_write_proc]
	; Xbg3, 4
.if((ch & I4O_4OP) || !(ch & I4O_2OP_VOICE))
	mov	ah, 3fh
	mov	cl, [base_addend_3]
	mov	al, BASE_KSL_TL
	add	al, cl
	call	[opl3_write_proc]
	mov	ah, 3fh
	mov	al, BASE_KSL_TL + 3
	add	al, cl
	call	[opl3_write_proc]
.endif
skip_tl_3fh:
	;--- connection_sel ̏
	; (ch=is_4op_flags(I4O_2OP_VOICE ), bl=voice_data[0])
	cmp	ch, (I4O_4OP OR I4O_2OP_VOICE)
	jz	@F ; 4OP -> 2OP ɂȂꍇ(ch == (I4O_4OP OR I4O_2OP_VOICE))
	test	ch, ch
	jnz	skip_conn_sel	; 2OP -> 4OP ɂȂꍇ(ch == 0)
@@:	; 4OP/2OP ύXOʏ.
	xor	bx, bx
	mov	bl, [pi_mod9_A1_3]
	mov	cl, bl
	mov	al, 1
	shl	al, cl
	mov	ah, [connection_sel + 6]
.if(ch)	; 4OP -> 2OP ɂȂꍇ.
	not	al
	and	ah, al	; ah = connection_sel & (~(0x01 << (pi_mod9_A1_3)))
	xor	cx, cx ; (ch, cl) = ([connection_sel + bx], [is_4op_flags])
	; ̃p߂Ă.
	push	ax
	add	si, THREE_NEXT_ADDEND
	mov	ah, [si].panpot_val
	sub	si, THREE_NEXT_ADDEND
	mov	al, [pi_mod9]
	add	al, BASE_CHDCBA_FB_CNT + 3
	call	[opl3_write_proc]
	pop	ax
.else	; 2OP -> 4OP ɂȂꍇ.
	or	ah, al	; ah = connection_sel | (0x01 << (pi_mod9_A1_3))
	mov	cx, 0100h + I4O_4OP
.endif
	; connection_sel ݒ蕔.
	mov	[connection_sel + bx], ch
	mov	[is_4op_flags], cl
	mov	[connection_sel + 6], ah
	mov	al, 04h
	WRITE_OPL3_A1_AX	; (ah, al) = (connection_sel, 04h)
skip_conn_sel:
	;--- CH[DBCA], FB, CNT ݒ (bp=voice_data)
	mov	bx, bp			; bx = voice_data
	mov	al, [si].panpot_val
	and	al, 0f0h
	mov	ah, es:[bp]
	and	ah, 0fh
	or	ah, al
	mov	[si].panpot_val, ah
	mov	al, [pi_mod9]
	add	al, BASE_CHDCBA_FB_CNT
	call	[opl3_write_proc]
	;--- AR, DR, WS ݒ(Xbg1, 2)
	inc	bp
	mov	cl, [base_addend]
	call	select_voice_set_ar_dr_ws
	add	bp, 5
	add	cl, 3
	call	select_voice_set_ar_dr_ws
	;--- AR, DR, WS ݒ(Xbg3, 4)
	mov	ch, [is_4op_flags]
.if(ch == I4O_4OP)
	; CH[DBCA], FB, CNT ݒ(4OP )
	mov	al, [si].panpot_val
	and	al, 0f0h
	mov	ah, es:[bx]
	and	ah, 11h
	shr	ah, 4
	or	ah, al		;  CH[DCBA] ͏㑤Ƒ.
	mov	al, [pi_mod9]
	add	al, BASE_CHDCBA_FB_CNT + 3
	call	[opl3_write_proc]
	add	bp, 5
	mov	cl, [base_addend_3]
	call	select_voice_set_ar_dr_ws
	add	bp, 5
	add	cl, 3
	call	select_voice_set_ar_dr_ws
.endif
	;--- [KSL|TL] vZ(ch=is_4op_flags)
	mov	bp, di			; save di
	xor	bx, bx
	lea	di, [si].keyon_ksl_tl_val
.if(ch == I4O_4OP)
	mov	bx, THREE_NEXT_ADDEND
	add	bx, di
.endif
	call	update_volumed_ksl_tl
	mov	di, bp			; restore di
	jmp	op_loop_continue
	assume	si:nothing
proc_select_voice ENDP
;------------------------------------------- OP_REST
proc_rest PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	mov	al, es:[di + 1]
	mov	[si].main_counter, al
	mov	[si].note_op, OP_NOP
	add	di, 2
	jmp	op_loop_exit
	assume	si:nothing
proc_rest ENDP
;------------------------------------------- OP_PLAY_END
proc_play_end PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	mov	ax, [si].loop_start_pos
	test	ax, ax
	jz	@F
	mov	di, ax
	jmp	op_loop_continue
@@:	or	[si].part_flags, OPL3_PART_FLAG_FINISHED
	jmp	op_loop_exit
	assume	si:nothing
proc_play_end ENDP
;------------------------------------------- OP_SET_VOLUME
proc_set_volume PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	mov	al, es:[di + 1]
	add	di, 2
	mov	bp, di		; save di
	call	update_volume
	mov	di, bp		; restore di
	jmp	op_loop_continue
	assume	si:nothing
proc_set_volume ENDP
;------------------------------------------- OP_REPEAT_START
proc_repeat_start PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	mov	bx, [si].repeat_idx
	inc	bx
	mov	[si].repeat_idx, bx
	;--- repeat_counter[repeat_idx] = play_ptr[1]
	mov	al, es:[di + 1]
	mov	[si].repeat_counter[bx], al
	;--- repeat_start_ptr[i] = play_ptr + 4
	add	bx, bx			; word access
	mov	ax, di
	add	ax, 4
	mov	[si].repeat_start_ptr[bx], ax
	;--- repeat_end_ptr[i] = play_ptr + *((uint16_t*)(ptr + 2))
	mov	ax, es:[di + 2]
	add	ax, di
	mov	[si].repeat_end_ptr[bx], ax
	;---
	add	di, 4
	jmp	op_loop_continue
	assume	si:nothing
proc_repeat_start ENDP
;------------------------------------------- OP_REPEAT_ESCAPE
proc_repeat_escape PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	mov	bx, [si].repeat_idx
	cmp	[si].repeat_counter[bx], 1
	jnz	@F
	mov	cx, bx			; save bx
	add	bx, bx			; word access
	mov	ax, [si].repeat_end_ptr[bx]
	mov	di, ax
	dec	cx
	mov	[si].repeat_idx, cx
	jmp	op_loop_continue
@@:	inc	di
	jmp	op_loop_continue
	assume	si:nothing
proc_repeat_escape ENDP
;------------------------------------------- OP_REPEAT_END
proc_repeat_end PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	mov	bx, [si].repeat_idx
	mov	al, [si].repeat_counter[bx]
	cmp	al, 1
	jnz	@F
	dec	bx
	mov	[si].repeat_idx, bx
	inc	di
	jmp	op_loop_continue
@@:	dec	al
	mov	[si].repeat_counter[bx], al
	add	bx, bx			; word access
	mov	di, [si].repeat_start_ptr[bx]
	jmp	op_loop_continue
	assume	si:nothing
proc_repeat_end ENDP
;------------------------------------------- OP_DIRECT_OUT
proc_direct_out PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	mov	ax, es:[di + 1]		; (ah, al) = (data, addr)
	add	di, 3
	push	offset op_loop_continue
	jmp	[opl3_write_proc]
	assume	si:nothing
proc_direct_out ENDP
;------------------------------------------- OP_GATE_uQ
proc_gate_hQ PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	mov	al, es:[di + 1]
	mov	[si].gate_uQ, al
	add	di, 2
	jmp	op_loop_continue
	assume	si:nothing
proc_gate_hQ ENDP
;------------------------------------------- OP_GATE_lq
proc_gate_lq PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	mov	al, es:[di + 1]
	mov	[si].gate_lq, al
	add	di, 2
	jmp	op_loop_continue
	assume	si:nothing
proc_gate_lq ENDP
;------------------------------------------- OP_DETUNE
proc_detune PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	mov	ax, es:[di + 1]
	mov	[si].detune, ax
	add	di, 3
	jmp	op_loop_continue
	assume	si:nothing
proc_detune ENDP
;------------------------------------------- OP_LFO_SET_PARAM
proc_lfo_set_param PROC TSR_OPL3_PROC_VISIBILITY
	mov	bl, es:[di + 1]		; lfo_idx
	call	load_lfo_status_ptr
	assume	bx:ptr LFOStatus
	;--- p[^Rs[.
	mov	ax, es:[di + 2]	; (ah, al) = (n_step, delay)
	mov	word ptr [bx].delay, ax
	mov	ax, es:[di + 4]	; (ah, al) = (orig_step, speed)
	mov	word ptr [bx].speed, ax
	;--- LFO ~.
	off_lfo_macro
	;---
	assume	bx:nothing
	add	di, 6
	jmp	op_loop_continue
proc_lfo_set_param ENDP
;------------------------------------------- OP_LFO_SET_WAVE
proc_lfo_set_wave PROC TSR_OPL3_PROC_VISIBILITY
	mov	bl, es:[di + 1]		; lfo_idx
	call	load_lfo_status_ptr
	assume	bx:ptr LFOStatus
	;---
	mov	al, es:[di + 2]
	mov	[bx].wave_type, al
	;---
	off_lfo_macro
	;---
	assume	bx:nothing
	add	di, 3
	jmp	op_loop_continue
proc_lfo_set_wave ENDP
;------------------------------------------- OP_LFO_SWITCH
proc_lfo_switch PROC TSR_OPL3_PROC_VISIBILITY
	mov	bl, es:[di + 1]		; lfo_idx
	call	load_lfo_status_ptr
	assume	bx:ptr LFOStatus
	mov	al, es:[di + 2]		; switch value
	add	di, 3
	;---
	test	al, LFO_STB_TUNE OR LFO_STB_VOLUME
	jnz	@F
	;--- OFF ɂȂꍇ.
	off_lfo_macro
	jmp	op_loop_continue
	;--- ON ɂȂꍇ.
@@:	test	al, LFO_STB_NKSYNC
	jz	@F
	;--- L[IȂꍇ.
	or	al, LFO_STB_SYNCED
	mov	[bx].status, al
	push	offset op_loop_continue
	jmp	on_lfo_common
@@:	;--- L[Iꍇ.
	or	al, LFO_STB_WAIT
	mov	[bx].status, al
	assume	bx:nothing
	jmp	op_loop_continue
proc_lfo_switch ENDP
;------------------------------------------- OP_CHANGE_VOLUME
proc_change_volume PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	mov	al, [si].volume
	mov	ah, es:[di + 1]		; ω.
	add	di, 2
	add	al, ah			; ω̉.
	js	Lminus
	cmp	al, OPL3_VOL_MAX
	ja	@F
	jmp	Lupd
Lminus:	test	ah, ah
	xor	al, al			; ah < 0 Ȃ.
.if(!(sign?))
@@:	mov	al, OPL3_VOL_MAX	; I[o[t[ĕɂȂĂ.
.endif
Lupd:	mov	bp, di			; save di
	call	update_volume
	mov	di, bp			; restore di
	jmp	op_loop_continue
	assume	si:nothing
proc_change_volume ENDP
;------------------------------------------- OP_SET_PANPOT
proc_set_panpot PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	; ݏ̃p[g panpot_val ̒lXV.
	mov	ah, [si].panpot_val
	and	ah, 0fh
	or	ah, es:[di + 1]		; ah = new panpot
	mov	[si].panpot_val, ah
	add	di, 2			;  return ̂ŐɉZ.
	; 4OP Ȃ珑݂͂Ȃ.
	mov	dl, [is_4op_flags]
	test	dl, I4O_4OP_SHITA
	jz	@F
	jmp	op_loop_continue
@@:	mov	al, [pi_mod9]
	add	al, BASE_CHDCBA_FB_CNT
.if(dl & I4O_4OP)
	; 4OP ł͉ɏ̂ THREE_NEXT_ADDEND  panpot_val ČvZ.
	and	ah, 0f0h
	add	si, THREE_NEXT_ADDEND
	mov	dh, [si].panpot_val
	sub	si, THREE_NEXT_ADDEND
	and	dh, 0fh
	or	ah, dh
	add	al, 3
.endif
	;  (ah, al) = (panpot, addr)
	push	offset op_loop_continue
	jmp	[opl3_write_proc]
	assume	si:nothing
proc_set_panpot ENDP
;------------------------------------------- OP_PORTAMENT
proc_portament PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	mov	al, es:[di + 1]
	mov	[si].portament.counter, al
	mov	ax, es:[di + 2]
	mov	[si].portament.diff_l, ax
	mov	ax, es:[di + 4]
	mov	[si].portament.diff_h, ax
	xor	ax, ax
	mov	[si].portament.val_l, 0
	mov	[si].portament.val_h, 0
	add	di, 6
	jmp	op_loop_continue
	assume	si:nothing
proc_portament ENDP
;------------------------------------------- OP_LOOP_START_POS
proc_loop_start_pos PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	inc	di
	mov	[si].loop_start_pos, di
	jmp	op_loop_continue
	assume	si:nothing
proc_loop_start_pos ENDP
;------------------------------------------- OP_SET_TIMER_B
proc_set_timer_b PROC TSR_OPL3_PROC_VISIBILITY
	xor	ax, ax
	mov	al, es:[di + 1]			; new timer_b
	mov	bx, es:[di + 3]			; new timer_5m
	mov	cx, es:[di + 6]			; new timer_8m
	mov	dx, es:[di + 9]			; new timer_pc_at
	mov	bp, ds				; save ds
	mov	ds, cs:[proc_tbl].tsr_group_seg
	assume	ds:TSR_GROUP
	mov	ds:[new_timer_b_val], ax
	mov	ds:[new_timer_5m_val], bx
	mov	ds:[new_timer_8m_val], cx
	mov	ds:[new_timer_pc_at_val], dx
	mov	al, es:[di + 12]		; new timer_sb
	mov	dx, es:[di + 13]		; (dl,dh)=new(n_sample, n_wait)
	mov	ds:[new_timer_sb_val], ax
	mov	ds:[timer_sb_n_samples], dl
	mov	ds:[new_timer_n_wait], dh
	assume	ds:_TSR_OPL3_DATA
	add	di, 15
	mov	ds, bp				; restore ds
	jmp	op_loop_continue
	assume	si:nothing
proc_set_timer_b ENDP
;------------------------------------------- OP_HW_LFO_SET_PARAM
proc_hw_lfo_set_param PROC TSR_OPL3_PROC_VISIBILITY
	mov	ah, es:[di + 1]
	add	di, 2
	mov	al, 0bdh
	WRITE_OPL3_A0_AX
	jmp	op_loop_continue
proc_hw_lfo_set_param ENDP
;------------------------------------------- OP_SET_LFO_OP
proc_set_lfo_op PROC TSR_OPL3_PROC_VISIBILITY
	mov	bl, es:[di + 1]		; lfo_idx
	call	load_lfo_status_ptr
	assume	bx:ptr LFOStatus
	mov	al, es:[di + 2]
	mov	[bx].op_mask, al
	assume	bx:nothing
	add	di, 3
	jmp	op_loop_continue
proc_set_lfo_op ENDP
;------------------------------------------- OP_FINE_DETUNE
proc_fine_detune PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	mov	ax, es:[di + 1]
	mov	[si].fine_detune, ax
	add	di, 3
	jmp	op_loop_continue
	assume	si:nothing
proc_fine_detune ENDP
;------------------------------------------- OP_SET_FNUM_BLK
proc_set_fnum_blk PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	xor	bh, bh
	mov	bl, es:[di + 1]		; fnum_blk store index
	add	bx, bx			; word access
	mov	ax, es:[di + 2]
	mov	[si].fnum_blk_store[bx], ax
	add	di, 4
	jmp	op_loop_continue
	assume	si:nothing
proc_set_fnum_blk ENDP
;-------------------------------------------
IF 0
proc_x PROC TSR_OPL3_PROC_VISIBILITY
	assume	si:ptr OPL3PartStatus
	jmp	op_loop_continue
	assume	si:nothing
proc_x ENDP
ENDIF
;-------------------------------------------


tsr_opl3_tail:
_TSR_OPL3_TEXT ENDS


;==========================================================
; 풓R[h.
;----------------------------------------------------------
_TEXT SEGMENT PUBLIC USE16 'CODE'
	ASSUME	cs:_TEXT, ds:_TSR_OPL3_DATA

;--- void remove_opl3(uint16_t data_seg)
; OPL3 p풓.
; : ax=񂪏ĂZOg.
; ߒl: .
remove_opl3_ PROC PUBLIC
	push	ds
	pusha			; ȒP̂.
	;---
	mov	ds, ax
	;--- OPL3  NEW=0 ɂ.
	; TSR ݃[`͎gpȂ.
	; far call ŌĂяoKv邪݃[` ret ɂȂĂ.
	mov	dx, [driver_param].ioport.addr1
	mov	al, 05h
	out	dx, al
	WAIT_OPL3
	mov	dx, [driver_param].ioport.data1
	xor	al, al
	out	dx, al
	WAIT_OPL3
	;---
	popa
	pop	ds
	ret
remove_opl3_ ENDP

_TEXT ENDS

END
