texture tex0;

sampler smp0 = sampler_state
{
	Texture = <tex0>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU = Clamp;
	AddressV = Clamp;
};

struct VS_Output
{
	float4 pos : POSITION;
	float2 tex : TEXCOORD0;
};

uniform float2 tex0sz;
uniform float2 outsz;

VS_Output vs(float4 pos : POSITION,
             float4 col : COLOR0,
             float2 tex : TEXCOORD0)
{
	VS_Output o;
	o.pos = pos;
	o.tex = tex;
	return o;
}

float4 gaussian(sampler smp, float2 uv, float dx, float dy)
{
	const float2 dx2 = float2(dx, 0.0f);
	const float2 dy2 = float2(0.0f, dy);
	float4 col = 0.0f;
	col += tex2D(smp, uv - dx2 - dy2) * 1.0f;
	col += tex2D(smp, uv - dx2      ) * 2.0f;
	col += tex2D(smp, uv - dx2 + dy2) * 1.0f;
	col += tex2D(smp, uv -       dy2) * 2.0f;
	col += tex2D(smp, uv            ) * 4.0f;
	col += tex2D(smp, uv +       dy2) * 2.0f;
	col += tex2D(smp, uv + dx2 - dy2) * 1.0f;
	col += tex2D(smp, uv + dx2      ) * 2.0f;
	col += tex2D(smp, uv + dx2 + dy2) * 1.0f;
	return col / 16.0f;
}

float get_luminance(float4 col)
{
	// PAL, SECAM, BT.601, BT.709.
	return col.r * 0.299 + col.g * 0.587 + col.b * 0.114;
}

float gamma_curve(float x, float gamma)
{
	return pow(x, gamma);
}

float contrast(float x)
{
	// cos とガンマカーブでコントラストを調整.
	// もっとマシな実装はある気がする.
	float ret;
	ret = -(cos(3.141592f * x) - 1.0f) / 2.0f;
	ret = gamma_curve(ret, 0.78f);
	return ret;
}

float4 ps_ag_crt_effect(VS_Output input) : COLOR0
{
	// 出力画面でのピクセル位置.
	float2 uv = input.tex;
	const float oy = uv.y * outsz.y;
	const float ox = uv.x * outsz.x;

	// 画素の色.
	float r_coeff, g_coeff, b_coeff;
	const float fx3 = frac(ox / 3.0f);
	r_coeff = (fx3 < 0.3f) ? 1.0f : 0.0f;
	g_coeff = (0.3f <= fx3 && fx3 < 0.6f) ? 1.0f : 0.0f;
	b_coeff = (0.6f <= fx3) ? 1.0f : 0.0f;

	// 6行に1回の頻度で少し暗くする(走査線)
	const float fy6 = frac(oy / 6.0f);
	if (fy6 < 0.1f) {
		r_coeff *= 0.8f;
		g_coeff *= 0.8f;
		b_coeff *= 0.8f;
	}

	// 入力のサンプリング.
	float4 icol = gaussian(smp0, uv, 1.8f / outsz.x, 1.8f / outsz.y);
	const float il = get_luminance(icol);

	// 出力 3x3 範囲の上端下端の画素を暗くする.
	// 元の画素が暗いほど暗くする.
	const float fy3 = frac(oy / 3.0f);
	if (fy3 < 0.3f || 0.6f <= fy3) {
		icol.rgb *= 1.0f - ((1.0f - il) * 0.66f);
	}

	// RGB 値のみ残す.
	float or = icol.r * r_coeff;
	float og = icol.g * g_coeff;
	float ob = icol.b * b_coeff;

	// コントラスト調整.
	or = contrast(or);
	og = contrast(og);
	ob = contrast(ob);

	return float4(or, og, ob, 1.0f);
}

technique TShader
{
	pass P0
	{
		VertexShader = compile vs_3_0 vs();
		PixelShader  = compile ps_3_0 ps_ag_crt_effect();
	}
}
