# r15actrl version 0.1a

**RS-1500A control program**

IMAGENICS 社製アナログ RGB フレームシンクロナイザ RS-1500A をシリアル接続で制御するプログラムです。

JSON ファイルを読み込んで記載されている値を設定する機能と、現在の設定値を読み出して表示する機能があります。


## 内容物

- README.md
	- このファイルです。
- LICENSE
	- 本ソフトウェアのライセンスが記載されたファイルです。
- r15actrl.exe
	- 本ソフトウェアの実行ファイルです。
- Program.fs
	- 本ソフトウェアのソースコードです。


## 動作環境

Windows 10 22H2 (64bit 版) で動作確認しています。
実行には .NET 8.0 のランタイムが必要です。
.NET 8.0 を使っているので他の環境でも動くかもしれません。

制御用のシリアル接続が可能な IMAGENICS 社製製品は RS-1500A の他にもありますが、それらの機種での動作確認はできていません。
RS-1500A と仕様が同じであれば動作するかもしれません。

RS-1500A の制御コマンドの全てには対応していません。
作者が個人的に本ソフトウェアを制作する際に制御したいと思ったコマンドに対応しています。


## プログラムの使い方

プログラム実行時のコマンド書式は `r15actrl.exe [command] (options...)` です。

`[command]` には以下2種類の値を指定できます。

- `set`: JSON ファイルに書かれている設定値を RS-1500A に送信します。
- `get`: 本ソフトウェアがサポートしているコマンドの設定値を RS-1500A から読み出します。

### `set` コマンド

`set` コマンドの書式は `r15actrl.exe set [port] [json_path] [setting_name]` です。

各パラメータには以下の値を指定します。

- `port`: 通信に使うポート(`COM1` など)
- `json_path`: 設定値が書かれている JSON ファイルのパス
- `setting_name`: 設定値の名前 (後述の JSON ファイルの書式の説明を参照)

JSON ファイルは `get` コマンドの結果を利用して作るのが簡単だと思います。

RS-1500A へ設定値を送っている間、送信したデータと受信したデータが表示されます。

### `get` コマンド

`get` コマンドの書式は `r15actrl.exe get [port]` です。

`port` には通信に使うポート(`COM1` など)を指定します。

RS-1500A から設定値を読み取っている間、送信したデータと受信したデータが表示されます。
最後に、読み込んだ設定値に対応する JSON が表示されます。


## JSON ファイルの書式

`set` コマンドの際に指定する設定値が書かれた JSON ファイルの書式は以下のようになっています。

```json
{
	"settings": [
		{
			"name": "test1",
			"comment": "test1",
			"cmd_x": 0,
			"cmd_y": 10,
			"cmd_z": "some_value"
		},
		{
			"name": "test2",
			"comment": "test2",
			"cmd_a": -5,
			"cmd_b": "some_value",
		}
	]
}
```

`settings` のキーに対応した配列に設定値を記載したオブジェクトを複数書いておきます。

`name` は `set` コマンドの `setting_name` で指定する文字列です。
`comment` は設定値について任意のコメントを記載できます(`get` コマンドでは無視されます)。

`name` と `comment` の他に RS-1500A に送信したいコマンドとその値を書いておきます。
サポートしているコマンドの具体的な設定方法は後述のサポートしているコマンドの一覧を参照してください。

例えば、上記 JSON ファイルの例で `test2` の設定を `set` すると、JSON ファイルに書かれている `cmd_a` と `cmd_b` の値が RS-1500A に送られます。


## サポートしているコマンド一覧

サポートしているコマンドを以下の表に示します。
コマンドの詳細は省略します(RS-1500A の取扱説明書に記載されています)。
JSON でのコマンド名は RS-1500A の設定画面での名前に寄せてあります。

| RS-1500A のコマンド | JSON でのコマンド名 | JSON での値の種類 | 概略 |
|:--|:--|:--|:--|
| Aa | in_aspect_ratio | 文字列 | 入力映像のアスペクト比 |
| Di | in_auto_setup_mode | 文字列 | オートセットアップ自動起動設定 |
| Ea | out_resolusion | 文字列 | 出力解像度 |
| Ac | in_clock_phase | 数値 | 入力映像のクロックフェーズ |
| Ad | in_total_h_clock | 数値 | 入力映像の水平総クロック |
| Ae | in_shift_h_pixel | 数値 | 入力映像の水平位置 |
| Af | in_shift_v_pixel | 数値 | 入力映像の垂直位置 |
| Ag | in_reso_h_pixel | 数値 | 入力映像の水平有効画素数 |
| Ah | in_reso_v_pixel | 数値 | 入力映像の垂直有効画素数 |
| Ba | in_zoom_size | 数値 | ズームサイズ |
| De | in_adc_r | 数値 | 入力 ADC の R/PR ゲイン微調整 |
| Df | in_adc_g | 数値 | 入力 ADC の G/Y ゲイン微調整 |
| Dg | in_adc_b | 数値 | 入力 ADC の B/PB ゲイン微調整 |
| Ef | back_lumi | 数値 | 出力バックカラーのルミナンス |
| Eg | back_color | 数値 | 出力バックカラーのカラーレベル |
| Eh | back_hue | 数値 | 出力バックカラーの色相 |

### 文字列設定値一覧

前述のコマンド一覧表で JSON での値の種類が文字列となっているコマンドに設定できる文字列の一覧を以下に示します。

- `in_aspect_ratio` に設定可能な文字列
	- `Auto`: 自動判定処理
	- `FullAspect`: フルアスペクト処理
	- `Aspect4_3`: アスペクト比 4:3 として処理
	- `Aspect5_4`: アスペクト比 5:4 として処理
	- `Aspect15_9`: アスペクト比 15:9 として処理
	- `Aspect16_9`: アスペクト比 16:9 として処理
	- `Aspect16_10`: アスペクト比 16:10 として処理
	- `Aspect17_9`: アスペクト比 17:9 として処理
- `in_auto_setup_mode` に設定可能な文字列
	- `FullAuto`: 自動設定
	- `Manual`: 手動設定
	- `Off`: オフ
- `out_resolusion` に設定可能な文字列
	- `D2`: D2.480p
	- `D3`: D3.1080i
	- `D4`: D4.720p
	- `D5`: D5.1080p
	- `Reso640x480`: 640x480
	- `Reso1280x960`: 1280x960


## 作者・更新履歴

Y. Shiokami, mail: r-srd@outlook.jp

- 2024/08/24 version 0.1a
	- 初版
